/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactoryBase;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.providers.DetectorProvider;
import fiji.plugin.trackmate.providers.EdgeAnalyzerProvider;
import fiji.plugin.trackmate.providers.SpotAnalyzerProvider;
import fiji.plugin.trackmate.providers.SpotMorphologyAnalyzerProvider;
import fiji.plugin.trackmate.providers.TrackAnalyzerProvider;
import fiji.plugin.trackmate.providers.TrackerProvider;
import fiji.plugin.trackmate.providers.ViewProvider;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.visualization.TrackMateModelView;
import fiji.plugin.trackmate.visualization.ViewFactory;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class TmXmlReader {
    protected static final boolean DEBUG = true;
    protected Document document = null;
    protected final File file;
    protected ConcurrentHashMap<Integer, Spot> cache;
    protected Logger.StringBuilderLogger logger = new Logger.StringBuilderLogger();
    protected final Element root;
    protected boolean ok = true;

    public TmXmlReader(File file) {
        this.file = file;
        SAXBuilder sb = new SAXBuilder();
        Element r = null;
        try {
            this.document = sb.build(file);
            r = this.document.getRootElement();
        }
        catch (JDOMException e) {
            this.ok = false;
            this.logger.error("Problem parsing " + file.getName() + ", it is not a valid TrackMate XML file.\nError message is:\n" + e.getLocalizedMessage() + '\n');
        }
        catch (IOException e) {
            this.logger.error("Problem reading " + file.getName() + ".\nError message is:\n" + e.getLocalizedMessage() + '\n');
            this.ok = false;
        }
        this.root = r;
    }

    public String getLog() {
        Element logElement = this.root.getChild("Log");
        if (null != logElement) {
            return logElement.getTextTrim();
        }
        return "";
    }

    public String getGUIState() {
        Element guiel = this.root.getChild("GUIState");
        if (null != guiel) {
            String guiState = guiel.getAttributeValue("state");
            if (null == guiState) {
                this.logger.error("Could not find GUI state attribute. Returning defaults.\n");
                this.ok = false;
                return "ConfigureViews";
            }
            return guiState;
        }
        this.logger.error("Could not find GUI state element. Returning defaults.\n");
        this.ok = false;
        return "ConfigureViews";
    }

    public DisplaySettings getDisplaySettings() {
        Element dsel = this.root.getChild("DisplaySettings");
        if (null == dsel) {
            this.logger.error("Could not find the display-settings element. Returning user defaults.\n");
            this.ok = false;
            return DisplaySettingsIO.readUserDefault();
        }
        return DisplaySettingsIO.fromJson(dsel.getText());
    }

    public Collection<TrackMateModelView> getViews(ViewProvider provider, Model model, Settings settings, SelectionModel selectionModel, DisplaySettings displaySettings) {
        Element guiel = this.root.getChild("GUIState");
        if (null != guiel) {
            List children = guiel.getChildren("View");
            ArrayList<TrackMateModelView> views = new ArrayList<TrackMateModelView>(children.size());
            for (Element child : children) {
                String viewKey = child.getAttributeValue("key");
                if (null == viewKey) {
                    this.logger.error("Could not find view key attribute for element " + child + ".\n");
                    this.ok = false;
                    continue;
                }
                if (viewKey.equals("TRACKSCHEME")) continue;
                ViewFactory factory = (ViewFactory)provider.getFactory(viewKey);
                if (null == factory) {
                    this.logger.error("Unknown view factory for key " + viewKey + ".\n");
                    this.ok = false;
                    continue;
                }
                TrackMateModelView view = factory.create(model, settings, selectionModel, displaySettings);
                if (null == view) {
                    this.logger.error("Unknown view for key " + viewKey + ".\n");
                    this.ok = false;
                    continue;
                }
                views.add(view);
            }
            return views;
        }
        this.logger.error("Could not find GUI state element.\n");
        this.ok = false;
        return new ArrayList<TrackMateModelView>();
    }

    public Model getModel() {
        Element modelElement = this.root.getChild("Model");
        if (null == modelElement) {
            return null;
        }
        Model model = this.createModel();
        String spaceUnits = modelElement.getAttributeValue("spatialunits");
        String timeUnits = modelElement.getAttributeValue("timeunits");
        model.setPhysicalUnits(spaceUnits, timeUnits);
        this.readFeatureDeclarations(modelElement, model);
        SpotCollection spots = this.getSpots(modelElement);
        model.setSpots(spots, false);
        if (!this.readTracks(modelElement, model)) {
            this.ok = false;
        }
        try {
            Map<Integer, Map<String, Double>> savedFeatureMap = this.readTrackFeatures(modelElement);
            for (Integer savedKey : savedFeatureMap.keySet()) {
                Map<String, Double> savedFeatures = savedFeatureMap.get(savedKey);
                for (String feature : savedFeatures.keySet()) {
                    model.getFeatureModel().putTrackFeature(savedKey, feature, savedFeatures.get(feature));
                }
            }
        }
        catch (RuntimeException re) {
            this.logger.error("Problem populating track features:\n");
            this.logger.error(re.getMessage());
            this.ok = false;
        }
        return model;
    }

    protected Model createModel() {
        return new Model();
    }

    public ImagePlus readImage() {
        Element settingsElement = this.root.getChild("Settings");
        if (null == settingsElement) {
            return null;
        }
        return this.getImage(settingsElement);
    }

    public Settings readSettings(ImagePlus imp) {
        return this.readSettings(imp, new DetectorProvider(), new TrackerProvider(), new SpotAnalyzerProvider(imp == null ? 1 : imp.getNChannels()), new EdgeAnalyzerProvider(), new TrackAnalyzerProvider(), new SpotMorphologyAnalyzerProvider(imp == null ? 1 : imp.getNChannels()));
    }

    public Settings readSettings(ImagePlus imp, DetectorProvider detectorProvider, TrackerProvider trackerProvider, SpotAnalyzerProvider spotAnalyzerProvider, EdgeAnalyzerProvider edgeAnalyzerProvider, TrackAnalyzerProvider trackAnalyzerProvider, SpotMorphologyAnalyzerProvider spotMorphologyAnalyzerProvider) {
        FeatureFilter initialFilter;
        Element settingsElement = this.root.getChild("Settings");
        if (null == settingsElement) {
            return null;
        }
        Settings settings = new Settings(imp);
        settings.addAllAnalyzers();
        this.getBaseSettings(settingsElement, settings);
        if (null != detectorProvider) {
            this.getDetectorSettings(settingsElement, settings, detectorProvider);
        }
        if (null != trackerProvider) {
            this.getTrackerSettings(settingsElement, settings, trackerProvider);
        }
        if (null != (initialFilter = this.getInitialFilter(settingsElement))) {
            settings.initialSpotFilterValue = initialFilter.value;
        }
        List<FeatureFilter> spotFilters = this.getSpotFeatureFilters(settingsElement);
        settings.setSpotFilters(spotFilters);
        List<FeatureFilter> trackFilters = this.getTrackFeatureFilters(settingsElement);
        settings.setTrackFilters(trackFilters);
        this.readAnalyzers(settingsElement, settings, spotAnalyzerProvider, edgeAnalyzerProvider, trackAnalyzerProvider, spotMorphologyAnalyzerProvider);
        return settings;
    }

    public String getVersion() {
        return this.root.getAttribute("version").getValue();
    }

    public String getErrorMessage() {
        return this.logger.toString();
    }

    public boolean isReadingOk() {
        return this.ok;
    }

    private ImagePlus getImage(Element settingsElement) {
        File imageFile;
        Element imageInfoElement = settingsElement.getChild("ImageData");
        String filename = imageInfoElement.getAttributeValue("filename");
        String folder = imageInfoElement.getAttributeValue("folder");
        if (null == filename || filename.isEmpty()) {
            this.logger.error("Cannot find image file name in xml file.\n");
            this.ok = false;
            return null;
        }
        if (null == folder || folder.isEmpty()) {
            folder = this.file.getParent();
        }
        if (!((imageFile = new File(folder, filename)).exists() && imageFile.canRead() || (imageFile = new File(folder = this.file.getParent(), filename)).exists() && imageFile.canRead())) {
            this.logger.error("Cannot read image file: " + imageFile + ".\n");
            this.ok = false;
            return null;
        }
        return IJ.openImage((String)imageFile.getAbsolutePath());
    }

    private Map<Integer, Map<String, Double>> readTrackFeatures(Element modelElement) {
        HashMap<Integer, Map<String, Double>> featureMap = new HashMap<Integer, Map<String, Double>>();
        Element allTracksElement = modelElement.getChild("AllTracks");
        if (null == allTracksElement) {
            this.logger.error("Cannot find the track collection in file.\n");
            this.ok = false;
            return null;
        }
        List trackElements = allTracksElement.getChildren("Track");
        for (Element trackElement : trackElements) {
            int trackID = -1;
            try {
                trackID = trackElement.getAttribute("TRACK_ID").getIntValue();
            }
            catch (DataConversionException e1) {
                this.logger.error("Found a track with invalid trackID for " + trackElement + ". Skipping.\n");
                this.ok = false;
                continue;
            }
            HashMap<String, Double> trackMap = new HashMap<String, Double>();
            List attributes = trackElement.getAttributes();
            for (Attribute attribute : attributes) {
                String attName = attribute.getName();
                if (attName.equals("name")) continue;
                Double attVal = Double.NaN;
                try {
                    attVal = attribute.getDoubleValue();
                }
                catch (DataConversionException e) {
                    this.logger.error("Track " + trackID + ": Cannot read the feature " + attName + " value. Skipping.\n");
                    this.ok = false;
                    continue;
                }
                trackMap.put(attName, attVal);
            }
            featureMap.put(trackID, trackMap);
        }
        return featureMap;
    }

    protected FeatureFilter getInitialFilter(Element settingsElement) {
        Element itEl = settingsElement.getChild("InitialSpotFilter");
        String feature = itEl.getAttributeValue("feature");
        Double value = IOUtils.readDoubleAttribute(itEl, "value", this.logger);
        boolean isAbove = IOUtils.readBooleanAttribute(itEl, "isabove", this.logger);
        FeatureFilter ft = new FeatureFilter(feature, value, isAbove);
        return ft;
    }

    protected List<FeatureFilter> getSpotFeatureFilters(Element settingsElement) {
        ArrayList<FeatureFilter> featureThresholds = new ArrayList<FeatureFilter>();
        Element ftCollectionEl = settingsElement.getChild("SpotFilterCollection");
        List ftEls = ftCollectionEl.getChildren("Filter");
        for (Element ftEl : ftEls) {
            String feature = ftEl.getAttributeValue("feature");
            Double value = IOUtils.readDoubleAttribute(ftEl, "value", this.logger);
            boolean isAbove = IOUtils.readBooleanAttribute(ftEl, "isabove", this.logger);
            FeatureFilter ft = new FeatureFilter(feature, value, isAbove);
            featureThresholds.add(ft);
        }
        return featureThresholds;
    }

    protected List<FeatureFilter> getTrackFeatureFilters(Element settingsElement) {
        ArrayList<FeatureFilter> featureThresholds = new ArrayList<FeatureFilter>();
        Element ftCollectionEl = settingsElement.getChild("TrackFilterCollection");
        List ftEls = ftCollectionEl.getChildren("Filter");
        for (Element ftEl : ftEls) {
            String feature = ftEl.getAttributeValue("feature");
            Double value = IOUtils.readDoubleAttribute(ftEl, "value", this.logger);
            boolean isAbove = IOUtils.readBooleanAttribute(ftEl, "isabove", this.logger);
            FeatureFilter ft = new FeatureFilter(feature, value, isAbove);
            featureThresholds.add(ft);
        }
        return featureThresholds;
    }

    private void getBaseSettings(Element settingsElement, Settings settings) {
        Element infoEl;
        Element settingsEl = settingsElement.getChild("BasicSettings");
        if (null != settingsEl) {
            settings.zstart = IOUtils.readIntAttribute(settingsEl, "zstart", this.logger, 1);
            settings.zend = IOUtils.readIntAttribute(settingsEl, "zend", this.logger, 10);
            settings.tstart = IOUtils.readIntAttribute(settingsEl, "tstart", this.logger, 1);
            settings.tend = IOUtils.readIntAttribute(settingsEl, "tend", this.logger, 10);
        }
        if (null != (infoEl = settingsElement.getChild("ImageData"))) {
            settings.dx = IOUtils.readDoubleAttribute(infoEl, "pixelwidth", this.logger);
            settings.dy = IOUtils.readDoubleAttribute(infoEl, "pixelheight", this.logger);
            settings.dz = IOUtils.readDoubleAttribute(infoEl, "voxeldepth", this.logger);
            settings.dt = IOUtils.readDoubleAttribute(infoEl, "timeinterval", this.logger);
            settings.width = IOUtils.readIntAttribute(infoEl, "width", this.logger, 512);
            settings.height = IOUtils.readIntAttribute(infoEl, "height", this.logger, 512);
            settings.nslices = IOUtils.readIntAttribute(infoEl, "nslices", this.logger, 1);
            settings.nframes = IOUtils.readIntAttribute(infoEl, "nframes", this.logger, 1);
            settings.imageFileName = infoEl.getAttributeValue("filename");
            settings.imageFolder = infoEl.getAttributeValue("folder");
        }
    }

    protected void getDetectorSettings(Element settingsElement, Settings settings, DetectorProvider provider) {
        Element element = settingsElement.getChild("DetectorSettings");
        if (null == element) {
            this.logger.error("Could not find the detector element in file.\n");
            this.ok = false;
            return;
        }
        String detectorKey = element.getAttributeValue("DETECTOR_NAME");
        if (null == detectorKey) {
            this.logger.error("Could not find the detector key element in file.\n");
            this.ok = false;
            return;
        }
        SpotDetectorFactoryBase factory = (SpotDetectorFactoryBase)provider.getFactory(detectorKey);
        if (null == factory) {
            this.logger.error("The detector identified by the key " + detectorKey + " is unknown to TrackMate.\n");
            this.ok = false;
            return;
        }
        settings.detectorFactory = factory;
        HashMap<String, Object> ds = new HashMap<String, Object>();
        this.ok = factory.unmarshall(element, ds);
        settings.detectorSettings = ds;
        if (!this.ok) {
            this.logger.error(factory.getErrorMessage());
        }
    }

    protected void getTrackerSettings(Element settingsElement, Settings settings, TrackerProvider provider) {
        Element element = settingsElement.getChild("TrackerSettings");
        if (null == element) {
            this.logger.error("Could not find the tracker element in file.\n");
            this.ok = false;
            return;
        }
        HashMap<String, Object> ds = new HashMap<String, Object>();
        String trackerKey = element.getAttributeValue("TRACKER_NAME");
        if (null == trackerKey) {
            this.logger.error("Could not find the tracker key element in file.\n");
            this.ok = false;
            return;
        }
        SpotTrackerFactory factory = (SpotTrackerFactory)provider.getFactory(trackerKey);
        if (null == factory) {
            this.logger.error("The tracker identified by the key " + trackerKey + " is unknown to TrackMate.\n");
            this.ok = false;
            return;
        }
        settings.trackerFactory = factory;
        boolean lOk = factory.unmarshall(element, ds);
        if (lOk) {
            settings.trackerSettings = ds;
        } else {
            this.logger.error("Problem reading the tracker settings:\n" + factory.getErrorMessage());
            this.logger.error("Substituting default tracker settings.\n");
            settings.trackerSettings = factory.getDefaultSettings();
        }
    }

    private SpotCollection getSpots(Element modelElement) {
        Element spotCollection = modelElement.getChild("AllSpots");
        List frameContent = spotCollection.getChildren("SpotsInFrame");
        int nspots = IOUtils.readIntAttribute(spotCollection, "nspots", Logger.VOID_LOGGER);
        if (nspots == 0) {
            for (Element currentFrameContent : frameContent) {
                nspots += currentFrameContent.getChildren("Spot").size();
            }
        }
        this.cache = new ConcurrentHashMap(nspots);
        int currentFrame = 0;
        HashMap<Integer, Set<Spot>> content = new HashMap<Integer, Set<Spot>>(frameContent.size());
        for (Element currentFrameContent : frameContent) {
            currentFrame = IOUtils.readIntAttribute(currentFrameContent, "frame", this.logger);
            List spotContent = currentFrameContent.getChildren("Spot");
            HashSet<Spot> spotSet = new HashSet<Spot>(spotContent.size());
            for (Element spotElement : spotContent) {
                Spot spot = this.createSpotFrom(spotElement);
                spotSet.add(spot);
                this.cache.put(spot.ID(), spot);
            }
            content.put(currentFrame, spotSet);
        }
        SpotCollection allSpots = SpotCollection.fromMap(content);
        return allSpots;
    }

    protected boolean readTracks(Element modelElement, Model model) {
        Element allTracksElement = modelElement.getChild("AllTracks");
        List trackElements = allTracksElement.getChildren("Track");
        SimpleWeightedGraph graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        HashMap<Integer, Set<Spot>> connectedVertexSet = new HashMap<Integer, Set<Spot>>(trackElements.size());
        HashMap<Integer, Set<DefaultWeightedEdge>> connectedEdgeSet = new HashMap<Integer, Set<DefaultWeightedEdge>>(trackElements.size());
        HashMap<Integer, String> savedTrackNames = new HashMap<Integer, String>(trackElements.size());
        FeatureModel fm = model.getFeatureModel();
        Collection<String> edgeFeatures = fm.getEdgeFeatures();
        Map<String, Boolean> edgeFeatureIsInt = fm.getEdgeFeatureIsInt();
        for (Element trackElement : trackElements) {
            int trackID = IOUtils.readIntAttribute(trackElement, "TRACK_ID", this.logger);
            String trackName = trackElement.getAttributeValue("name");
            if (null == trackName) {
                trackName = "Unnamed";
            }
            List edgeElements = trackElement.getChildren("Edge");
            HashSet<DefaultWeightedEdge> edges = new HashSet<DefaultWeightedEdge>(edgeElements.size());
            HashSet<Spot> spots = new HashSet<Spot>(edgeElements.size());
            for (Element edgeElement : edgeElements) {
                int sourceID = IOUtils.readIntAttribute(edgeElement, "SPOT_SOURCE_ID", this.logger);
                int targetID = IOUtils.readIntAttribute(edgeElement, "SPOT_TARGET_ID", this.logger);
                Spot sourceSpot = this.cache.get(sourceID);
                Spot targetSpot = this.cache.get(targetID);
                double weight = 0.0;
                if (null != edgeElement.getAttribute("LINK_COST")) {
                    weight = IOUtils.readDoubleAttribute(edgeElement, "LINK_COST", this.logger);
                }
                if (null == sourceSpot) {
                    this.logger.error("Unknown spot ID: " + sourceID + "\n");
                    return false;
                }
                if (null == targetSpot) {
                    this.logger.error("Unknown spot ID: " + targetID + "\n");
                    return false;
                }
                if (sourceSpot.equals(targetSpot)) {
                    this.logger.error("Bad link for track " + trackID + ". Source = Target with ID: " + sourceID + "\n");
                    return false;
                }
                spots.add(sourceSpot);
                spots.add(targetSpot);
                graph.addVertex((Object)sourceSpot);
                graph.addVertex((Object)targetSpot);
                DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.addEdge((Object)sourceSpot, (Object)targetSpot);
                if (edge == null) {
                    this.logger.error("Bad edge found for track " + trackID + "\n");
                    return false;
                }
                graph.setEdgeWeight((Object)edge, weight);
                for (String feature : edgeFeatures) {
                    if (null == edgeElement.getAttribute(feature)) continue;
                    double val = edgeFeatureIsInt.get(feature) != false ? (double)IOUtils.readIntAttribute(edgeElement, feature, this.logger) : IOUtils.readDoubleAttribute(edgeElement, feature, this.logger);
                    fm.putEdgeFeature(edge, feature, val);
                }
                edges.add(edge);
            }
            connectedVertexSet.put(trackID, spots);
            connectedEdgeSet.put(trackID, edges);
            savedTrackNames.put(trackID, trackName);
        }
        Set<Integer> savedFilteredTrackIDs = this.readFilteredTrackIDs(modelElement);
        HashMap<Integer, Boolean> visibility = new HashMap<Integer, Boolean>(connectedEdgeSet.size());
        HashSet ids = new HashSet(connectedEdgeSet.keySet());
        for (Integer id : savedFilteredTrackIDs) {
            visibility.put(id, Boolean.TRUE);
        }
        ids.removeAll(savedFilteredTrackIDs);
        for (Integer id : ids) {
            visibility.put(id, Boolean.FALSE);
        }
        model.getTrackModel().from((SimpleWeightedGraph<Spot, DefaultWeightedEdge>)graph, connectedVertexSet, connectedEdgeSet, visibility, savedTrackNames);
        return true;
    }

    private Set<Integer> readFilteredTrackIDs(Element modelElement) {
        Element filteredTracksElement = modelElement.getChild("FilteredTracks");
        if (null == filteredTracksElement) {
            this.logger.error("Could not find the filtered track IDs in file.\n");
            this.ok = false;
            return null;
        }
        Element allTracksElement = modelElement.getChild("AllTracks");
        if (null == allTracksElement) {
            this.logger.error("Could not find the track collection in file.\n");
            this.ok = false;
            return null;
        }
        List trackElements = allTracksElement.getChildren("Track");
        int[] IDs = new int[trackElements.size()];
        int index = 0;
        for (Element trackElement : trackElements) {
            int trackID;
            IDs[index] = trackID = IOUtils.readIntAttribute(trackElement, "TRACK_ID", this.logger);
            ++index;
        }
        Arrays.sort(IDs);
        List elements = filteredTracksElement.getChildren("TrackID");
        HashSet<Integer> filteredTrackIndices = new HashSet<Integer>(elements.size());
        for (Element indexElement : elements) {
            int trackID = IOUtils.readIntAttribute(indexElement, "TRACK_ID", this.logger);
            int search = Arrays.binarySearch(IDs, trackID);
            if (search < 0) {
                this.logger.error("Invalid filtered track index: " + trackID + ". Track ID does not exist.\n");
                this.ok = false;
                continue;
            }
            filteredTrackIndices.add(trackID);
        }
        return filteredTrackIndices;
    }

    private Spot createSpotFrom(Element spotEl) {
        int ID = IOUtils.readIntAttribute(spotEl, "ID", this.logger);
        Spot spot = new Spot(ID);
        List atts = spotEl.getAttributes();
        TmXmlReader.removeAttributeFromName(atts, "ID");
        String name = spotEl.getAttributeValue("name");
        if (null == name || name.equals("")) {
            name = "ID" + ID;
        }
        spot.setName(name);
        TmXmlReader.removeAttributeFromName(atts, "name");
        int roiNPoints = IOUtils.readIntAttribute(spotEl, "ROI_N_POINTS", Logger.VOID_LOGGER);
        if (roiNPoints > 2) {
            double[] xrois = new double[roiNPoints];
            double[] yrois = new double[roiNPoints];
            String str = spotEl.getText();
            String[] vals = str.split("\\s+");
            int index = 0;
            for (int i = 0; i < roiNPoints; ++i) {
                double y;
                double x;
                xrois[i] = x = Double.parseDouble(vals[index++]);
                yrois[i] = y = Double.parseDouble(vals[index++]);
            }
            spot.setRoi(new SpotRoi(xrois, yrois));
        }
        TmXmlReader.removeAttributeFromName(atts, "ROI_N_POINTS");
        for (Attribute att : atts) {
            if (att.getName().equals("name") || att.getName().equals("ID")) continue;
            spot.putFeature(att.getName(), Double.valueOf(att.getValue()));
        }
        return spot;
    }

    protected static final void removeAttributeFromName(List<Attribute> attributes, String attributeNameToRemove) {
        ArrayList<Attribute> toRemove = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            if (!attribute.getName().equals(attributeNameToRemove)) continue;
            toRemove.add(attribute);
        }
        attributes.removeAll(toRemove);
    }

    private void readFeatureDeclarations(Element modelElement, Model model) {
        FeatureModel fm = model.getFeatureModel();
        Element featuresElement = modelElement.getChild("FeatureDeclarations");
        if (null == featuresElement) {
            this.logger.error("Could not find feature declarations in file.\n");
            this.ok = false;
            return;
        }
        Element spotFeaturesElement = featuresElement.getChild("SpotFeatures");
        if (null == spotFeaturesElement) {
            this.logger.error("Could not find spot feature declarations in file.\n");
            this.ok = false;
        } else {
            List children = spotFeaturesElement.getChildren("Feature");
            ArrayList<String> features = new ArrayList<String>(children.size());
            HashMap<String, String> featureNames = new HashMap<String, String>(children.size());
            HashMap<String, String> featureShortNames = new HashMap<String, String>(children.size());
            HashMap<String, Dimension> featureDimensions = new HashMap<String, Dimension>(children.size());
            HashMap<String, Boolean> isIntFeature = new HashMap<String, Boolean>();
            for (Object child : children) {
                this.readSingleFeatureDeclaration((Element)child, features, featureNames, featureShortNames, featureDimensions, isIntFeature);
            }
            fm.declareSpotFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
        }
        Element edgeFeaturesElement = featuresElement.getChild("EdgeFeatures");
        if (null == edgeFeaturesElement) {
            this.logger.error("Could not find edge feature declarations in file.\n");
            this.ok = false;
        } else {
            List children = edgeFeaturesElement.getChildren("Feature");
            ArrayList<String> features = new ArrayList<String>(children.size());
            HashMap<String, String> featureNames = new HashMap<String, String>(children.size());
            HashMap<String, String> featureShortNames = new HashMap<String, String>(children.size());
            HashMap<String, Dimension> featureDimensions = new HashMap<String, Dimension>(children.size());
            HashMap<String, Boolean> isIntFeature = new HashMap<String, Boolean>(children.size());
            for (Element child : children) {
                this.readSingleFeatureDeclaration(child, features, featureNames, featureShortNames, featureDimensions, isIntFeature);
            }
            fm.declareEdgeFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
        }
        Element trackFeaturesElement = featuresElement.getChild("TrackFeatures");
        if (null == trackFeaturesElement) {
            this.logger.error("Could not find track feature declarations in file.\n");
            this.ok = false;
        } else {
            List children = trackFeaturesElement.getChildren("Feature");
            ArrayList<String> features = new ArrayList<String>(children.size());
            HashMap<String, String> featureNames = new HashMap<String, String>(children.size());
            HashMap<String, String> featureShortNames = new HashMap<String, String>(children.size());
            HashMap<String, Dimension> featureDimensions = new HashMap<String, Dimension>(children.size());
            HashMap<String, Boolean> isIntFeature = new HashMap<String, Boolean>();
            for (Element child : children) {
                this.readSingleFeatureDeclaration(child, features, featureNames, featureShortNames, featureDimensions, isIntFeature);
            }
            fm.declareTrackFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
        }
    }

    private void readAnalyzers(Element settingsElement, Settings settings, SpotAnalyzerProvider spotAnalyzerProvider, EdgeAnalyzerProvider edgeAnalyzerProvider, TrackAnalyzerProvider trackAnalyzerProvider, SpotMorphologyAnalyzerProvider spotMorphologyAnalyzerProvider) {
        String key;
        List children;
        Element analyzersEl = settingsElement.getChild("AnalyzerCollection");
        if (null == analyzersEl) {
            this.logger.error("Could not find the feature analyzer element.\n");
            this.ok = false;
            return;
        }
        if (null != spotAnalyzerProvider) {
            Element spotAnalyzerEl = analyzersEl.getChild("SpotAnalyzers");
            if (null == spotAnalyzerEl) {
                this.logger.error("Could not find the spot analyzer element.\n");
                this.ok = false;
            } else if (settings.imp == null) {
                this.logger.error("The source image is not loaded; cannot instantiates spot analyzers.\n");
                this.ok = false;
            } else {
                children = spotAnalyzerEl.getChildren("Analyzer");
                for (Element child : children) {
                    key = child.getAttributeValue("key");
                    if (null == key) {
                        this.logger.error("Could not find analyzer name for element " + child + ".\n");
                        this.ok = false;
                        continue;
                    }
                    SpotAnalyzerFactoryBase spotAnalyzer = spotAnalyzerProvider.getFactory(key);
                    if (null == spotAnalyzer) {
                        spotAnalyzer = spotMorphologyAnalyzerProvider.getFactory(key);
                    }
                    if (null == spotAnalyzer) {
                        this.logger.error("Unknown spot analyzer key: " + key + ".\n");
                        this.ok = false;
                        continue;
                    }
                    settings.addSpotAnalyzerFactory(spotAnalyzer);
                }
            }
        }
        if (null != edgeAnalyzerProvider) {
            Element edgeAnalyzerEl = analyzersEl.getChild("EdgeAnalyzers");
            if (null == edgeAnalyzerEl) {
                this.logger.error("Could not find the edge analyzer element.\n");
                this.ok = false;
            } else {
                children = edgeAnalyzerEl.getChildren("Analyzer");
                for (Element child : children) {
                    key = child.getAttributeValue("key");
                    if (null == key) {
                        this.logger.error("Could not find analyzer name for element " + child + ".\n");
                        this.ok = false;
                        continue;
                    }
                    EdgeAnalyzer edgeAnalyzer = (EdgeAnalyzer)edgeAnalyzerProvider.getFactory(key);
                    if (null == edgeAnalyzer) {
                        this.logger.error("Unknown edge analyzer key: " + key + ".\n");
                        this.ok = false;
                        continue;
                    }
                    settings.addEdgeAnalyzer(edgeAnalyzer);
                }
            }
        }
        if (null != trackAnalyzerProvider) {
            Element trackAnalyzerEl = analyzersEl.getChild("TrackAnalyzers");
            if (null == trackAnalyzerEl) {
                this.logger.error("Could not find the track analyzer element.\n");
                this.ok = false;
            } else {
                children = trackAnalyzerEl.getChildren("Analyzer");
                for (Element child : children) {
                    key = child.getAttributeValue("key");
                    if (null == key) {
                        this.logger.error("Could not find analyzer name for element " + child + ".\n");
                        this.ok = false;
                        continue;
                    }
                    TrackAnalyzer trackAnalyzer = (TrackAnalyzer)trackAnalyzerProvider.getFactory(key);
                    if (null == trackAnalyzer) {
                        this.logger.error("Unknown track analyzer key: " + key + ".\n");
                        this.ok = false;
                        continue;
                    }
                    settings.addTrackAnalyzer(trackAnalyzer);
                }
            }
        }
    }

    private void readSingleFeatureDeclaration(Element child, Collection<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, Dimension> featureDimensions, Map<String, Boolean> isIntFeature) {
        String feature = child.getAttributeValue("feature");
        if (null == feature) {
            this.logger.error("Could not find feature declaration for element " + child + ".\n");
            this.ok = false;
            return;
        }
        String featureName = child.getAttributeValue("name");
        if (null == featureName) {
            this.logger.error("Could not find name for feature " + feature + ".\n");
            this.ok = false;
            return;
        }
        String featureShortName = child.getAttributeValue("shortname");
        if (null == featureShortName) {
            this.logger.error("Could not find short name for feature " + feature + ".\n");
            this.ok = false;
            return;
        }
        Dimension featureDimension = Dimension.valueOf(child.getAttributeValue("dimension"));
        if (null == featureDimension) {
            this.logger.error("Could not find dimension for feature " + feature + ".\n");
            this.ok = false;
            return;
        }
        boolean isInt = false;
        try {
            isInt = child.getAttribute("isint").getBooleanValue();
        }
        catch (Exception e) {
            this.logger.error("Could not read the isInt attribute for feature " + feature + ".\n");
            this.ok = false;
        }
        features.add(feature);
        featureNames.put(feature, featureName);
        featureShortNames.put(feature, featureShortName);
        featureDimensions.put(feature, featureDimension);
        isIntFeature.put(feature, isInt);
    }
}

