/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.detector;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.MaskDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.components.detector.ThresholdDetectorConfigurationPanel;
import java.util.Map;

public class MaskDetectorConfigurationPanel
extends ThresholdDetectorConfigurationPanel {
    private static final long serialVersionUID = 1L;

    public MaskDetectorConfigurationPanel(Settings settings, Model model) {
        super(settings, model, "<html>This detector creates spots from a black and white mask.<p>More precisely, all the pixels in the designated channel that have a value strictly larger than 0 are considered as part of the foreground, and used to build connected regions. In 2D, spots are created with the (possibly simplified) contour of the region. In 3D, a spherical spot is created for each region in its center, with a volume equal to the region volume.<p>The spot quality stores the object area or volume in pixels.</html>", "Mask detector");
        this.ftfIntensityThreshold.setVisible(false);
        this.btnAutoThreshold.setVisible(false);
        this.lblIntensityThreshold.setVisible(false);
    }

    @Override
    public Map<String, Object> getSettings() {
        Map<String, Object> lSettings = super.getSettings();
        lSettings.remove("INTENSITY_THRESHOLD");
        return lSettings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.sliderChannel.setValue((Integer)settings.get("TARGET_CHANNEL"));
        this.chkboxSimplify.setSelected((Boolean)settings.get("SIMPLIFY_CONTOURS"));
    }

    @Override
    protected SpotDetectorFactory<?> getDetectorFactory() {
        return new MaskDetectorFactory();
    }
}

