/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.detector;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.LogDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.util.DetectionPreview;
import ij.ImagePlus;
import ij.measure.Calibration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class LogDetectorConfigurationPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private static final NumberFormat FORMAT = new DecimalFormat("#.###");
    protected JFormattedTextField ftfQualityThreshold;
    protected JCheckBox jCheckBoxMedianFilter;
    protected JFormattedTextField ftfDiameter;
    protected JCheckBox jCheckSubPixel;
    protected JSlider sliderChannel;
    private final ImagePlus imp;

    public LogDetectorConfigurationPanel(Settings settings, Model model, String infoText, String detectorName) {
        this.imp = settings.imp;
        this.setPreferredSize(new Dimension(300, 461));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.setLayout(gridBagLayout);
        JLabel jLabelSegmenterName = new JLabel(detectorName);
        jLabelSegmenterName.setFont(Fonts.BIG_FONT);
        GridBagConstraints gbcLabelSegmenterName = new GridBagConstraints();
        gbcLabelSegmenterName.anchor = 10;
        gbcLabelSegmenterName.fill = 1;
        gbcLabelSegmenterName.insets = new Insets(5, 5, 5, 5);
        gbcLabelSegmenterName.gridwidth = 4;
        gbcLabelSegmenterName.gridx = 0;
        gbcLabelSegmenterName.gridy = 0;
        this.add((Component)jLabelSegmenterName, gbcLabelSegmenterName);
        GridBagConstraints gbcLabelHelpText = new GridBagConstraints();
        gbcLabelHelpText.fill = 1;
        gbcLabelHelpText.insets = new Insets(5, 5, 5, 5);
        gbcLabelHelpText.gridwidth = 4;
        gbcLabelHelpText.gridx = 0;
        gbcLabelHelpText.gridy = 1;
        this.add((Component)GuiUtils.textInScrollPanel(GuiUtils.infoDisplay(infoText)), gbcLabelHelpText);
        JLabel lblSegmentInChannel = new JLabel("Detect in channel:");
        lblSegmentInChannel.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcSegmentInChannel = new GridBagConstraints();
        gbcSegmentInChannel.gridwidth = 2;
        gbcSegmentInChannel.anchor = 13;
        gbcSegmentInChannel.insets = new Insets(5, 5, 5, 5);
        gbcSegmentInChannel.gridx = 0;
        gbcSegmentInChannel.gridy = 2;
        this.add((Component)lblSegmentInChannel, gbcSegmentInChannel);
        this.sliderChannel = new JSlider();
        GridBagConstraints gbc_sliderChannel = new GridBagConstraints();
        gbc_sliderChannel.fill = 1;
        gbc_sliderChannel.insets = new Insets(5, 5, 5, 5);
        gbc_sliderChannel.gridx = 2;
        gbc_sliderChannel.gridy = 2;
        this.add((Component)this.sliderChannel, gbc_sliderChannel);
        JLabel labelChannel = new JLabel("1");
        labelChannel.setHorizontalAlignment(0);
        labelChannel.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLabelChannel = new GridBagConstraints();
        gbcLabelChannel.anchor = 17;
        gbcLabelChannel.fill = 3;
        gbcLabelChannel.insets = new Insets(5, 5, 5, 5);
        gbcLabelChannel.gridx = 3;
        gbcLabelChannel.gridy = 2;
        this.add((Component)labelChannel, gbcLabelChannel);
        JLabel jLabelEstimDiameter = new JLabel();
        GridBagConstraints gbc_jLabel2 = new GridBagConstraints();
        gbc_jLabel2.anchor = 13;
        gbc_jLabel2.insets = new Insets(5, 5, 5, 5);
        gbc_jLabel2.gridwidth = 2;
        gbc_jLabel2.gridx = 0;
        gbc_jLabel2.gridy = 3;
        this.add((Component)jLabelEstimDiameter, gbc_jLabel2);
        jLabelEstimDiameter.setText("Estimated object diameter:");
        jLabelEstimDiameter.setFont(Fonts.SMALL_FONT);
        this.ftfDiameter = new JFormattedTextField(FORMAT);
        this.ftfDiameter.setHorizontalAlignment(0);
        this.ftfDiameter.setValue(10.0);
        GridBagConstraints gbcTextFieldBlobDiameter = new GridBagConstraints();
        gbcTextFieldBlobDiameter.anchor = 15;
        gbcTextFieldBlobDiameter.fill = 2;
        gbcTextFieldBlobDiameter.insets = new Insets(5, 5, 5, 5);
        gbcTextFieldBlobDiameter.gridx = 2;
        gbcTextFieldBlobDiameter.gridy = 3;
        this.add((Component)this.ftfDiameter, gbcTextFieldBlobDiameter);
        this.ftfDiameter.setFont(Fonts.SMALL_FONT);
        JLabel jLabelBlobDiameterUnit = new JLabel();
        GridBagConstraints gbcLabelBlobDiameterUnit = new GridBagConstraints();
        gbcLabelBlobDiameterUnit.fill = 1;
        gbcLabelBlobDiameterUnit.insets = new Insets(5, 5, 5, 5);
        gbcLabelBlobDiameterUnit.gridx = 3;
        gbcLabelBlobDiameterUnit.gridy = 3;
        this.add((Component)jLabelBlobDiameterUnit, gbcLabelBlobDiameterUnit);
        jLabelBlobDiameterUnit.setFont(Fonts.SMALL_FONT);
        jLabelBlobDiameterUnit.setText(model.getSpaceUnits());
        JLabel jLabelThreshold = new JLabel();
        GridBagConstraints gbcLabelThreshold = new GridBagConstraints();
        gbcLabelThreshold.anchor = 13;
        gbcLabelThreshold.insets = new Insets(5, 5, 5, 5);
        gbcLabelThreshold.gridwidth = 2;
        gbcLabelThreshold.gridx = 0;
        gbcLabelThreshold.gridy = 4;
        this.add((Component)jLabelThreshold, gbcLabelThreshold);
        jLabelThreshold.setText("Quality threshold:");
        jLabelThreshold.setFont(Fonts.SMALL_FONT);
        this.ftfQualityThreshold = new JFormattedTextField(FORMAT);
        this.ftfQualityThreshold.setHorizontalAlignment(0);
        this.ftfQualityThreshold.setValue(0.0);
        GridBagConstraints gbcTextFieldThreshold = new GridBagConstraints();
        gbcTextFieldThreshold.fill = 1;
        gbcTextFieldThreshold.insets = new Insets(5, 5, 5, 5);
        gbcTextFieldThreshold.gridx = 2;
        gbcTextFieldThreshold.gridy = 4;
        this.add((Component)this.ftfQualityThreshold, gbcTextFieldThreshold);
        this.ftfQualityThreshold.setFont(Fonts.SMALL_FONT);
        JLabel lblPreProcess = new JLabel("Pre-process with median filter:");
        lblPreProcess.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcPreProcess = new GridBagConstraints();
        gbcPreProcess.gridwidth = 2;
        gbcPreProcess.anchor = 13;
        gbcPreProcess.insets = new Insets(5, 5, 5, 5);
        gbcPreProcess.gridx = 0;
        gbcPreProcess.gridy = 5;
        this.add((Component)lblPreProcess, gbcPreProcess);
        this.jCheckBoxMedianFilter = new JCheckBox();
        GridBagConstraints gbcCheckBoxMedianFilter = new GridBagConstraints();
        gbcCheckBoxMedianFilter.anchor = 11;
        gbcCheckBoxMedianFilter.fill = 2;
        gbcCheckBoxMedianFilter.insets = new Insets(5, 5, 5, 5);
        gbcCheckBoxMedianFilter.gridwidth = 2;
        gbcCheckBoxMedianFilter.gridx = 2;
        gbcCheckBoxMedianFilter.gridy = 5;
        this.add((Component)this.jCheckBoxMedianFilter, gbcCheckBoxMedianFilter);
        this.jCheckBoxMedianFilter.setFont(Fonts.FONT);
        JLabel lblSubPixelLoc = new JLabel("Sub-pixel localization:");
        lblSubPixelLoc.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcSubPixelLoc = new GridBagConstraints();
        gbcSubPixelLoc.anchor = 13;
        gbcSubPixelLoc.gridwidth = 2;
        gbcSubPixelLoc.insets = new Insets(5, 5, 5, 5);
        gbcSubPixelLoc.gridx = 0;
        gbcSubPixelLoc.gridy = 6;
        this.add((Component)lblSubPixelLoc, gbcSubPixelLoc);
        this.jCheckSubPixel = new JCheckBox();
        GridBagConstraints gbcCheckSubPixel = new GridBagConstraints();
        gbcCheckSubPixel.anchor = 11;
        gbcCheckSubPixel.fill = 2;
        gbcCheckSubPixel.insets = new Insets(5, 5, 5, 5);
        gbcCheckSubPixel.gridwidth = 2;
        gbcCheckSubPixel.gridx = 2;
        gbcCheckSubPixel.gridy = 6;
        this.add((Component)this.jCheckSubPixel, gbcCheckSubPixel);
        this.jCheckSubPixel.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcPreview = new GridBagConstraints();
        gbcPreview.gridwidth = 5;
        gbcPreview.insets = new Insets(0, 0, 10, 0);
        gbcPreview.fill = 1;
        gbcPreview.gridx = 0;
        gbcPreview.gridy = 7;
        DetectionPreview detectionPreview = DetectionPreview.create().model(model).settings(settings).detectorFactory(this.getDetectorFactory()).detectionSettingsSupplier(() -> this.getSettings()).thresholdTextField(this.ftfQualityThreshold).get();
        this.add((Component)detectionPreview.getPanel(), gbcPreview);
        int nChannels = settings.imp.getNChannels();
        this.sliderChannel.setMaximum(nChannels);
        this.sliderChannel.setMinimum(1);
        this.sliderChannel.setValue(settings.imp.getChannel());
        if (nChannels <= 1) {
            labelChannel.setVisible(false);
            lblSegmentInChannel.setVisible(false);
            this.sliderChannel.setVisible(false);
        } else {
            labelChannel.setVisible(true);
            lblSegmentInChannel.setVisible(true);
            this.sliderChannel.setVisible(true);
        }
        this.sliderChannel.addChangeListener(e -> labelChannel.setText("" + this.sliderChannel.getValue()));
        GuiUtils.selectAllOnFocus(this.ftfDiameter);
        GuiUtils.selectAllOnFocus(this.ftfQualityThreshold);
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>(5);
        int targetChannel = this.sliderChannel.getValue();
        double expectedRadius = ((Number)this.ftfDiameter.getValue()).doubleValue() / 2.0;
        double threshold = ((Number)this.ftfQualityThreshold.getValue()).doubleValue();
        boolean useMedianFilter = this.jCheckBoxMedianFilter.isSelected();
        boolean doSubPixelLocalization = this.jCheckSubPixel.isSelected();
        lSettings.put("TARGET_CHANNEL", targetChannel);
        lSettings.put("RADIUS", expectedRadius);
        lSettings.put("THRESHOLD", threshold);
        lSettings.put("DO_MEDIAN_FILTERING", useMedianFilter);
        lSettings.put("DO_SUBPIXEL_LOCALIZATION", doSubPixelLocalization);
        return lSettings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.sliderChannel.setValue((Integer)settings.get("TARGET_CHANNEL"));
        double radius = (Double)settings.get("RADIUS");
        if (this.imp != null) {
            double max;
            Calibration calibration = this.imp.getCalibration();
            double maxWidth = (double)this.imp.getWidth() * 0.5 * (calibration == null ? 1.0 : calibration.pixelWidth);
            double maxHeight = (double)this.imp.getHeight() * 0.5 * (calibration == null ? 1.0 : calibration.pixelHeight);
            double d = max = maxWidth < maxHeight ? maxWidth : maxHeight;
            if (radius > max) {
                radius *= max * 4.0 / (double)(this.imp.getWidth() + this.imp.getHeight());
            }
            double pw = calibration == null ? 1.0 : calibration.pixelWidth;
            radius = Math.max(radius / pw, 1.5) * pw;
        }
        this.ftfDiameter.setValue(2.0 * radius);
        this.jCheckBoxMedianFilter.setSelected((Boolean)settings.get("DO_MEDIAN_FILTERING"));
        this.ftfQualityThreshold.setValue(((Number)settings.get("THRESHOLD")).doubleValue());
        this.jCheckSubPixel.setSelected((Boolean)settings.get("DO_SUBPIXEL_LOCALIZATION"));
    }

    protected SpotDetectorFactory<?> getDetectorFactory() {
        return new LogDetectorFactory();
    }

    @Override
    public void clean() {
    }
}

