/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;
import org.jgrapht.util.TypeUtil;

public class SortedDepthFirstIterator<V, E>
extends AbstractGraphIterator<V, E> {
    private static final int CCS_BEFORE_COMPONENT = 1;
    private static final int CCS_WITHIN_COMPONENT = 2;
    private static final int CCS_AFTER_COMPONENT = 3;
    private static final Object SENTINEL = new Object();
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private final ConnectedComponentTraversalEvent ccFinishedEvent = new ConnectedComponentTraversalEvent((Object)this, 32);
    private final ConnectedComponentTraversalEvent ccStartedEvent = new ConnectedComponentTraversalEvent((Object)this, 31);
    private Iterator<V> vertexIterator = null;
    protected Map<V, VisitColor> seen = new HashMap<V, VisitColor>();
    private V startVertex;
    protected Specifics<V, E> specifics;
    protected final Comparator<V> comparator;
    private int state = 1;

    public SortedDepthFirstIterator(Graph<V, E> g, V startVertex, Comparator<V> comparator) {
        super(g);
        this.comparator = comparator;
        this.specifics = SortedDepthFirstIterator.createGraphSpecifics(g);
        this.vertexIterator = g.vertexSet().iterator();
        this.setCrossComponentTraversal(startVertex == null);
        if (startVertex == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (g.containsVertex(startVertex)) {
            this.startVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public boolean hasNext() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.state == 2) {
                this.state = 3;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentFinished(this.ccFinishedEvent);
                }
            }
            if (this.isCrossComponentTraversal()) {
                while (this.vertexIterator.hasNext()) {
                    V v = this.vertexIterator.next();
                    if (this.seen.containsKey(v)) continue;
                    this.encounterVertex(v, null);
                    this.state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public V next() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.state == 1) {
                this.state = 2;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentStarted(this.ccStartedEvent);
                }
            }
            V nextVertex = this.provideNextVertex();
            if (this.nListeners != 0) {
                this.fireVertexTraversed(this.createVertexTraversalEvent(nextVertex));
            }
            this.addUnseenChildrenOf(nextVertex);
            return nextVertex;
        }
        throw new NoSuchElementException();
    }

    private void finishVertex(V vertex) {
        if (this.nListeners != 0) {
            this.fireVertexFinished(this.createVertexTraversalEvent(vertex));
        }
    }

    private static <V, E> Specifics<V, E> createGraphSpecifics(Graph<V, E> g) {
        if (g.getType().isDirected()) {
            return new DirectedSpecifics<V, E>(g);
        }
        return new UndirectedSpecifics<V, E>(g);
    }

    protected void addUnseenChildrenOf(V vertex) {
        ArrayList<Object> sortedChildren = new ArrayList<Object>();
        HashMap<Object, E> localEdges = new HashMap<Object, E>();
        for (E e : this.specifics.edgesOf(vertex)) {
            Object oppositeV = Graphs.getOppositeVertex((Graph)this.graph, e, vertex);
            if (!this.seen.containsKey(oppositeV)) {
                sortedChildren.add(oppositeV);
            }
            localEdges.put(oppositeV, e);
        }
        Collections.sort(sortedChildren, Collections.reverseOrder(this.comparator));
        for (Object e : sortedChildren) {
            if (this.nListeners != 0) {
                this.fireEdgeTraversed(this.createEdgeTraversalEvent(localEdges.get(e)));
            }
            if (this.seen.containsKey(e)) {
                this.encounterVertexAgain(e, localEdges.get(e));
                continue;
            }
            this.encounterVertex(e, localEdges.get(e));
        }
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.startVertex, null);
        this.startVertex = null;
    }

    private boolean isConnectedComponentExhausted() {
        while (!this.stack.isEmpty()) {
            if (this.stack.getLast() != SENTINEL) {
                return false;
            }
            this.stack.removeLast();
            this.recordFinish();
        }
        return true;
    }

    protected void encounterVertex(V vertex, E edge) {
        this.seen.put((VisitColor)((Object)vertex), VisitColor.WHITE);
        this.stack.addLast(vertex);
    }

    protected void encounterVertexAgain(V vertex, E edge) {
        VisitColor color = this.seen.get(vertex);
        if (color != VisitColor.WHITE) {
            return;
        }
        boolean found = this.stack.removeLastOccurrence(vertex);
        assert (found);
        this.stack.addLast(vertex);
    }

    private V provideNextVertex() {
        Object o;
        while ((o = this.stack.removeLast()) == SENTINEL) {
            this.recordFinish();
        }
        Object v = TypeUtil.uncheckedCast((Object)o);
        this.stack.addLast(v);
        this.stack.addLast(SENTINEL);
        this.seen.put((VisitColor)((Object)v), VisitColor.GRAY);
        return (V)v;
    }

    private void recordFinish() {
        Object v = TypeUtil.uncheckedCast((Object)this.stack.removeLast());
        this.seen.put((VisitColor)((Object)v), VisitColor.BLACK);
        this.finishVertex(v);
    }

    private static class UndirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private final Graph<VV, EE> graph;

        public UndirectedSpecifics(Graph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<EE> edgesOf(VV vertex) {
            return this.graph.edgesOf(vertex);
        }
    }

    private static class DirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private final Graph<VV, EE> graph;

        public DirectedSpecifics(Graph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<? extends EE> edgesOf(VV vertex) {
            return this.graph.outgoingEdgesOf(vertex);
        }
    }

    static abstract class Specifics<VV, EE> {
        Specifics() {
        }

        public abstract Set<? extends EE> edgesOf(VV var1);
    }

    private static enum VisitColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

