/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.graph;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.Benchmark;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;

public class ConvexBranchesDecomposition
implements Algorithm,
Benchmark {
    private static final String BASE_ERROR_MSG = "[ConvexBranchesDecomposition] ";
    private String errorMessage;
    private Collection<List<Spot>> branches;
    private Collection<List<Spot>> links;
    private Map<Integer, Collection<List<Spot>>> branchesPerTrack;
    private Map<Integer, Collection<List<Spot>>> linksPerTrack;
    private long processingTime;
    private final TrackModel tm;
    private final TimeDirectedNeighborIndex neighborIndex;
    private final boolean forbidMiddleLinks;
    private final boolean forbidGaps;

    public ConvexBranchesDecomposition(Model model, boolean forbidMiddleLinks, boolean forbidGaps) {
        this.forbidMiddleLinks = forbidMiddleLinks;
        this.forbidGaps = forbidGaps;
        this.tm = model.getTrackModel();
        this.neighborIndex = this.tm.getDirectedNeighborIndex();
    }

    public ConvexBranchesDecomposition(Model model) {
        this(model, true, true);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean checkInput() {
        long start = System.currentTimeMillis();
        for (DefaultWeightedEdge edge : this.tm.edgeSet()) {
            Spot target;
            Spot source = this.tm.getEdgeSource(edge);
            if (source.diffTo(target = this.tm.getEdgeTarget(edge), "FRAME") != 0.0) continue;
            this.errorMessage = "[ConvexBranchesDecomposition] Cannot deal with links between two spots in the same frame (" + source + " & " + target + ").\n";
            return false;
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public boolean process() {
        long startT = System.currentTimeMillis();
        Set<Integer> trackIDs = this.tm.trackIDs(true);
        this.branches = new ArrayList<List<Spot>>();
        this.branchesPerTrack = new HashMap<Integer, Collection<List<Spot>>>();
        this.links = new ArrayList<List<Spot>>();
        this.linksPerTrack = new HashMap<Integer, Collection<List<Spot>>>();
        for (Integer trackID : trackIDs) {
            TrackBranchDecomposition branchDecomposition = ConvexBranchesDecomposition.processTrack(trackID, this.tm, this.neighborIndex, this.forbidMiddleLinks, this.forbidGaps);
            this.branchesPerTrack.put(trackID, branchDecomposition.branches);
            this.linksPerTrack.put(trackID, branchDecomposition.links);
            this.branches.addAll(branchDecomposition.branches);
            this.links.addAll(branchDecomposition.links);
        }
        long endT = System.currentTimeMillis();
        this.processingTime = endT - startT;
        return true;
    }

    public static final TrackBranchDecomposition processTrack(Integer trackID, TrackModel tm, TimeDirectedNeighborIndex neighborIndex, boolean forbidMiddleLinks, boolean forbidGaps) {
        Set<Spot> allSpots = tm.trackSpots(trackID);
        Set<DefaultWeightedEdge> allEdges = tm.trackEdges(trackID);
        SimpleGraph graph = new SimpleGraph(DefaultWeightedEdge.class);
        for (Spot spot : allSpots) {
            graph.addVertex((Object)spot);
        }
        for (DefaultWeightedEdge defaultWeightedEdge : allEdges) {
            graph.addEdge((Object)tm.getEdgeSource(defaultWeightedEdge), (Object)tm.getEdgeTarget(defaultWeightedEdge));
        }
        HashSet<List<Spot>> links = new HashSet<List<Spot>>();
        for (Spot spot : allSpots) {
            Iterator successors = neighborIndex.successorsOf(spot);
            Set<Spot> predecessors = neighborIndex.predecessorsOf(spot);
            if (predecessors.size() <= 1 && successors.size() <= 1) continue;
            if (predecessors.size() == 0) {
                boolean found = false;
                Iterator iterator = successors.iterator();
                while (iterator.hasNext()) {
                    Spot spot2 = (Spot)iterator.next();
                    if (!forbidMiddleLinks && !found && spot2.diffTo(spot, "FRAME") < 2.0) {
                        found = true;
                        continue;
                    }
                    graph.removeEdge((Object)spot, (Object)spot2);
                    links.add(ConvexBranchesDecomposition.makeLink(spot, spot2));
                }
                continue;
            }
            if (successors.size() == 0) {
                boolean found = false;
                for (Spot spot3 : predecessors) {
                    if (!forbidMiddleLinks && !found && spot.diffTo(spot3, "FRAME") < 2.0) {
                        found = true;
                        continue;
                    }
                    graph.removeEdge((Object)spot3, (Object)spot);
                    links.add(ConvexBranchesDecomposition.makeLink(spot3, spot));
                }
                continue;
            }
            if (predecessors.size() == 1) {
                Spot previous = predecessors.iterator().next();
                if (previous.diffTo(spot, "FRAME") < 2.0) {
                    Iterator iterator = successors.iterator();
                    while (iterator.hasNext()) {
                        Spot spot4 = (Spot)iterator.next();
                        graph.removeEdge((Object)spot, (Object)spot4);
                        links.add(ConvexBranchesDecomposition.makeLink(spot, spot4));
                    }
                    continue;
                }
                graph.removeEdge((Object)previous, (Object)spot);
                links.add(ConvexBranchesDecomposition.makeLink(previous, spot));
                boolean found = false;
                Iterator iterator = successors.iterator();
                while (iterator.hasNext()) {
                    Spot successor2 = (Spot)iterator.next();
                    if (!forbidMiddleLinks && !found && successor2.diffTo(spot, "FRAME") < 2.0) {
                        found = true;
                        continue;
                    }
                    graph.removeEdge((Object)spot, (Object)successor2);
                    links.add(ConvexBranchesDecomposition.makeLink(spot, successor2));
                }
                continue;
            }
            if (successors.size() == 1) {
                Spot next = (Spot)successors.iterator().next();
                if (spot.diffTo(next, "FRAME") < 2.0) {
                    for (Spot spot5 : predecessors) {
                        graph.removeEdge((Object)spot5, (Object)spot);
                        links.add(ConvexBranchesDecomposition.makeLink(spot5, spot));
                    }
                    continue;
                }
                graph.removeEdge((Object)spot, (Object)next);
                links.add(ConvexBranchesDecomposition.makeLink(spot, next));
                boolean found2 = false;
                for (Spot predecessor3 : predecessors) {
                    if (!forbidMiddleLinks && !found2 && spot.diffTo(predecessor3, "FRAME") < 2.0) {
                        found2 = true;
                        continue;
                    }
                    graph.removeEdge((Object)predecessor3, (Object)spot);
                    links.add(ConvexBranchesDecomposition.makeLink(predecessor3, spot));
                }
                continue;
            }
            boolean found = false;
            for (Spot spot6 : predecessors) {
                if (!forbidMiddleLinks && !found && spot.diffTo(spot6, "FRAME") < 2.0) {
                    found = true;
                    continue;
                }
                graph.removeEdge((Object)spot6, (Object)spot);
                links.add(ConvexBranchesDecomposition.makeLink(spot6, spot));
            }
            if (!forbidMiddleLinks) {
                found = false;
            }
            Iterator<Spot> found2 = successors.iterator();
            while (found2.hasNext()) {
                Spot spot7 = found2.next();
                if (!forbidMiddleLinks && !found && spot7.diffTo(spot, "FRAME") < 2.0) {
                    found = true;
                    continue;
                }
                graph.removeEdge((Object)spot, (Object)spot7);
                links.add(ConvexBranchesDecomposition.makeLink(spot, spot7));
            }
        }
        if (forbidGaps) {
            Set set = graph.edgeSet();
            HashSet<DefaultWeightedEdge> toRemove = new HashSet<DefaultWeightedEdge>();
            for (DefaultWeightedEdge edge : set) {
                Spot target;
                Spot source = (Spot)graph.getEdgeSource((Object)edge);
                if (!(Math.abs(source.diffTo(target = (Spot)graph.getEdgeTarget((Object)edge), "FRAME")) > 1.0)) continue;
                toRemove.add(edge);
                links.add(ConvexBranchesDecomposition.makeLink(source, target));
            }
            for (DefaultWeightedEdge edge : toRemove) {
                graph.removeEdge((Object)edge);
            }
        }
        ConnectivityInspector connectivityInspector = new ConnectivityInspector((Graph)graph);
        List connectedSets = connectivityInspector.connectedSets();
        HashSet<List<Spot>> branches = new HashSet<List<Spot>>(connectedSets.size());
        Comparator<Spot> comparator = Spot.frameComparator;
        for (Set set : connectedSets) {
            ArrayList arrayList = new ArrayList(set.size());
            arrayList.addAll(set);
            Collections.sort(arrayList, comparator);
            branches.add(arrayList);
        }
        TrackBranchDecomposition output = new TrackBranchDecomposition();
        output.branches = branches;
        output.links = links;
        return output;
    }

    public static final SimpleDirectedGraph<List<Spot>, DefaultEdge> buildBranchGraph(TrackBranchDecomposition branchDecomposition) {
        SimpleDirectedGraph branchGraph = new SimpleDirectedGraph(DefaultEdge.class);
        Collection<List<Spot>> branches = branchDecomposition.branches;
        Collection<List<Spot>> links = branchDecomposition.links;
        HashMap<Spot, List<Spot>> firstSpots = new HashMap<Spot, List<Spot>>(branches.size());
        HashMap<Spot, List<Spot>> lastSpots = new HashMap<Spot, List<Spot>>(branches.size());
        for (List<Spot> branch : branches) {
            firstSpots.put(branch.get(0), branch);
            lastSpots.put(branch.get(branch.size() - 1), branch);
            branchGraph.addVertex(branch);
        }
        for (List<Spot> link : links) {
            List<Spot> sourceBranch;
            Spot source = link.get(0);
            Spot target = link.get(1);
            List<Spot> targetBranch = (List<Spot>)firstSpots.get(target);
            if (targetBranch == null) {
                for (List<Spot> branch : branches) {
                    if (!branch.contains(target)) continue;
                    targetBranch = branch;
                    break;
                }
            }
            if ((sourceBranch = (List<Spot>)lastSpots.get(source)) == null) {
                for (List<Spot> branch : branches) {
                    if (!branch.contains(source)) continue;
                    sourceBranch = branch;
                    break;
                }
            }
            branchGraph.addEdge((Object)sourceBranch, (Object)targetBranch);
        }
        return branchGraph;
    }

    private static final List<Spot> makeLink(Spot spotA, Spot spotB) {
        ArrayList<Spot> link = new ArrayList<Spot>(2);
        link.add(spotA);
        link.add(spotB);
        return link;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Collection<List<Spot>> getBranches() {
        return this.branches;
    }

    public Map<Integer, Collection<List<Spot>>> getBranchesPerTrack() {
        return this.branchesPerTrack;
    }

    public Collection<List<Spot>> getLinks() {
        return this.links;
    }

    public Map<Integer, Collection<List<Spot>>> getLinksPerTrack() {
        return this.linksPerTrack;
    }

    public static final class TrackBranchDecomposition {
        public Collection<List<Spot>> branches;
        public Collection<List<Spot>> links;

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(super.toString() + ";\n");
            str.append("  Branches:\n");
            int index = 0;
            for (List<Spot> branch : this.branches) {
                str.append(String.format("    % 4d:\t" + branch + '\n', index++));
            }
            str.append("  Links:\n");
            index = 0;
            for (List<Spot> link : this.links) {
                str.append(String.format("    % 4d:\t" + link.get(0) + "\t\u2192\t" + link.get(1) + '\n', index++));
            }
            return str.toString();
        }
    }
}

