/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.edges;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.plugin.Plugin;

@Plugin(type=EdgeAnalyzer.class, enabled=false)
public abstract class AbstractEdgeAnalyzer
implements EdgeAnalyzer {
    private int numThreads;
    private long processingTime;
    private final String key;
    private final String name;
    private final List<String> features;
    private final Map<String, String> featureNames;
    private final Map<String, String> featureShortNames;
    private final Map<String, Dimension> featureDimensions;
    private final Map<String, Boolean> isInts;

    public AbstractEdgeAnalyzer(String key, String name, List<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, Dimension> featureDimensions, Map<String, Boolean> isInts) {
        this.key = key;
        this.name = name;
        this.features = features;
        this.featureNames = featureNames;
        this.featureShortNames = featureShortNames;
        this.featureDimensions = featureDimensions;
        this.isInts = isInts;
        this.setNumThreads();
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public final boolean isManualFeature() {
        return false;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getInfoText() {
        return null;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads() {
        this.setNumThreads(Runtime.getRuntime().availableProcessors() / 2);
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public final boolean isLocal() {
        return true;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Dimension> getFeatureDimensions() {
        return this.featureDimensions;
    }

    @Override
    public Map<String, String> getFeatureNames() {
        return this.featureNames;
    }

    @Override
    public List<String> getFeatures() {
        return this.features;
    }

    @Override
    public Map<String, String> getFeatureShortNames() {
        return this.featureShortNames;
    }

    @Override
    public Map<String, Boolean> getIsIntFeature() {
        return this.isInts;
    }

    @Override
    public void process(Collection<DefaultWeightedEdge> edges, final Model model) {
        if (edges.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        ArrayList<Object> tasks = new ArrayList<Object>(edges.size());
        for (final DefaultWeightedEdge edge : edges) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AbstractEdgeAnalyzer.this.analyze(edge, model);
                    return null;
                }
            };
            tasks.add(task);
        }
        ExecutorService executorService = Threads.newFixedThreadPool(this.numThreads);
        try {
            List futures = executorService.invokeAll(tasks);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
    }

    protected abstract void analyze(DefaultWeightedEdge var1, Model var2);
}

