/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class TrackCollectionDataset
extends ModelDataset {
    private static final long serialVersionUID = 1L;
    private final List<Integer> trackIDs;

    public TrackCollectionDataset(Model model, SelectionModel selectionModel, DisplaySettings ds, String xFeature, List<String> yFeatures, List<Integer> trackIDs) {
        super(model, selectionModel, ds, xFeature, yFeatures);
        this.trackIDs = trackIDs;
    }

    public int getItemCount(int series) {
        return this.trackIDs.size();
    }

    @Override
    public String getItemLabel(int item) {
        return this.model.getTrackModel().name(this.trackIDs.get(item));
    }

    @Override
    public void setItemLabel(int item, String label) {
        this.model.getTrackModel().setName(this.trackIDs.get(item), label);
    }

    public String getSeriesKey(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.model.getFeatureModel().getTrackFeatureShortNames().get(this.yFeatures.get(series));
    }

    public Number getX(int series, int item) {
        return this.model.getFeatureModel().getTrackFeature(this.trackIDs.get(item), this.xFeature);
    }

    public Number getY(int series, int item) {
        return this.model.getFeatureModel().getTrackFeature(this.trackIDs.get(item), (String)this.yFeatures.get(series));
    }

    @Override
    public XYItemRenderer getRenderer() {
        return new MyXYItemRenderer();
    }

    private final class MyXYItemRenderer
    extends XYLineAndShapeRenderer {
        private static final long serialVersionUID = 1L;

        public MyXYItemRenderer() {
            super(false, true);
        }

        public Paint getItemPaint(int series, int item) {
            Integer trackID = (Integer)TrackCollectionDataset.this.trackIDs.get(item);
            if (TrackCollectionDataset.this.selectionModel != null && TrackCollectionDataset.this.selectionModel.getSpotSelection().containsAll(TrackCollectionDataset.this.model.getTrackModel().trackSpots(trackID))) {
                return TrackCollectionDataset.this.ds.getHighlightColor();
            }
            FeatureColorGenerator<Integer> trackColorGenerator = FeatureUtils.createWholeTrackColorGenerator(TrackCollectionDataset.this.model, TrackCollectionDataset.this.ds);
            return trackColorGenerator.color((Integer)TrackCollectionDataset.this.trackIDs.get(item));
        }

        public Stroke getItemStroke(int series, int item) {
            Integer trackID = (Integer)TrackCollectionDataset.this.trackIDs.get(item);
            if (TrackCollectionDataset.this.selectionModel != null && TrackCollectionDataset.this.selectionModel.getSpotSelection().containsAll(TrackCollectionDataset.this.model.getTrackModel().trackSpots(trackID))) {
                return TrackCollectionDataset.this.selectionStroke;
            }
            return TrackCollectionDataset.this.stroke;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            LegendItem legendItem = super.getLegendItem(datasetIndex, series);
            legendItem.setFillPaint((Paint)Color.BLACK);
            legendItem.setLinePaint((Paint)Color.BLACK);
            legendItem.setOutlinePaint((Paint)Color.BLACK);
            return legendItem;
        }
    }
}

