/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.ThresholdDetector;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.ThresholdDetectorConfigurationPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class ThresholdDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T> {
    public static final String DETECTOR_KEY = "THRESHOLD_DETECTOR";
    public static final String NAME = "Thresholding detector";
    public static final String INFO_TEXT = "<html>This detector creates spots by thresholding a grayscale image.<p>Pixels in the designated channel that have a value larger than the threshold are considered as part of the foreground, and used to build connected regions. In 2D, spots are created with the (possibly simplified) contour of the region. In 3D, a spherical spot is created for each region in its center, with a volume equal to the region volume.<p>The spot quality stores the object area or volume in pixels.</html>";
    public static final String KEY_SIMPLIFY_CONTOURS = "SIMPLIFY_CONTOURS";
    public static final String KEY_INTENSITY_THRESHOLD = "INTENSITY_THRESHOLD";
    protected ImgPlus<T> img;
    protected Map<String, Object> settings;
    protected String errorMessage;

    @Override
    public boolean setTarget(ImgPlus<T> img, Map<String, Object> settings) {
        this.img = img;
        this.settings = settings;
        return this.checkSettings(settings);
    }

    @Override
    public SpotDetector<T> getDetector(Interval interval, int frame) {
        double intensityThreshold = (Double)this.settings.get(KEY_INTENSITY_THRESHOLD);
        boolean simplifyContours = (Boolean)this.settings.get(KEY_SIMPLIFY_CONTOURS);
        double[] calibration = TMUtils.getSpatialCalibration(this.img);
        int channel = (Integer)this.settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(this.img, channel, frame);
        ThresholdDetector<T> detector = new ThresholdDetector<T>(imFrame, interval, calibration, intensityThreshold, simplifyContours);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkSettings(Map<String, Object> lSettings) {
        boolean ok = true;
        StringBuilder errorHolder = new StringBuilder();
        ok &= TMUtils.checkParameter(lSettings, "TARGET_CHANNEL", Integer.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, KEY_INTENSITY_THRESHOLD, Double.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, KEY_SIMPLIFY_CONTOURS, Boolean.class, errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("TARGET_CHANNEL");
        mandatoryKeys.add(KEY_INTENSITY_THRESHOLD);
        mandatoryKeys.add(KEY_SIMPLIFY_CONTOURS);
        if (!(ok &= TMUtils.checkMapKeys(lSettings, mandatoryKeys, null, errorHolder))) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean marshall(Map<String, Object> lSettings, Element element) {
        boolean ok;
        StringBuilder errorHolder = new StringBuilder();
        boolean bl = ok = IOUtils.writeTargetChannel(lSettings, element, errorHolder) && IOUtils.writeAttribute(lSettings, element, KEY_INTENSITY_THRESHOLD, Double.class, errorHolder) && IOUtils.writeAttribute(lSettings, element, KEY_SIMPLIFY_CONTOURS, Boolean.class, errorHolder);
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> lSettings) {
        lSettings.clear();
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = true;
        ok &= IOUtils.readIntegerAttribute(element, lSettings, "TARGET_CHANNEL", errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, lSettings, KEY_INTENSITY_THRESHOLD, errorHolder);
        if (!(ok &= IOUtils.readBooleanAttribute(element, lSettings, KEY_SIMPLIFY_CONTOURS, errorHolder))) {
            this.errorMessage = errorHolder.toString();
            return false;
        }
        return this.checkSettings(lSettings);
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new ThresholdDetectorConfigurationPanel(lSettings, model);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("TARGET_CHANNEL", 1);
        lSettings.put(KEY_INTENSITY_THRESHOLD, 0.0);
        lSettings.put(KEY_SIMPLIFY_CONTOURS, true);
        return lSettings;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public ThresholdDetectorFactory<T> copy() {
        return new ThresholdDetectorFactory<T>();
    }
}

