/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.LogDetector;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.dog.DifferenceOfGaussian;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.parallel.Parallelization;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class DogDetector<T extends RealType<T> & NativeType<T>>
extends LogDetector<T> {
    public static final String BASE_ERROR_MESSAGE = "DogDetector: ";

    public DogDetector(RandomAccessible<T> img, Interval interval, double[] calibration, double radius, double threshold, boolean doSubPixelLocalization, boolean doMedianFilter) {
        super(img, interval, calibration, radius, threshold, doSubPixelLocalization, doMedianFilter);
        this.baseErrorMessage = BASE_ERROR_MESSAGE;
    }

    @Override
    public boolean process() {
        long start = System.currentTimeMillis();
        Img view = Views.interval((RandomAccessible)this.img, (Interval)this.interval);
        if (this.doMedianFilter && null == (view = DetectionUtils.applyMedianFilter(view))) {
            this.errorMessage = "DogDetector: Failed to apply median filter.";
            return false;
        }
        ExtendedRandomAccessibleInterval extended = Views.extendMirrorSingle((RandomAccessibleInterval)view);
        long[] min = new long[this.interval.numDimensions()];
        this.interval.min(min);
        FloatType type = new FloatType();
        IntervalView dog = Views.translate((RandomAccessibleInterval)Util.getArrayOrCellImgFactory((Dimensions)this.interval, (NativeType)type).create((Dimensions)this.interval), (long[])min);
        IntervalView dog2 = Views.translate((RandomAccessibleInterval)Util.getArrayOrCellImgFactory((Dimensions)this.interval, (NativeType)type).create((Dimensions)this.interval), (long[])min);
        double sigma1 = this.radius / Math.sqrt(this.interval.numDimensions()) * 0.9;
        double sigma2 = this.radius / Math.sqrt(this.interval.numDimensions()) * 1.1;
        double[] cal = new double[this.img.numDimensions()];
        for (int d = 0; d < cal.length; ++d) {
            cal[d] = this.calibration[d];
        }
        double[][] sigmas = DifferenceOfGaussian.computeSigmas((double)0.5, (double)2.0, (double[])cal, (double)sigma1, (double)sigma2);
        try {
            Parallelization.runWithNumThreads((int)this.numThreads, () -> DogDetector.lambda$process$0(sigmas, (RandomAccessible)extended, (RandomAccessibleInterval)dog2, (RandomAccessibleInterval)dog));
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
        IterableInterval dogIterable = Views.iterable((RandomAccessibleInterval)dog);
        IterableInterval tmpIterable = Views.iterable((RandomAccessibleInterval)dog2);
        Cursor dogCursor = dogIterable.cursor();
        Cursor tmpCursor = tmpIterable.cursor();
        while (dogCursor.hasNext()) {
            ((FloatType)dogCursor.next()).sub((FloatType)tmpCursor.next());
        }
        this.spots = DetectionUtils.findLocalMaxima(dog, this.threshold, this.calibration, this.radius, this.doSubPixelLocalization, this.numThreads);
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    private static /* synthetic */ void lambda$process$0(double[][] sigmas, RandomAccessible extended, RandomAccessibleInterval dog2, RandomAccessibleInterval dog) {
        Gauss3.gauss((double[])sigmas[1], (RandomAccessible)extended, (RandomAccessibleInterval)dog2);
        Gauss3.gauss((double[])sigmas[0], (RandomAccessible)extended, (RandomAccessibleInterval)dog);
    }
}

