/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.closegaps;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.closegaps.GapClosingMethod;
import java.util.List;
import org.jgrapht.graph.DefaultWeightedEdge;

public class CloseGapsByLinearInterpolation
implements GapClosingMethod {
    public static final String INFO_TEXT = "<html>This action allows to close gaps in tracks by intercalating new spots in gaps which position is interpolated from the positions of the true spots at the gap beginning and end. The image data is not used to adjust the position of spots.</html>";
    public static final String NAME = "Close gaps by interpolating positions";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TrackMate trackmate, Logger logger) {
        Model model = trackmate.getModel();
        TrackModel trackModel = model.getTrackModel();
        model.beginUpdate();
        try {
            List<DefaultWeightedEdge> gaps = GapClosingMethod.getAllGaps(model);
            int progress = 0;
            for (DefaultWeightedEdge gap : gaps) {
                Spot source;
                List<Spot> spots = GapClosingMethod.interpolate(model, gap);
                Spot current = source = trackModel.getEdgeSource(gap);
                for (Spot spot : spots) {
                    model.addSpotTo(spot, spot.getFeature("FRAME").intValue());
                    model.addEdge(current, spot, 1.0);
                    current = spot;
                }
                Spot target = trackModel.getEdgeTarget(gap);
                model.addEdge(current, target, 1.0);
                model.removeEdge(source, target);
                logger.log("Added " + spots.size() + " new spots between spots " + source + " and " + target + ".\n");
                logger.setProgress((double)progress++ / (double)gaps.size());
            }
        }
        finally {
            model.endUpdate();
        }
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    public String toString() {
        return NAME;
    }
}

