/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.LabelImgExporter;
import fiji.plugin.trackmate.graph.ConvexBranchesDecomposition;
import fiji.plugin.trackmate.graph.GraphUtils;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import fiji.plugin.trackmate.io.TmXmlWriter;
import fiji.plugin.trackmate.util.TMUtils;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.Duplicator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Util;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class CTCExporter {
    private static final Function<Integer, String> nameGen = i -> String.format("%02d", i);

    public static String exportAll(String exportRootFolder, TrackMate trackmate, ExportType exportType, Logger logger) throws IOException {
        if (!new File(exportRootFolder).exists()) {
            new File(exportRootFolder).mkdirs();
        }
        logger.log("Exporting as CTC type: " + exportType.toString() + '\n');
        int id = CTCExporter.getAvailableDatasetID(exportRootFolder);
        CTCExporter.exportOriginalImageData(exportRootFolder, id, trackmate, logger);
        String resultsFolder = CTCExporter.exportTrackingData(exportRootFolder, id, exportType, trackmate, logger);
        if (exportType != ExportType.RESULTS) {
            CTCExporter.exportSegmentationData(exportRootFolder, id, exportType, trackmate, logger);
        } else {
            CTCExporter.exportSettingsFile(exportRootFolder, id, trackmate, logger);
        }
        logger.log("Export done.\n");
        return resultsFolder;
    }

    public static void exportSettingsFile(String exportRootFolder, int saveId, TrackMate trackmate, Logger logger) throws IOException {
        Path path = ExportType.RESULTS.getTrackTextFilePath(exportRootFolder, saveId);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        File settingsPath = new File(path.getParent().toFile(), "TrackMateSettings.xml");
        logger.log("Exporting TrackMate settings file to " + settingsPath + '\n');
        TmXmlWriter writer = new TmXmlWriter(settingsPath, logger);
        writer.appendSettings(trackmate.getSettings());
        writer.writeToFile();
        logger.log("Done.\n");
    }

    public static int getAvailableDatasetID(String exportRootFolder) {
        int i = 1;
        Path savePath1 = Paths.get(exportRootFolder, nameGen.apply(i));
        Path savePath2 = Paths.get(exportRootFolder, nameGen.apply(i) + ExportType.GOLD_TRUTH.suffix);
        Path savePath3 = Paths.get(exportRootFolder, nameGen.apply(i) + ExportType.SILVER_TRUTH.suffix);
        Path savePath4 = Paths.get(exportRootFolder, nameGen.apply(i) + ExportType.RESULTS.suffix);
        while (Files.exists(savePath1, new LinkOption[0]) || Files.exists(savePath2, new LinkOption[0]) || Files.exists(savePath3, new LinkOption[0]) || Files.exists(savePath4, new LinkOption[0])) {
            savePath1 = Paths.get(exportRootFolder, nameGen.apply(++i));
            savePath2 = Paths.get(exportRootFolder, nameGen.apply(i) + ExportType.GOLD_TRUTH.suffix);
            savePath3 = Paths.get(exportRootFolder, nameGen.apply(i) + ExportType.SILVER_TRUTH.suffix);
            savePath4 = Paths.get(exportRootFolder, nameGen.apply(i) + ExportType.RESULTS.suffix);
        }
        return i;
    }

    public static void exportOriginalImageData(String exportRootFolder, int saveId, TrackMate trackmate, Logger logger) throws IOException {
        CTCExporter.exportOriginalImageData(exportRootFolder, saveId, trackmate.getSettings().imp, logger);
    }

    public static void exportOriginalImageData(String exportRootFolder, int saveId, ImagePlus imp, Logger logger) throws IOException {
        if (imp == null) {
            return;
        }
        Path savePath = Paths.get(exportRootFolder, String.format("%02d", saveId));
        if (Files.exists(savePath, new LinkOption[0])) {
            String msg = "Cannot save to " + savePath + ". Folder already exists.";
            logger.error(msg);
            return;
        }
        Files.createDirectory(savePath, new FileAttribute[0]);
        logger.log("Exporting original image to " + savePath.toString());
        int nFrames = imp.getNFrames();
        String format = nFrames > 999 ? "t%04d.tif" : "t%03d.tif";
        Duplicator duplicator = new Duplicator();
        boolean firstC = true;
        int lastC = imp.getNChannels();
        boolean firstZ = true;
        int lastZ = imp.getNSlices();
        for (int frame = 0; frame < nFrames; ++frame) {
            ImagePlus tp = duplicator.run(imp, 1, lastC, 1, lastZ, frame + 1, frame + 1);
            IJ.saveAsTiff((ImagePlus)tp, (String)Paths.get(savePath.toString(), String.format(format, frame)).toString());
        }
        logger.log(". Done.\n");
    }

    public static void exportSegmentationData(String exportRootFolder, int saveId, ExportType exportType, TrackMate trackmate, Logger logger) throws IOException {
        long[] dims;
        ImagePlus imp = trackmate.getSettings().imp;
        if (imp != null) {
            int[] dimensions = imp.getDimensions();
            dims = new long[]{dimensions[0], dimensions[1], dimensions[3], dimensions[4]};
        } else {
            Settings s = trackmate.getSettings();
            dims = new long[]{s.width, s.height, s.nslices, s.nframes};
        }
        double[] calibration = new double[]{imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth, imp.getCalibration().frameInterval};
        ImgPlus<UnsignedShortType> labelImg = CTCExporter.createLabelImg(dims, calibration);
        Model model = trackmate.getModel();
        AtomicInteger idGen = new AtomicInteger(1);
        HashSet<Integer> framesToWrite = new HashSet<Integer>();
        int frame = 0;
        while ((long)frame < dims[3]) {
            ImgPlus<UnsignedShortType> imgCT = TMUtils.hyperSlice(labelImg, 0L, frame);
            LabelImgExporter.SpotRoiWriter<UnsignedShortType> spotWriter = new LabelImgExporter.SpotRoiWriter<UnsignedShortType>(imgCT);
            for (Spot spot : model.getSpots().iterable(frame, true)) {
                if (spot.getRoi() == null) continue;
                int id = idGen.getAndIncrement();
                spotWriter.write(spot, id);
                framesToWrite.add(frame);
            }
            ++frame;
        }
        Path path = Paths.get(exportRootFolder, nameGen.apply(saveId) + exportType.suffix(), "SEG");
        Files.createDirectories(path, new FileAttribute[0]);
        logger.log("Exporting segmentation mask files to " + path.toString());
        int nFrames = imp.getNFrames();
        Function<Long, String> tifNameGen = nFrames > 999 ? i -> String.format("man_seg%04d.tif", i) : i -> String.format("man_seg%03d.tif", i);
        Iterator<Spot> iterator = framesToWrite.iterator();
        while (iterator.hasNext()) {
            int frame2 = (Integer)((Object)iterator.next());
            ImgPlus<UnsignedShortType> imgCT = TMUtils.hyperSlice(labelImg, 0L, frame2);
            String name = tifNameGen.apply(Long.valueOf(frame2));
            ImagePlus tp = ImageJFunctions.wrapUnsignedShort(imgCT, (String)name);
            Path pathTif = Paths.get(exportRootFolder, nameGen.apply(saveId) + exportType.suffix(), "SEG", name);
            IJ.saveAsTiff((ImagePlus)tp, (String)pathTif.toString());
        }
        logger.log(". Done.\n");
    }

    public static String exportTrackingData(String exportRootFolder, int saveId, ExportType exportType, TrackMate trackmate, Logger logger) throws FileNotFoundException, IOException {
        long[] dims;
        TimeDirectedNeighborIndex neighborIndex;
        Model model2 = CTCExporter.sanitizeAndCopy(trackmate.getModel());
        TrackModel trackModel = model2.getTrackModel();
        if (!GraphUtils.isTree(trackModel, neighborIndex = model2.getTrackModel().getDirectedNeighborIndex())) {
            String msg = "Cannot perform CTC export of tracks that have fusion events.";
            logger.error("Cannot perform CTC export of tracks that have fusion events.");
            return null;
        }
        ImagePlus imp = trackmate.getSettings().imp;
        if (imp != null) {
            int[] dimensions = imp.getDimensions();
            dims = new long[]{dimensions[0], dimensions[1], dimensions[3], dimensions[4]};
        } else {
            Settings s = trackmate.getSettings();
            dims = new long[]{s.width, s.height, s.nslices, s.nframes};
        }
        double[] calibration = new double[]{imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth, imp.getCalibration().frameInterval};
        ImgPlus<UnsignedShortType> labelImg = CTCExporter.createLabelImg(dims, calibration);
        boolean forbidMiddleLinks = true;
        boolean forbidGaps = true;
        AtomicInteger branchIDGen = new AtomicInteger(1);
        HashMap<List, Integer> branchID = new HashMap<List, Integer>();
        Path path = exportType.getTrackTextFilePath(exportRootFolder, saveId);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        logger.log("Exporting tracking text file to " + path.toString());
        try (FileOutputStream fos = new FileOutputStream(path.toFile());
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));){
            for (Integer trackID : trackModel.trackIDs(true)) {
                ConvexBranchesDecomposition.TrackBranchDecomposition decomposition = ConvexBranchesDecomposition.processTrack(trackID, trackModel, neighborIndex, true, true);
                SimpleDirectedGraph<List<Spot>, DefaultEdge> branchGraph = ConvexBranchesDecomposition.buildBranchGraph(decomposition);
                List start = null;
                for (List vertex : branchGraph.vertexSet()) {
                    if (!branchGraph.incomingEdgesOf((Object)vertex).isEmpty()) continue;
                    start = vertex;
                    break;
                }
                BreadthFirstIterator bfi = new BreadthFirstIterator(branchGraph, start);
                while (bfi.hasNext()) {
                    DefaultEdge edge;
                    List parent;
                    Integer obj;
                    List current = (List)bfi.next();
                    int currentID = branchIDGen.getAndIncrement();
                    branchID.put(current, currentID);
                    for (Spot spot : current) {
                        long frame = spot.getFeature("FRAME").longValue();
                        ImgPlus<UnsignedShortType> imgCT = TMUtils.hyperSlice(labelImg, 0L, frame);
                        LabelImgExporter.SpotRoiWriter<UnsignedShortType> spotRoiWriter = new LabelImgExporter.SpotRoiWriter<UnsignedShortType>(imgCT);
                        spotRoiWriter.write(spot, currentID);
                    }
                    int parentID = branchGraph.incomingEdgesOf((Object)current).isEmpty() ? 0 : ((obj = (Integer)branchID.get(parent = (List)Graphs.getOppositeVertex(branchGraph, (Object)(edge = (DefaultEdge)branchGraph.incomingEdgesOf((Object)current).iterator().next()), (Object)current))) == null ? 0 : obj);
                    int startFrame = ((Spot)current.get(0)).getFeature("FRAME").intValue();
                    int endFrame = ((Spot)current.get(current.size() - 1)).getFeature("FRAME").intValue();
                    int L = currentID;
                    int B = startFrame;
                    int E = endFrame;
                    int P = parentID;
                    bw.write(String.format("%d %d %d %d", L, B, E, P));
                    bw.newLine();
                }
            }
        }
        logger.log(". Done.\n");
        int nFrames = imp.getNFrames();
        Path pathTif0 = exportType.getTrackTifFilePath(exportRootFolder, saveId, 0L, nFrames);
        logger.log("Exporting tracking mask files to " + pathTif0.getParent().toString());
        for (long frame = 0L; frame < dims[3]; ++frame) {
            ImgPlus<UnsignedShortType> imgCT = TMUtils.hyperSlice(labelImg, 0L, frame);
            Path pathTif = exportType.getTrackTifFilePath(exportRootFolder, saveId, frame, nFrames);
            String name = pathTif.getFileName().toString();
            ImagePlus tp = ImageJFunctions.wrapUnsignedShort(imgCT, (String)name);
            IJ.saveAsTiff((ImagePlus)tp, (String)pathTif.toString());
        }
        logger.log(". Done.\n");
        return pathTif0.getParent().toString();
    }

    public static final String getExportTrackingDataPath(String exportRootFolder, int saveId, ExportType exportType, TrackMate trackmate) {
        Path pathTif0 = exportType.getTrackTifFilePath(exportRootFolder, saveId, 0L, trackmate.getSettings().imp.getNFrames());
        return pathTif0.getParent().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Model sanitizeAndCopy(Model model) {
        double fudgeFactor = 1.2;
        Model copy = model.copy();
        SpotCollection allSpots = copy.getSpots();
        TrackModel trackModel = copy.getTrackModel();
        for (Integer frame : allSpots.keySet()) {
            ArrayList spots = new ArrayList();
            allSpots.iterable(frame, true).forEach(spots::add);
            int nSpots = spots.size();
            for (int i = 0; i < nSpots; ++i) {
                Spot s1 = (Spot)spots.get(i);
                double r1 = s1.getFeature("RADIUS");
                for (int j = i + 1; j < nSpots; ++j) {
                    Spot s2 = (Spot)spots.get(j);
                    double r2 = s2.getFeature("RADIUS");
                    double d = Math.sqrt(s1.squareDistanceTo(s2));
                    if (!(1.2 * r1 > d + r2) && !(1.2 * r2 > d + r1)) continue;
                    Integer id1 = trackModel.trackIDOf(s1);
                    Set<Spot> track1 = trackModel.trackSpots(id1);
                    if (track1 == null) {
                        try {
                            model.removeSpot(s1);
                            continue;
                        }
                        finally {
                            model.endUpdate();
                        }
                    }
                    int n1 = track1.size();
                    Integer id2 = trackModel.trackIDOf(s2);
                    Set<Spot> track2 = trackModel.trackSpots(id2);
                    if (track2 == null) {
                        try {
                            model.removeSpot(s2);
                            continue;
                        }
                        finally {
                            model.endUpdate();
                        }
                    }
                    int n2 = track2.size();
                    Spot toRemove = n2 > n1 ? s1 : s2;
                    ArrayList<Spot> sources = new ArrayList<Spot>();
                    ArrayList<Spot> targets = new ArrayList<Spot>();
                    Set<DefaultWeightedEdge> edges = trackModel.edgesOf(toRemove);
                    for (DefaultWeightedEdge edge : edges) {
                        Spot source = trackModel.getEdgeSource(edge);
                        if (source == toRemove) {
                            targets.add(trackModel.getEdgeTarget(edge));
                            continue;
                        }
                        sources.add(trackModel.getEdgeSource(edge));
                    }
                    model.beginUpdate();
                    try {
                        for (Spot source : sources) {
                            for (Spot target : targets) {
                                model.addEdge(source, target, -1.0);
                            }
                        }
                        model.removeSpot(toRemove);
                        continue;
                    }
                    finally {
                        model.endUpdate();
                    }
                }
            }
        }
        return copy;
    }

    private static final ImgPlus<UnsignedShortType> createLabelImg(long[] dimensions, double[] calibration) {
        FinalDimensions targetSize = FinalDimensions.wrap((long[])dimensions);
        Img lblImg = Util.getArrayOrCellImgFactory((Dimensions)targetSize, (NativeType)new UnsignedShortType()).create((Dimensions)targetSize);
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y, Axes.Z, Axes.TIME};
        ImgPlus imgPlus = new ImgPlus(lblImg, "LblImg", axes, calibration);
        return imgPlus;
    }

    public static enum ExportType {
        GOLD_TRUTH("Gold truth", "_GT"),
        SILVER_TRUTH("Silver truth", "_ST"),
        RESULTS("Results", "_RES");

        private final String label;
        private final String suffix;

        private ExportType(String label, String suffix) {
            this.label = label;
            this.suffix = suffix;
        }

        public String toString() {
            return this.label;
        }

        public String suffix() {
            return this.suffix;
        }

        public Path getTrackTextFilePath(String exportRootFolder, int saveId) {
            switch (this) {
                case GOLD_TRUTH: 
                case SILVER_TRUTH: {
                    return Paths.get(exportRootFolder, (String)nameGen.apply(saveId) + this.suffix, "TRA", "man_track.txt");
                }
                case RESULTS: {
                    return Paths.get(exportRootFolder, (String)nameGen.apply(saveId) + this.suffix, "res_track.txt");
                }
            }
            throw new IllegalArgumentException("Unknown export type: " + (Object)((Object)this));
        }

        public Path getTrackTifFilePath(String exportRootFolder, int saveId, long frame, int nFrames) {
            switch (this) {
                case GOLD_TRUTH: 
                case SILVER_TRUTH: {
                    Function<Long, String> tifNameGen = nFrames > 999 ? i -> String.format("man_track%04d.tif", i) : i -> String.format("man_track%03d.tif", i);
                    String name = tifNameGen.apply(frame);
                    return Paths.get(exportRootFolder, (String)nameGen.apply(saveId) + this.suffix, "TRA", name);
                }
                case RESULTS: {
                    Function<Long, String> tifNameGen = nFrames > 999 ? i -> String.format("mask%04d.tif", i) : i -> String.format("mask%03d.tif", i);
                    String name = tifNameGen.apply(frame);
                    return Paths.get(exportRootFolder, (String)nameGen.apply(saveId) + this.suffix, name);
                }
            }
            throw new IllegalArgumentException("Unknown export type: " + (Object)((Object)this));
        }
    }
}

