/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Spot;
import java.util.Arrays;
import net.imagej.ImgPlus;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Masks;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.roi.Regions;
import net.imglib2.roi.geom.GeomMasks;
import net.imglib2.roi.geom.real.WritablePolygon2D;
import net.imglib2.view.Views;

public class SpotRoi {
    public final double[] x;
    public final double[] y;

    public SpotRoi(double[] x, double[] y) {
        this.x = x;
        this.y = y;
    }

    public SpotRoi copy() {
        return new SpotRoi((double[])this.x.clone(), (double[])this.y.clone());
    }

    public double[] toPolygonX(double calibration, double xcorner, double spotXCenter, double magnification) {
        double[] xp = new double[this.x.length];
        for (int i = 0; i < xp.length; ++i) {
            double xc = (spotXCenter + this.x[i]) / calibration;
            xp[i] = (xc - xcorner) * magnification;
        }
        return xp;
    }

    public double[] toPolygonY(double calibration, double ycorner, double spotYCenter, double magnification) {
        double[] yp = new double[this.y.length];
        for (int i = 0; i < yp.length; ++i) {
            double yc = (spotYCenter + this.y[i]) / calibration;
            yp[i] = (yc - ycorner) * magnification;
        }
        return yp;
    }

    public <T> IterableInterval<T> sample(Spot spot, ImgPlus<T> img) {
        return this.sample(spot.getDoublePosition(0), spot.getDoublePosition(1), (RandomAccessibleInterval<T>)img, img.averageScale(0), img.averageScale(1));
    }

    public <T> IterableInterval<T> sample(double spotXCenter, double spotYCenter, RandomAccessibleInterval<T> img, double xScale, double yScale) {
        double[] xp = this.toPolygonX(xScale, 0.0, spotXCenter, 1.0);
        double[] yp = this.toPolygonY(yScale, 0.0, spotYCenter, 1.0);
        WritablePolygon2D polygon = GeomMasks.closedPolygon2D((double[])xp, (double[])yp);
        IterableRegion region = Masks.toIterableRegion((RealMaskRealInterval)polygon);
        return Regions.sample((IterableInterval)region, (RandomAccessible)Views.extendMirrorDouble((RandomAccessibleInterval)Views.dropSingletonDimensions(img)));
    }

    public double radius() {
        return Math.sqrt(this.area() / Math.PI);
    }

    public double area() {
        return Math.abs(SpotRoi.signedArea(this.x, this.y));
    }

    public void scale(double alpha) {
        for (int i = 0; i < this.x.length; ++i) {
            double x = this.x[i];
            double y = this.y[i];
            double r = Math.sqrt(x * x + y * y);
            double costheta = x / r;
            double sintheta = y / r;
            this.x[i] = costheta * r * alpha;
            this.y[i] = sintheta * r * alpha;
        }
    }

    public static Spot createSpot(double[] x, double[] y, double quality) {
        double[] centroid = SpotRoi.centroid(x, y);
        double xc = centroid[0];
        double yc = centroid[1];
        double[] xr = Arrays.stream(x).map(x0 -> x0 - xc).toArray();
        double[] yr = Arrays.stream(y).map(y0 -> y0 - yc).toArray();
        SpotRoi roi = new SpotRoi(xr, yr);
        double z = 0.0;
        double r = roi.radius();
        Spot spot = new Spot(xc, yc, 0.0, r, quality);
        spot.setRoi(roi);
        return spot;
    }

    private static final double[] centroid(double[] x, double[] y) {
        double area = SpotRoi.signedArea(x, y);
        double ax = 0.0;
        double ay = 0.0;
        int n = x.length;
        for (int i = 0; i < n - 1; ++i) {
            double w = x[i] * y[i + 1] - x[i + 1] * y[i];
            ax += (x[i] + x[i + 1]) * w;
            ay += (y[i] + y[i + 1]) * w;
        }
        double w0 = x[n - 1] * y[0] - x[0] * y[n - 1];
        return new double[]{(ax += (x[n - 1] + x[0]) * w0) / 6.0 / area, (ay += (y[n - 1] + y[0]) * w0) / 6.0 / area};
    }

    private static final double signedArea(double[] x, double[] y) {
        int n = x.length;
        double a = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            a += x[i] * y[i + 1] - x[i + 1] * y[i];
        }
        return (a + x[n - 1] * y[0] - x[0] * y[n - 1]) / 2.0;
    }
}

