/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.util;

public final class LibraryChecker {
    private LibraryChecker() {
    }

    public static boolean areRequirementsAvailable() {
        return LibraryChecker.isFormatsAPIAvailable() && LibraryChecker.isOMEROModelAvailable() && LibraryChecker.isOMEXMLAvailable() && LibraryChecker.isOMECommonAvailable() && LibraryChecker.isOMEROBlitzAvailable() && LibraryChecker.isOMEROGatewayAvailable();
    }

    public static boolean isOMEROGatewayAvailable() {
        return LibraryChecker.checkClass("omero.gateway.Gateway");
    }

    public static boolean isOMEROModelAvailable() {
        return LibraryChecker.checkClass("ome.model.IObject");
    }

    public static boolean isOMEROBlitzAvailable() {
        return LibraryChecker.checkClass("ome.formats.OMEROMetadataStoreClient");
    }

    public static boolean isOMEXMLAvailable() {
        return LibraryChecker.checkClass("ome.units.unit.Unit");
    }

    public static boolean isOMECommonAvailable() {
        return LibraryChecker.checkClass("loci.common.DataTools");
    }

    public static boolean isFormatsAPIAvailable() {
        return LibraryChecker.checkClass("loci.formats.in.DefaultMetadataOptions");
    }

    public static boolean checkClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

