/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import ij.gui.Roi;
import ij.gui.TextRoi;
import java.awt.Shape;
import java.awt.geom.Path2D;
import omero.gateway.model.TextData;

public class TextWrapper
extends GenericShapeWrapper<TextData> {
    public TextWrapper(TextData text) {
        super(text);
    }

    public TextWrapper() {
        this(new TextData());
    }

    public TextWrapper(TextRoi text) {
        this(text.getText(), text.getBounds().getX(), text.getBounds().getY());
        super.copyFromIJRoi((Roi)text);
    }

    public TextWrapper(String text, double x, double y) {
        this(new TextData(text, x, y));
    }

    @Override
    public String getText() {
        return ((TextData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((TextData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        Path2D.Double point = new Path2D.Double();
        ((Path2D)point).moveTo(this.getX(), this.getY());
        return point;
    }

    public double getX() {
        return ((TextData)this.data).getX();
    }

    public void setX(double x) {
        ((TextData)this.data).setX(x);
    }

    public double getY() {
        return ((TextData)this.data).getY();
    }

    public void setY(double y) {
        ((TextData)this.data).setY(y);
    }

    public void setCoordinates(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public double[] getCoordinates() {
        double[] coordinates = new double[]{this.getX(), this.getY()};
        return coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            String msg = "TextData cannot set null coordinates.";
            throw new IllegalArgumentException(msg);
        }
        if (coordinates.length != 2) {
            String msg = "2 coordinates required for TextData.";
            throw new IllegalArgumentException(msg);
        }
        ((TextData)this.data).setX(coordinates[0]);
        ((TextData)this.data).setY(coordinates[1]);
    }

    @Override
    public Roi toImageJ() {
        Shape awtShape = this.createTransformedAWTShape();
        double x = awtShape.getBounds2D().getX();
        double y = awtShape.getBounds2D().getY();
        TextRoi roi = new TextRoi(x, y, this.getText());
        this.copyToIJRoi((Roi)roi);
        return roi;
    }
}

