/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import fr.igred.omero.roi.PointWrapper;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import omero.gateway.model.RectangleData;

public class RectangleWrapper
extends GenericShapeWrapper<RectangleData> {
    public RectangleWrapper(RectangleData rectangle) {
        super(rectangle);
    }

    public RectangleWrapper() {
        this(new RectangleData());
    }

    public RectangleWrapper(Roi ijRoi) {
        this(ijRoi.getBounds().getX(), ijRoi.getBounds().getY(), ijRoi.getBounds().getWidth(), ijRoi.getBounds().getHeight());
        ((RectangleData)this.data).setText(ijRoi.getName());
        super.copyFromIJRoi(ijRoi);
    }

    public RectangleWrapper(double x, double y, double width, double height) {
        this(new RectangleData(x, y, width, height));
    }

    @Override
    public String getText() {
        return ((RectangleData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((RectangleData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public double getX() {
        return ((RectangleData)this.data).getX();
    }

    public void setX(double x) {
        ((RectangleData)this.data).setX(x);
    }

    public double getY() {
        return ((RectangleData)this.data).getY();
    }

    public void setY(double y) {
        ((RectangleData)this.data).setY(y);
    }

    public double getWidth() {
        return ((RectangleData)this.data).getWidth();
    }

    public void setWidth(double width) {
        ((RectangleData)this.data).setWidth(width);
    }

    public double getHeight() {
        return ((RectangleData)this.data).getHeight();
    }

    public void setHeight(double height) {
        ((RectangleData)this.data).setHeight(height);
    }

    public void setCoordinates(double x, double y, double width, double height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public double[] getCoordinates() {
        double[] coordinates = new double[]{this.getX(), this.getY(), this.getWidth(), this.getHeight()};
        return coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            String msg = "RectangleData cannot set null coordinates.";
            throw new IllegalArgumentException(msg);
        }
        if (coordinates.length != 4) {
            String msg = "4 coordinates required for RectangleData.";
            throw new IllegalArgumentException(msg);
        }
        ((RectangleData)this.data).setX(coordinates[0]);
        ((RectangleData)this.data).setY(coordinates[1]);
        ((RectangleData)this.data).setWidth(coordinates[2]);
        ((RectangleData)this.data).setHeight(coordinates[3]);
    }

    @Override
    public Roi toImageJ() {
        Roi roi;
        AffineTransform transform = this.toAWTTransform();
        if (transform.getType() == 0) {
            roi = new Roi(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else {
            PointWrapper p1 = new PointWrapper(this.getX(), this.getY() + this.getHeight() / 2.0);
            PointWrapper p2 = new PointWrapper(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0);
            p1.setTransform(transform);
            p2.setTransform(transform);
            Rectangle2D shape1 = p1.createTransformedAWTShape().getBounds2D();
            Rectangle2D shape2 = p2.createTransformedAWTShape().getBounds2D();
            double x1 = shape1.getX();
            double y1 = shape1.getY();
            double x2 = shape2.getX();
            double y2 = shape2.getY();
            roi = new RotatedRectRoi(x1, y1, x2, y2, this.getWidth());
        }
        this.copyToIJRoi(roi);
        return roi;
    }
}

