/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.AnnotatableWrapper;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PixelsWrapper;
import fr.igred.omero.roi.EllipseWrapper;
import fr.igred.omero.roi.GenericShapeWrapper;
import fr.igred.omero.roi.PointWrapper;
import fr.igred.omero.roi.PolygonWrapper;
import fr.igred.omero.roi.RectangleWrapper;
import fr.igred.omero.roi.ShapeList;
import ij.IJ;
import ij.gui.PointRoi;
import ij.gui.ShapeRoi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ShapeData;
import omero.model.IObject;
import omero.model.Roi;
import omero.model.RoiAnnotationLinkI;
import omero.model._RoiOperationsNC;
import omero.rtypes;

public class ROIWrapper
extends AnnotatableWrapper<ROIData> {
    public static final String ANNOTATION_LINK = "RoiAnnotationLink";
    public static final String IJ_PROPERTY = "ROI";

    public ROIWrapper() {
        super(new ROIData());
    }

    public ROIWrapper(Iterable<? extends GenericShapeWrapper<?>> shapes) {
        super(new ROIData());
        for (GenericShapeWrapper<?> shape : shapes) {
            ((ROIData)this.data).addShapeData((ShapeData)shape.asDataObject());
        }
    }

    public ROIWrapper(ROIData roi) {
        super(roi);
    }

    public static String checkProperty(String property) {
        if (property == null || property.trim().isEmpty()) {
            return IJ_PROPERTY;
        }
        return property;
    }

    public static String ijIDProperty(String property) {
        property = ROIWrapper.checkProperty(property);
        return property + "_ID";
    }

    public static String ijNameProperty(String property) {
        property = ROIWrapper.checkProperty(property);
        return property + "_NAME";
    }

    public static List<ROIWrapper> fromImageJ(List<? extends ij.gui.Roi> ijRois) {
        return ROIWrapper.fromImageJ(ijRois, IJ_PROPERTY);
    }

    public static List<ROIWrapper> fromImageJ(List<? extends ij.gui.Roi> ijRois, String property) {
        return ROIWrapper.fromImageJ(ijRois, property, ROIWrapper::new, GenericShapeWrapper::fromImageJ);
    }

    private static List<ROIWrapper> fromImageJ(List<? extends ij.gui.Roi> ijRois, String property, Supplier<? extends ROIWrapper> constructor, Function<? super ij.gui.Roi, ? extends List<? extends GenericShapeWrapper<?>>> converter) {
        property = ROIWrapper.checkProperty(property);
        TreeMap<String, ROIWrapper> rois4D = new TreeMap<String, ROIWrapper>();
        TreeMap<String, String> names = new TreeMap<String, String>();
        TreeMap<Integer, ROIWrapper> shape2roi = new TreeMap<Integer, ROIWrapper>();
        for (int i = 0; i < ijRois.size(); ++i) {
            ROIWrapper roi2;
            String value2 = ijRois.get(i).getProperty(property);
            String name = ijRois.get(i).getProperty(ROIWrapper.ijNameProperty(property));
            if (value2 != null && !value2.trim().isEmpty()) {
                roi2 = rois4D.computeIfAbsent(value2, v -> (ROIWrapper)constructor.get());
                names.putIfAbsent(value2, name);
            } else {
                roi2 = constructor.get();
                roi2.setName(name);
            }
            shape2roi.put(i, roi2);
        }
        rois4D.forEach((id, roi) -> roi.setName((String)names.get(id)));
        shape2roi.forEach((key, value) -> value.addShapes((List)converter.apply((ij.gui.Roi)ijRois.get((int)key))));
        return shape2roi.values().stream().distinct().collect(Collectors.toList());
    }

    public static List<ij.gui.Roi> toImageJ(List<? extends ROIWrapper> rois) {
        return ROIWrapper.toImageJ(rois, IJ_PROPERTY);
    }

    public static List<ij.gui.Roi> toImageJ(List<? extends ROIWrapper> rois, String property) {
        return ROIWrapper.toImageJ(rois, property, true);
    }

    public static List<ij.gui.Roi> toImageJ(Collection<? extends ROIWrapper> rois, String property, boolean groupRois) {
        property = ROIWrapper.checkProperty(property);
        int maxGroups = 255;
        groupRois = groupRois && rois.size() < 255 && IJ.getVersion().compareTo("1.52t") >= 0;
        int nShapes = rois.stream().map(GenericObjectWrapper::asDataObject).mapToInt(ROIData::getShapeCount).sum();
        ArrayList<ij.gui.Roi> ijRois = new ArrayList<ij.gui.Roi>(nShapes);
        int index = 1;
        for (ROIWrapper rOIWrapper : rois) {
            String name = rOIWrapper.getName();
            List<ij.gui.Roi> shapes = rOIWrapper.toImageJ(property);
            for (ij.gui.Roi r : shapes) {
                r.setProperty(property, String.valueOf(index));
                r.setProperty(ROIWrapper.ijNameProperty(property), name);
                if (!groupRois) continue;
                r.setGroup(index);
            }
            ijRois.addAll(shapes);
            ++index;
        }
        return ijRois;
    }

    private static ij.gui.Roi xor(Collection<? extends ij.gui.Roi> rois) {
        String idProperty = "SHAPE_ID";
        String shapeIDs = rois.stream().map(r -> r.getProperty(idProperty)).collect(Collectors.joining(","));
        ij.gui.Roi roi = rois.iterator().next();
        if (rois.size() > 1) {
            ij.gui.Roi xor = rois.stream().map(ShapeRoi::new).reduce(ShapeRoi::xor).map(ij.gui.Roi.class::cast).orElse(roi);
            xor.setStrokeColor(roi.getStrokeColor());
            xor.setFillColor(roi.getFillColor());
            xor.setPosition(roi.getCPosition(), roi.getZPosition(), roi.getTPosition());
            xor.setName(roi.getName());
            xor.setProperty(idProperty, shapeIDs);
            roi = xor;
        }
        return roi;
    }

    private static PointRoi combine(Collection<? extends PointRoi> points) {
        String idProperty = "SHAPE_ID";
        String shapeIDs = points.stream().map(p -> p.getProperty(idProperty)).collect(Collectors.joining(","));
        PointRoi point = points.iterator().next();
        points.stream().skip(1L).forEachOrdered(p -> point.addPoint(p.getXBase(), p.getYBase()));
        point.setProperty(idProperty, shapeIDs);
        return point;
    }

    private ij.gui.Roi shapeToIJRoiWithName(GenericShapeWrapper<?> shape) {
        ij.gui.Roi roi = shape.toImageJ();
        String name = roi.getName();
        String defaultName = String.format("%d-%d", this.getId(), shape.getId());
        if (name.isEmpty()) {
            roi.setName(defaultName);
        }
        return roi;
    }

    public String getName() {
        RString name = ((_RoiOperationsNC)((ROIData)this.data).asIObject()).getName();
        return name != null ? name.getValue() : "";
    }

    public void setName(String name) {
        ((_RoiOperationsNC)((ROIData)this.data).asIObject()).setName(rtypes.rstring((String)name));
    }

    @Deprecated
    public void setData(ROIData data) {
        this.data = data;
    }

    public void addShapes(List<? extends GenericShapeWrapper<?>> shapes) {
        shapes.forEach(this::addShape);
    }

    public void addShape(GenericShapeWrapper<?> shape) {
        ((ROIData)this.data).addShapeData((ShapeData)shape.asDataObject());
    }

    public ShapeList getShapes() {
        List shapeData = ((ROIData)this.data).getShapes();
        ShapeList shapes = new ShapeList(shapeData.size());
        shapeData.stream().sorted(Comparator.comparing(DataObject::getId)).forEachOrdered(shapes::add);
        return shapes;
    }

    public void setImage(ImageWrapper image) {
        ((ROIData)this.data).setImage(((ImageData)image.asDataObject()).asImage());
    }

    @Deprecated
    public ROIData asROIData() {
        return (ROIData)this.data;
    }

    public void deleteShape(ShapeData shape) {
        ((ROIData)this.data).removeShapeData(shape);
    }

    public void deleteShape(int pos) {
        ((ROIData)this.data).removeShapeData((ShapeData)((ROIData)this.data).getShapes().get(pos));
    }

    public void saveROI(Client client) throws OMEROServerError, ServiceException {
        Roi roi = (Roi)ExceptionHandler.of(client.getGateway(), g -> g.getUpdateService(client.getCtx()).saveAndReturnObject(((ROIData)this.data).asIObject())).handleServiceOrServer("Cannot save ROI").get();
        this.data = new ROIData(roi);
    }

    public PixelsWrapper.Bounds getBounds() {
        int[] x = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] y = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] c = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] z = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] t = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (GenericShapeWrapper shape : this.getShapes()) {
            RectangleWrapper box = shape.getBoundingBox();
            x[0] = Math.min(x[0], (int)box.getX());
            y[0] = Math.min(y[0], (int)box.getY());
            c[0] = Math.min(c[0], box.getC());
            z[0] = Math.min(z[0], box.getZ());
            t[0] = Math.min(t[0], box.getT());
            x[1] = Math.max(x[1], (int)(box.getX() + box.getWidth() - 1.0));
            y[1] = Math.max(y[1], (int)(box.getY() + box.getHeight() - 1.0));
            c[1] = Math.max(c[1], box.getC());
            z[1] = Math.max(z[1], box.getZ());
            t[1] = Math.max(t[1], box.getT());
        }
        PixelsWrapper.Coordinates start = new PixelsWrapper.Coordinates(x[0], y[0], c[0], z[0], t[0]);
        PixelsWrapper.Coordinates end = new PixelsWrapper.Coordinates(x[1], y[1], c[1], z[1], t[1]);
        return new PixelsWrapper.Bounds(start, end);
    }

    public List<ij.gui.Roi> toImageJ() {
        return this.toImageJ(IJ_PROPERTY);
    }

    public List<ij.gui.Roi> toImageJ(String property) {
        property = ROIWrapper.checkProperty(property);
        String ijIDProperty = ROIWrapper.ijIDProperty(property);
        String ijNameProperty = ROIWrapper.ijNameProperty(property);
        String roiID = String.valueOf(this.getId());
        ShapeList shapes = this.getShapes();
        Map sameSlice = shapes.stream().collect(Collectors.groupingBy(GenericShapeWrapper::getCZT, LinkedHashMap::new, Collectors.toList()));
        sameSlice.values().removeIf(List::isEmpty);
        ArrayList<ij.gui.Roi> rois = new ArrayList<ij.gui.Roi>(shapes.size());
        for (List slice : sameSlice.values()) {
            List toXOR = slice.stream().filter(s -> s instanceof RectangleWrapper || s instanceof EllipseWrapper || s instanceof PolygonWrapper).map(this::shapeToIJRoiWithName).collect(Collectors.toList());
            if (!toXOR.isEmpty()) {
                rois.add(ROIWrapper.xor(toXOR));
            }
            List points = slice.stream().filter(PointWrapper.class::isInstance).map(this::shapeToIJRoiWithName).map(PointRoi.class::cast).collect(Collectors.toList());
            if (!points.isEmpty()) {
                rois.add((ij.gui.Roi)ROIWrapper.combine(points));
            }
            slice.stream().filter(s -> !(s instanceof RectangleWrapper) && !(s instanceof EllipseWrapper) && !(s instanceof PolygonWrapper) && !(s instanceof PointWrapper)).map(this::shapeToIJRoiWithName).forEachOrdered(rois::add);
            rois.forEach(r -> r.setProperty(ijIDProperty, roiID));
            rois.forEach(r -> r.setProperty(ijNameProperty, this.getName()));
        }
        return rois;
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    protected <A extends AnnotationData> void link(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        RoiAnnotationLinkI link = new RoiAnnotationLinkI();
        link.setChild(annotation.asAnnotation());
        link.setParent((Roi)((ROIData)this.data).asIObject());
        client.save((IObject)link);
    }
}

