/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import ij.gui.Roi;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import omero.gateway.model.PolylineData;

public class PolylineWrapper
extends GenericShapeWrapper<PolylineData> {
    public PolylineWrapper(PolylineData polyline) {
        super(polyline);
    }

    public PolylineWrapper() {
        this(new PolylineData());
    }

    public PolylineWrapper(Roi ijRoi) {
        this();
        float[] x = ijRoi.getFloatPolygon().xpoints;
        float[] y = ijRoi.getFloatPolygon().ypoints;
        LinkedList points = new LinkedList();
        IntStream.range(0, x.length).forEach(i -> points.add(new Point2D.Double(x[i], y[i])));
        ((PolylineData)this.data).setPoints(points);
        ((PolylineData)this.data).setText(ijRoi.getName());
        super.copyFromIJRoi(ijRoi);
    }

    public PolylineWrapper(List<Point2D.Double> points) {
        this(new PolylineData(points));
    }

    @Override
    public String getText() {
        return ((PolylineData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((PolylineData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        Path2D.Double polyline = new Path2D.Double();
        List<Point2D.Double> points = this.getPoints();
        if (!points.isEmpty()) {
            ((Path2D)polyline).moveTo(points.get((int)0).x, points.get((int)0).y);
            for (int i = 1; i < points.size(); ++i) {
                ((Path2D)polyline).lineTo(points.get((int)i).x, points.get((int)i).y);
            }
        }
        return polyline;
    }

    public List<Point2D.Double> getPoints() {
        return ((PolylineData)this.data).getPoints();
    }

    public void setPoints(List<Point2D.Double> points) {
        ((PolylineData)this.data).setPoints(points);
    }
}

