/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import ij.gui.Roi;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import omero.gateway.model.PolygonData;

public class PolygonWrapper
extends GenericShapeWrapper<PolygonData> {
    public PolygonWrapper(PolygonData polygon) {
        super(polygon);
    }

    public PolygonWrapper() {
        this(new PolygonData());
    }

    public PolygonWrapper(Roi ijRoi) {
        this();
        float[] x = ijRoi.getFloatPolygon().xpoints;
        float[] y = ijRoi.getFloatPolygon().ypoints;
        LinkedList points = new LinkedList();
        IntStream.range(0, x.length).forEach(i -> points.add(new Point2D.Double(x[i], y[i])));
        ((PolygonData)this.data).setPoints(points);
        ((PolygonData)this.data).setText(ijRoi.getName());
        super.copyFromIJRoi(ijRoi);
    }

    public PolygonWrapper(List<Point2D.Double> points) {
        this(new PolygonData(points));
    }

    @Override
    public String getText() {
        return ((PolygonData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((PolygonData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        Path2D.Double polygon = new Path2D.Double();
        List<Point2D.Double> points = this.getPoints();
        if (!points.isEmpty()) {
            ((Path2D)polygon).moveTo(points.get((int)0).x, points.get((int)0).y);
            for (int i = 1; i < points.size(); ++i) {
                ((Path2D)polygon).lineTo(points.get((int)i).x, points.get((int)i).y);
            }
            polygon.closePath();
        }
        return polygon;
    }

    public List<Point2D.Double> getPoints() {
        return ((PolygonData)this.data).getPoints();
    }

    public void setPoints(List<Point2D.Double> points) {
        ((PolygonData)this.data).setPoints(points);
    }

    public List<Integer> getMaskPoints() {
        return ((PolygonData)this.data).getMaskPoints();
    }
}

