/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import ij.gui.PointRoi;
import ij.gui.Roi;
import java.awt.Shape;
import java.awt.geom.Path2D;
import omero.gateway.model.PointData;

public class PointWrapper
extends GenericShapeWrapper<PointData> {
    public PointWrapper(PointData point) {
        super(point);
    }

    public PointWrapper() {
        this(new PointData());
    }

    public PointWrapper(double x, double y) {
        this(new PointData(x, y));
    }

    @Override
    public String getText() {
        return ((PointData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((PointData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        Path2D.Double point = new Path2D.Double();
        ((Path2D)point).moveTo(this.getX(), this.getY());
        return point;
    }

    public double getX() {
        return ((PointData)this.data).getX();
    }

    public void setX(double x) {
        ((PointData)this.data).setX(x);
    }

    public double getY() {
        return ((PointData)this.data).getY();
    }

    public void setY(double y) {
        ((PointData)this.data).setY(y);
    }

    public void setCoordinates(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public double[] getCoordinates() {
        double[] coordinates = new double[]{this.getX(), this.getY()};
        return coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            String msg = "PointData cannot set null coordinates.";
            throw new IllegalArgumentException(msg);
        }
        if (coordinates.length != 2) {
            String msg = "2 coordinates required for PointData.";
            throw new IllegalArgumentException(msg);
        }
        ((PointData)this.data).setX(coordinates[0]);
        ((PointData)this.data).setY(coordinates[1]);
    }

    @Override
    public Roi toImageJ() {
        Shape awtShape = this.createTransformedAWTShape();
        double x = awtShape.getBounds2D().getX();
        double y = awtShape.getBounds2D().getY();
        PointRoi roi = new PointRoi(x, y);
        this.copyToIJRoi((Roi)roi);
        return roi;
    }
}

