/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import fr.igred.omero.roi.PointWrapper;
import ij.gui.ImageRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import omero.gateway.model.MaskData;

public class MaskWrapper
extends GenericShapeWrapper<MaskData> {
    private static final double MAX_UINT8 = 255.0;

    public MaskWrapper(MaskData mask) {
        super(mask);
    }

    public MaskWrapper() {
        this(new MaskData());
    }

    public MaskWrapper(ImageRoi imageRoi) {
        this();
        ((MaskData)this.data).setX(imageRoi.getXBase());
        ((MaskData)this.data).setY(imageRoi.getYBase());
        ((MaskData)this.data).setWidth(imageRoi.getFloatWidth());
        ((MaskData)this.data).setHeight(imageRoi.getFloatHeight());
        ImageProcessor ip = imageRoi.getProcessor();
        ip.flipVertical();
        ((MaskData)this.data).setMask(ip.getIntArray());
        ip.flipVertical();
        Color lut = new Color(ip.getCurrentColorModel().getRGB((int)ip.getMax()));
        int r = lut.getRed();
        int g = lut.getGreen();
        int b = lut.getBlue();
        int a = (int)(imageRoi.getOpacity() * 255.0);
        ((MaskData)this.data).setText(imageRoi.getName());
        super.copyFromIJRoi((Roi)imageRoi);
        ((MaskData)this.data).getShapeSettings().setFill(new Color(r, g, b, a));
        double angle = StrictMath.toRadians(-imageRoi.getAngle());
        AffineTransform transform = new AffineTransform();
        transform.rotate(angle, imageRoi.getXBase(), imageRoi.getYBase());
        super.setTransform(transform);
    }

    public MaskWrapper(double x, double y, double width, double height, byte[] mask) {
        this(new MaskData(x, y, width, height, mask));
    }

    @Override
    public String getText() {
        return ((MaskData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((MaskData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public double getX() {
        return ((MaskData)this.data).getX();
    }

    public void setX(double x) {
        ((MaskData)this.data).setX(x);
    }

    public double getY() {
        return ((MaskData)this.data).getY();
    }

    public void setY(double y) {
        ((MaskData)this.data).setY(y);
    }

    public double getWidth() {
        return ((MaskData)this.data).getWidth();
    }

    public void setWidth(double width) {
        ((MaskData)this.data).setWidth(width);
    }

    public double getHeight() {
        return ((MaskData)this.data).getHeight();
    }

    public void setHeight(double height) {
        ((MaskData)this.data).setHeight(height);
    }

    public int[][] getMaskAsBinaryArray() {
        return ((MaskData)this.data).getMaskAsBinaryArray();
    }

    public BufferedImage getMaskAsBufferedImage() {
        return ((MaskData)this.data).getMaskAsBufferedImage();
    }

    public byte[] getMask() {
        return ((MaskData)this.data).getMask();
    }

    public void setMask(byte[] mask) {
        ((MaskData)this.data).setMask(mask);
    }

    public void setMask(int[][] mask) {
        ((MaskData)this.data).setMask(mask);
    }

    public void setMask(boolean[][] mask) {
        ((MaskData)this.data).setMask(mask);
    }

    public void setCoordinates(double x, double y, double width, double height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public double[] getCoordinates() {
        double[] coordinates = new double[]{this.getX(), this.getY(), this.getWidth(), this.getHeight()};
        return coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            String msg = "MaskData cannot set null coordinates.";
            throw new IllegalArgumentException(msg);
        }
        if (coordinates.length != 4) {
            String msg = "4 coordinates required for MaskData.";
            throw new IllegalArgumentException(msg);
        }
        ((MaskData)this.data).setX(coordinates[0]);
        ((MaskData)this.data).setY(coordinates[1]);
        ((MaskData)this.data).setWidth(coordinates[2]);
        ((MaskData)this.data).setHeight(coordinates[3]);
    }

    @Override
    public Roi toImageJ() {
        ImageRoi roi;
        AffineTransform transform = this.toAWTTransform();
        if (transform.getType() == 0) {
            int x = (int)this.getX();
            int y = (int)this.getY();
            ImageRoi imgRoi = new ImageRoi(x, y, this.getMaskAsBufferedImage());
            imgRoi.setZeroTransparent(true);
            imgRoi.setOpacity((double)this.getFill().getAlpha() / 255.0);
            roi = imgRoi;
        } else {
            PointWrapper p1 = new PointWrapper(this.getX(), this.getY() + this.getHeight() / 2.0);
            PointWrapper p2 = new PointWrapper(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0);
            p1.setTransform(transform);
            p2.setTransform(transform);
            Rectangle2D shape1 = p1.createTransformedAWTShape().getBounds2D();
            Rectangle2D shape2 = p2.createTransformedAWTShape().getBounds2D();
            double x1 = shape1.getX();
            double y1 = shape1.getY();
            double x2 = shape2.getX();
            double y2 = shape2.getY();
            roi = new RotatedRectRoi(x1, y1, x2, y2, this.getWidth());
        }
        this.copyToIJRoi((Roi)roi);
        return roi;
    }
}

