/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import fr.igred.omero.roi.PointWrapper;
import ij.gui.Arrow;
import ij.gui.Line;
import ij.gui.Roi;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import omero.gateway.model.LineData;

public class LineWrapper
extends GenericShapeWrapper<LineData> {
    public static final String ARROW = "Arrow";

    public LineWrapper(LineData line) {
        super(line);
    }

    public LineWrapper() {
        this(new LineData());
    }

    public LineWrapper(Line line) {
        this(line.x1d, line.y1d, line.x2d, line.y2d);
        ((LineData)this.data).setText(line.getName());
        if (line instanceof Arrow) {
            ((LineData)this.data).getShapeSettings().setMarkerEnd(ARROW);
            if (((Arrow)line).getDoubleHeaded()) {
                ((LineData)this.data).getShapeSettings().setMarkerStart(ARROW);
            }
        }
        super.copyFromIJRoi((Roi)line);
    }

    public LineWrapper(double x1, double y1, double x2, double y2) {
        this(new LineData(x1, y1, x2, y2));
    }

    @Override
    public String getText() {
        return ((LineData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((LineData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        return new Line2D.Double(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public double getX1() {
        return ((LineData)this.data).getX1();
    }

    public void setX1(double x1) {
        ((LineData)this.data).setX1(x1);
    }

    public double getX2() {
        return ((LineData)this.data).getX2();
    }

    public void setX2(double x2) {
        ((LineData)this.data).setX2(x2);
    }

    public double getY1() {
        return ((LineData)this.data).getY1();
    }

    public void setY1(double y1) {
        ((LineData)this.data).setY1(y1);
    }

    public double getY2() {
        return ((LineData)this.data).getY2();
    }

    public void setY2(double y2) {
        ((LineData)this.data).setY2(y2);
    }

    public void setCoordinates(double x1, double y1, double x2, double y2) {
        this.setX1(x1);
        this.setY1(y1);
        this.setX2(x2);
        this.setY2(y2);
    }

    public double[] getCoordinates() {
        double[] coordinates = new double[]{this.getX1(), this.getY1(), this.getX2(), this.getY2()};
        return coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            String msg = "LineData cannot set null coordinates.";
            throw new IllegalArgumentException(msg);
        }
        if (coordinates.length != 4) {
            String msg = "4 coordinates required for LineData.";
            throw new IllegalArgumentException(msg);
        }
        ((LineData)this.data).setX1(coordinates[0]);
        ((LineData)this.data).setY1(coordinates[1]);
        ((LineData)this.data).setX2(coordinates[2]);
        ((LineData)this.data).setY2(coordinates[3]);
    }

    @Override
    public Roi toImageJ() {
        Arrow roi;
        PointWrapper p1 = new PointWrapper(this.getX1(), this.getY1());
        PointWrapper p2 = new PointWrapper(this.getX2(), this.getY2());
        AffineTransform transform = this.toAWTTransform();
        if (transform != null) {
            p1.setTransform(transform);
            p2.setTransform(transform);
        }
        Rectangle2D shape1 = p1.createTransformedAWTShape().getBounds2D();
        Rectangle2D shape2 = p2.createTransformedAWTShape().getBounds2D();
        String start = ((LineData)this.data).getShapeSettings().getMarkerStart();
        String end = ((LineData)this.data).getShapeSettings().getMarkerEnd();
        double x1 = shape1.getX();
        double x2 = shape2.getX();
        double y1 = shape1.getY();
        double y2 = shape2.getY();
        byte arrowStart = (byte)(start.equals(ARROW) ? 1 : 0);
        byte arrowEnd = (byte)(end.equals(ARROW) ? 1 : 0);
        byte arrow = (byte)(arrowStart + 2 * arrowEnd);
        switch (arrow) {
            case 3: {
                roi = new Arrow(x1, y1, x2, y2);
                roi.setDoubleHeaded(true);
                break;
            }
            case 2: {
                roi = new Arrow(x1, y1, x2, y2);
                break;
            }
            case 1: {
                roi = new Arrow(x2, y2, x1, y1);
                break;
            }
            default: {
                roi = new Line(x1, y1, x2, y2);
            }
        }
        this.copyToIJRoi((Roi)roi);
        return roi;
    }
}

