/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.AnnotatableWrapper;
import fr.igred.omero.Client;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.roi.EllipseWrapper;
import fr.igred.omero.roi.LineWrapper;
import fr.igred.omero.roi.MaskWrapper;
import fr.igred.omero.roi.PointWrapper;
import fr.igred.omero.roi.PolygonWrapper;
import fr.igred.omero.roi.PolylineWrapper;
import fr.igred.omero.roi.RectangleWrapper;
import fr.igred.omero.roi.ShapeList;
import fr.igred.omero.roi.TextWrapper;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ome.model.units.BigResult;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ShapeData;
import omero.model.AffineTransform;
import omero.model.AffineTransformI;
import omero.model.IObject;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.ShapeAnnotationLinkI;
import omero.model.enums.UnitsLength;
import omero.rtypes;

public abstract class GenericShapeWrapper<T extends ShapeData>
extends AnnotatableWrapper<T> {
    public static final String ANNOTATION_LINK = "ShapeAnnotationLink";
    public static final String IJ_ID_PROPERTY = "SHAPE_ID";
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);

    protected GenericShapeWrapper(T s) {
        super(s);
    }

    static ShapeList fromImageJ(Roi ijRoi) {
        ShapeList list = new ShapeList();
        int type = ijRoi.getType();
        switch (type) {
            case 2: 
            case 3: 
            case 4: {
                list.add(new PolygonWrapper(ijRoi));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                list.add(new PolylineWrapper(ijRoi));
                break;
            }
            case 5: {
                list.add(new LineWrapper((Line)ijRoi));
                break;
            }
            case 1: {
                list.add(new EllipseWrapper(ijRoi));
                break;
            }
            case 10: {
                float[] x = ijRoi.getFloatPolygon().xpoints;
                float[] y = ijRoi.getFloatPolygon().ypoints;
                LinkedList<PointWrapper> points = new LinkedList<PointWrapper>();
                for (int i = 0; i < x.length; ++i) {
                    points.add(new PointWrapper(x[i], y[i]));
                }
                points.forEach(p -> p.setText(ijRoi.getName()));
                points.forEach(p -> p.copyFromIJRoi(ijRoi));
                list.addAll(points);
                break;
            }
            case 9: {
                List<Roi> rois = Arrays.asList(((ShapeRoi)ijRoi).getRois());
                rois.forEach(r -> r.setName(ijRoi.getName()));
                rois.forEach(r -> r.setPosition(ijRoi.getCPosition(), ijRoi.getZPosition(), ijRoi.getTPosition()));
                rois.stream().map(GenericShapeWrapper::fromImageJ).forEach(list::addAll);
                break;
            }
            default: {
                if (ijRoi instanceof TextRoi) {
                    list.add(new TextWrapper((TextRoi)ijRoi));
                    break;
                }
                if (ijRoi instanceof ImageRoi) {
                    list.add(new MaskWrapper((ImageRoi)ijRoi));
                    break;
                }
                list.add(new RectangleWrapper(ijRoi));
            }
        }
        return list;
    }

    private static double extractAngle(java.awt.geom.AffineTransform transform) {
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(1.0, 0.0);
        Point2D tp1 = transform.transform(p1, null);
        Point2D tp2 = transform.transform(p2, null);
        double dx = tp2.getX() - tp1.getX();
        double dy = tp2.getY() - tp1.getY();
        return StrictMath.atan2(dy, dx);
    }

    protected void copyFromIJRoi(Roi ijRoi) {
        LengthI size = new LengthI((double)ijRoi.getStrokeWidth(), UnitsLength.POINT);
        Color defaultStroke = Optional.ofNullable(Roi.getColor()).orElse(Color.YELLOW);
        Color defaultFill = Optional.ofNullable(Roi.getDefaultFillColor()).orElse(TRANSPARENT);
        Color stroke = Optional.ofNullable(ijRoi.getStrokeColor()).orElse(defaultStroke);
        Color fill = Optional.ofNullable(ijRoi.getFillColor()).orElse(defaultFill);
        ((ShapeData)this.data).getShapeSettings().setStrokeWidth((Length)size);
        ((ShapeData)this.data).getShapeSettings().setStroke(stroke);
        ((ShapeData)this.data).getShapeSettings().setFill(fill);
        int c = ijRoi.getCPosition();
        int z = ijRoi.getZPosition();
        int t = ijRoi.getTPosition();
        if (!ijRoi.hasHyperStackPosition()) {
            ImagePlus imp = ijRoi.getImage();
            if (imp == null) {
                imp = WindowManager.getImage((int)ijRoi.getImageID());
            }
            if (imp != null) {
                int stackSize = imp.getStackSize();
                int imageC = imp.getNChannels();
                int imageZ = imp.getNSlices();
                int imageT = imp.getNFrames();
                int pos = ijRoi.getPosition();
                c = 1;
                z = 1;
                t = 1;
                if (stackSize == imageZ) {
                    z = pos;
                } else if (stackSize == imageC) {
                    c = pos;
                } else if (stackSize == imageT) {
                    t = pos;
                }
            }
        }
        ((ShapeData)this.data).setC(Math.max(-1, c - 1));
        ((ShapeData)this.data).setZ(Math.max(-1, z - 1));
        ((ShapeData)this.data).setT(Math.max(-1, t - 1));
        if (ijRoi instanceof TextRoi) {
            this.copyFromIJTextRoi((TextRoi)ijRoi);
        }
    }

    private void copyFromIJTextRoi(TextRoi text) {
        Font font = text.getCurrentFont();
        this.setFontSize(font.getSize());
        int style = font.getStyle();
        String fontStyle = style == 1 ? "Bold" : (style == 2 ? "Italic" : (style == 3 ? "BoldItalic" : "Normal"));
        ((ShapeData)this.data).getShapeSettings().setFontStyle(fontStyle);
        ((ShapeData)this.data).getShapeSettings().setFontFamily(font.getFamily());
        double angle = StrictMath.toRadians(-text.getAngle());
        double x = text.getBounds().getX();
        double y = text.getBounds().getY();
        java.awt.geom.AffineTransform at = new java.awt.geom.AffineTransform();
        at.rotate(angle, x, y);
        this.setTransform(at);
    }

    protected void copyToIJRoi(Roi ijRoi) {
        ijRoi.setName(this.getText());
        ijRoi.setStrokeColor(this.getStroke());
        Color fill = this.getFill();
        if (!TRANSPARENT.equals(fill)) {
            ijRoi.setFillColor(fill);
        }
        int c = Math.max(0, this.getC() + 1);
        int z = Math.max(0, this.getZ() + 1);
        int t = Math.max(0, this.getT() + 1);
        ijRoi.setPosition(c, z, t);
        if (ijRoi instanceof TextRoi) {
            this.copyToIJTextRoi((TextRoi)ijRoi);
        }
        ijRoi.setProperty(IJ_ID_PROPERTY, String.valueOf(((ShapeData)this.data).getId()));
    }

    private void copyToIJTextRoi(TextRoi text) {
        double angle = -StrictMath.toDegrees(GenericShapeWrapper.extractAngle(this.toAWTTransform()));
        text.setAngle(angle);
        String fontFamily = ((ShapeData)this.data).getShapeSettings().getFontFamily();
        String fontStyle = ((ShapeData)this.data).getShapeSettings().getFontStyle();
        int style = 0;
        if ("Bold".equals(fontStyle)) {
            style = 1;
        } else if ("Italic".equals(fontStyle)) {
            style = 2;
        } else if ("BoldItalic".equals(fontStyle)) {
            style = 3;
        }
        text.setFont(new Font(fontFamily, style, (int)this.getFontSize()));
    }

    @Deprecated
    public T asShapeData() {
        return (T)((ShapeData)this.data);
    }

    public int getC() {
        return ((ShapeData)this.data).getC();
    }

    public void setC(int c) {
        ((ShapeData)this.data).setC(c);
    }

    public int getZ() {
        return ((ShapeData)this.data).getZ();
    }

    public void setZ(int z) {
        ((ShapeData)this.data).setZ(z);
    }

    public int getT() {
        return ((ShapeData)this.data).getT();
    }

    public void setT(int t) {
        ((ShapeData)this.data).setT(t);
    }

    public void setCZT(int c, int z, int t) {
        this.setC(c);
        this.setZ(z);
        this.setT(t);
    }

    String getCZT() {
        return String.format("%d,%d,%d", this.getC(), this.getZ(), this.getT());
    }

    public double getFontSize() {
        double fontSize = Double.NaN;
        try {
            fontSize = ((ShapeData)this.data).getShapeSettings().getFontSize(UnitsLength.POINT).getValue();
        }
        catch (BigResult bigResult) {
            String msg = "Error while getting font size from ShapeData.";
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, msg, bigResult);
        }
        return fontSize;
    }

    public void setFontSize(double value) {
        LengthI size = new LengthI(value, UnitsLength.POINT);
        ((ShapeData)this.data).getShapeSettings().setFontSize((Length)size);
    }

    public Color getStroke() {
        return ((ShapeData)this.data).getShapeSettings().getStroke();
    }

    public void setStroke(Color strokeColour) {
        ((ShapeData)this.data).getShapeSettings().setStroke(strokeColour);
    }

    public Color getFill() {
        return ((ShapeData)this.data).getShapeSettings().getFill();
    }

    public void setFill(Color fillColour) {
        ((ShapeData)this.data).getShapeSettings().setFill(fillColour);
    }

    public abstract String getText();

    public abstract void setText(String var1);

    public abstract Shape toAWTShape();

    public void setTransform(double a00, double a10, double a01, double a11, double a02, double a12) {
        AffineTransformI transform = new AffineTransformI();
        transform.setA00(rtypes.rdouble((double)a00));
        transform.setA10(rtypes.rdouble((double)a10));
        transform.setA01(rtypes.rdouble((double)a01));
        transform.setA11(rtypes.rdouble((double)a11));
        transform.setA02(rtypes.rdouble((double)a02));
        transform.setA12(rtypes.rdouble((double)a12));
        ((ShapeData)this.data).setTransform((AffineTransform)transform);
    }

    public void setTransform(java.awt.geom.AffineTransform transform) {
        double[] a = new double[6];
        transform.getMatrix(a);
        this.setTransform(a[0], a[1], a[2], a[3], a[4], a[5]);
    }

    public java.awt.geom.AffineTransform toAWTTransform() {
        if (((ShapeData)this.data).getTransform() == null) {
            return new java.awt.geom.AffineTransform();
        }
        double a00 = ((ShapeData)this.data).getTransform().getA00().getValue();
        double a10 = ((ShapeData)this.data).getTransform().getA10().getValue();
        double a01 = ((ShapeData)this.data).getTransform().getA01().getValue();
        double a11 = ((ShapeData)this.data).getTransform().getA11().getValue();
        double a02 = ((ShapeData)this.data).getTransform().getA02().getValue();
        double a12 = ((ShapeData)this.data).getTransform().getA12().getValue();
        return new java.awt.geom.AffineTransform(a00, a10, a01, a11, a02, a12);
    }

    public Shape createTransformedAWTShape() {
        if (this.toAWTTransform().getType() == 0) {
            return this.toAWTShape();
        }
        return this.toAWTTransform().createTransformedShape(this.toAWTShape());
    }

    public RectangleWrapper getBoundingBox() {
        Rectangle2D rectangle = this.createTransformedAWTShape().getBounds2D();
        double x = rectangle.getX();
        double y = rectangle.getY();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        RectangleWrapper boundingBox = new RectangleWrapper(x, y, width, height);
        boundingBox.setCZT(this.getC(), this.getZ(), this.getT());
        boundingBox.setText(this.getText() + " (Bounding Box)");
        boundingBox.setStroke(this.getStroke());
        boundingBox.setFill(this.getFill());
        boundingBox.setFontSize(this.getFontSize());
        return boundingBox;
    }

    public Roi toImageJ() {
        Roi roi = new ShapeRoi(this.createTransformedAWTShape()).trySimplify();
        this.copyToIJRoi(roi);
        return roi;
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    public <A extends AnnotationData> void link(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        ShapeAnnotationLinkI link = new ShapeAnnotationLinkI();
        link.setChild(annotation.asAnnotation());
        link.setParent((omero.model.Shape)((ShapeData)this.data).asIObject());
        client.save((IObject)link);
    }
}

