/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.roi;

import fr.igred.omero.roi.GenericShapeWrapper;
import fr.igred.omero.roi.PointWrapper;
import ij.gui.EllipseRoi;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import omero.gateway.model.EllipseData;

public class EllipseWrapper
extends GenericShapeWrapper<EllipseData> {
    public EllipseWrapper(EllipseData ellipse) {
        super(ellipse);
    }

    public EllipseWrapper() {
        this(new EllipseData());
    }

    public EllipseWrapper(Roi ijRoi) {
        this(ijRoi.getBounds().getX() + ijRoi.getBounds().getWidth() / 2.0, ijRoi.getBounds().getY() + ijRoi.getBounds().getHeight() / 2.0, ijRoi.getBounds().getWidth() / 2.0, ijRoi.getBounds().getHeight() / 2.0);
        ((EllipseData)this.data).setText(ijRoi.getName());
        super.copyFromIJRoi(ijRoi);
    }

    public EllipseWrapper(double x, double y, double radiusX, double radiusY) {
        this(new EllipseData(x, y, radiusX, radiusY));
    }

    @Override
    public String getText() {
        return ((EllipseData)this.data).getText();
    }

    @Override
    public void setText(String text) {
        ((EllipseData)this.data).setText(text);
    }

    @Override
    public Shape toAWTShape() {
        return new Ellipse2D.Double(this.getX() - this.getRadiusX(), this.getY() - this.getRadiusY(), 2.0 * this.getRadiusX(), 2.0 * this.getRadiusY());
    }

    public double getX() {
        return ((EllipseData)this.data).getX();
    }

    public void setX(double x) {
        ((EllipseData)this.data).setX(x);
    }

    public double getY() {
        return ((EllipseData)this.data).getY();
    }

    public void setY(double y) {
        ((EllipseData)this.data).setY(y);
    }

    public double getRadiusX() {
        return ((EllipseData)this.data).getRadiusX();
    }

    public void setRadiusX(double x) {
        ((EllipseData)this.data).setRadiusX(x);
    }

    public double getRadiusY() {
        return ((EllipseData)this.data).getRadiusY();
    }

    public void setRadiusY(double y) {
        ((EllipseData)this.data).setRadiusY(y);
    }

    public void setCoordinates(double x, double y, double radiusX, double radiusY) {
        this.setX(x);
        this.setY(y);
        this.setRadiusX(radiusX);
        this.setRadiusY(radiusY);
    }

    public double[] getCoordinates() {
        double[] coordinates = new double[]{this.getX(), this.getY(), this.getRadiusX(), this.getRadiusY()};
        return coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            String error = "EllipseData cannot set null coordinates.";
            throw new IllegalArgumentException(error);
        }
        if (coordinates.length != 4) {
            String error = "4 coordinates required for EllipseData.";
            throw new IllegalArgumentException(error);
        }
        ((EllipseData)this.data).setX(coordinates[0]);
        ((EllipseData)this.data).setY(coordinates[1]);
        ((EllipseData)this.data).setRadiusX(coordinates[2]);
        ((EllipseData)this.data).setRadiusY(coordinates[3]);
    }

    @Override
    public Roi toImageJ() {
        OvalRoi roi;
        Shape awtShape = this.createTransformedAWTShape();
        if (awtShape instanceof RectangularShape) {
            double x = ((RectangularShape)awtShape).getX();
            double y = ((RectangularShape)awtShape).getY();
            double w = ((RectangularShape)awtShape).getWidth();
            double h = ((RectangularShape)awtShape).getHeight();
            roi = new OvalRoi(x, y, w, h);
        } else {
            double ratio;
            PointWrapper p2;
            PointWrapper p1;
            double x = this.getX();
            double y = this.getY();
            double rx = this.getRadiusX();
            double ry = this.getRadiusY();
            if (ry <= rx) {
                p1 = new PointWrapper(x - rx, y);
                p2 = new PointWrapper(x + rx, y);
                ratio = ry / rx;
            } else {
                p1 = new PointWrapper(x, y - ry);
                p2 = new PointWrapper(x, y + ry);
                ratio = rx / ry;
            }
            p1.setTransform(this.toAWTTransform());
            p2.setTransform(this.toAWTTransform());
            Rectangle2D shape1 = p1.createTransformedAWTShape().getBounds2D();
            Rectangle2D shape2 = p2.createTransformedAWTShape().getBounds2D();
            double x1 = shape1.getX();
            double y1 = shape1.getY();
            double x2 = shape2.getX();
            double y2 = shape2.getY();
            roi = new EllipseRoi(x1, y1, x2, y2, ratio);
        }
        this.copyToIJRoi((Roi)roi);
        return roi;
    }
}

