/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateAcquisitionWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellSampleWrapper;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellData;

public class WellWrapper
extends GenericRepositoryObjectWrapper<WellData> {
    public static final String ANNOTATION_LINK = "WellAnnotationLink";

    public WellWrapper(WellData well) {
        super(well);
    }

    private static String identifier(int number) {
        int alphabetSize = 26;
        int charOffset = 64;
        StringBuilder letters = new StringBuilder(3);
        while (number > 0) {
            int temp = number % 26;
            letters.append((char)(temp + 64));
            number = (number - temp) / 26;
        }
        return letters.toString();
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    public String getName() {
        return String.format("Well %s-%d", WellWrapper.identifier(this.getRow() + 1), this.getColumn() + 1);
    }

    @Override
    public String getDescription() {
        return ((WellData)this.data).getExternalDescription();
    }

    @Deprecated
    public WellData asWellData() {
        return (WellData)this.data;
    }

    public List<WellSampleWrapper> getWellSamples() {
        return WellWrapper.wrap(((WellData)this.data).getWellSamples(), WellSampleWrapper::new, w -> ((ImageData)w.getImage().asDataObject()).getSeries());
    }

    public List<ScreenWrapper> getScreens(Client client) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        this.reload(client);
        return this.getPlate().getScreens(client);
    }

    public PlateWrapper getPlate() {
        return new PlateWrapper(((WellData)this.data).getPlate());
    }

    public List<PlateAcquisitionWrapper> getPlateAcquisitions(Client client) throws ServiceException, AccessException, ExecutionException {
        this.reload(client);
        return client.getPlate(this.getPlate().getId()).getPlateAcquisitions();
    }

    public List<ImageWrapper> getImages() {
        return this.getWellSamples().stream().map(WellSampleWrapper::getImage).collect(Collectors.toList());
    }

    public Integer getColumn() {
        return ((WellData)this.data).getColumn();
    }

    public Integer getRow() {
        return ((WellData)this.data).getRow();
    }

    public String getStatus() {
        return ((WellData)this.data).getStatus();
    }

    public void setStatus(String status) {
        ((WellData)this.data).setStatus(status);
    }

    public String getWellType() {
        return ((WellData)this.data).getWellType();
    }

    public void setWellType(String type) {
        ((WellData)this.data).setWellType(type);
    }

    public int getRed() {
        return ((WellData)this.data).getRed();
    }

    public void setRed(Integer red) {
        ((WellData)this.data).setRed(red);
    }

    public int getGreen() {
        return ((WellData)this.data).getGreen();
    }

    public void setGreen(Integer green) {
        ((WellData)this.data).setGreen(green);
    }

    public int getBlue() {
        return ((WellData)this.data).getBlue();
    }

    public void setBlue(Integer blue) {
        ((WellData)this.data).setBlue(blue);
    }

    public int getAlpha() {
        return ((WellData)this.data).getAlpha();
    }

    public void setAlpha(Integer alpha) {
        ((WellData)this.data).setAlpha(alpha);
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), bf -> (WellData)bf.getWells(browser.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot reload " + this);
    }
}

