/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateAcquisitionWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellWrapper;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import ome.model.units.BigResult;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.WellSampleData;
import omero.model.IObject;
import omero.model.Length;
import omero.model.WellSample;
import omero.model.enums.UnitsLength;

public class WellSampleWrapper
extends GenericObjectWrapper<WellSampleData> {
    public WellSampleWrapper(WellSampleData wellSample) {
        super(wellSample);
    }

    @Deprecated
    public WellSampleData asWellSampleData() {
        return (WellSampleData)this.data;
    }

    public List<ScreenWrapper> getScreens(Client client) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        return this.getWell(client).getScreens(client);
    }

    public List<PlateWrapper> getPlates(Client client) throws ServiceException, AccessException, ExecutionException {
        return Collections.singletonList(this.getWell(client).getPlate());
    }

    public PlateAcquisitionWrapper getPlateAcquisition() {
        return new PlateAcquisitionWrapper(new PlateAcquisitionData(((WellSampleData)this.data).asWellSample().getPlateAcquisition()));
    }

    public List<PlateAcquisitionWrapper> getPlateAcquisitions(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getWell(client).getPlateAcquisitions(client);
    }

    public WellWrapper getWell(Client client) throws AccessException, ServiceException, ExecutionException {
        return client.getWell(((WellSampleData)this.asDataObject()).asWellSample().getWell().getId().getValue());
    }

    public ImageWrapper getImage() {
        return new ImageWrapper(((WellSampleData)this.data).getImage());
    }

    public void setImage(ImageWrapper image) {
        ((WellSampleData)this.data).setImage((ImageData)image.asDataObject());
    }

    public Length getPositionX(UnitsLength unit) throws BigResult {
        return ((WellSampleData)this.data).getPositionX(unit);
    }

    public Length getPositionY(UnitsLength unit) throws BigResult {
        return ((WellSampleData)this.data).getPositionY(unit);
    }

    public long getStartTime() {
        return ((WellSampleData)this.data).getStartTime();
    }

    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        String query = "select ws from WellSample as ws left outer join fetch ws.plateAcquisition as pa left outer join fetch ws.well as w left outer join fetch ws.image as img left outer join fetch img.pixels as pix where ws.id=" + this.getId();
        IObject o = ExceptionHandler.call(browser.getGateway(), g -> (IObject)g.getQueryService(browser.getCtx()).findAllByQuery(query, null).iterator().next(), "Query failed: " + query);
        this.data = new WellSampleData((WellSample)o);
    }
}

