/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GatewayWrapper;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateAcquisitionWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.WellWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.gateway.model.DataObject;
import omero.gateway.model.ScreenData;

public class ScreenWrapper
extends GenericRepositoryObjectWrapper<ScreenData> {
    public static final String ANNOTATION_LINK = "ScreenAnnotationLink";

    public ScreenWrapper(Client client, String name, String description) throws ServiceException, AccessException, ExecutionException {
        super(new ScreenData());
        ((ScreenData)this.data).setName(name);
        ((ScreenData)this.data).setDescription(description);
        super.saveAndUpdate(client);
    }

    public ScreenWrapper(ScreenData screen) {
        super(screen);
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    public String getName() {
        return ((ScreenData)this.data).getName();
    }

    public void setName(String name) {
        ((ScreenData)this.data).setName(name);
    }

    @Deprecated
    public ScreenData asScreenData() {
        return (ScreenData)this.data;
    }

    @Override
    public String getDescription() {
        return ((ScreenData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((ScreenData)this.data).setDescription(description);
    }

    public List<PlateWrapper> getPlates() {
        return ScreenWrapper.wrap(((ScreenData)this.data).getPlates(), PlateWrapper::new);
    }

    public List<PlateWrapper> getPlates(String name) {
        List<PlateWrapper> plates = this.getPlates();
        plates.removeIf(plate -> !plate.getName().equals(name));
        return plates;
    }

    public List<PlateAcquisitionWrapper> getPlateAcquisitions(Client client) throws ServiceException, AccessException, ExecutionException {
        this.reload(client);
        return this.getPlates().stream().map(PlateWrapper::getPlateAcquisitions).flatMap(Collection::stream).collect(Collectors.toMap(GenericObjectWrapper::getId, p -> p, (p1, p2) -> p1)).values().stream().sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public List<WellWrapper> getWells(Client client) throws ServiceException, AccessException, ExecutionException {
        List<PlateWrapper> plates = this.getPlates();
        ArrayList<List<WellWrapper>> wells = new ArrayList<List<WellWrapper>>(plates.size());
        for (PlateWrapper p : plates) {
            wells.add(p.getWells(client));
        }
        return ScreenWrapper.flatten(wells);
    }

    public List<ImageWrapper> getImages(Client client) throws ServiceException, AccessException, ExecutionException {
        List<PlateWrapper> plates = this.getPlates();
        ArrayList<List<ImageWrapper>> images = new ArrayList<List<ImageWrapper>>(plates.size());
        for (PlateWrapper p : plates) {
            images.add(p.getImages(client));
        }
        return ScreenWrapper.flatten(images);
    }

    public String getProtocolDescription() {
        return ((ScreenData)this.data).getProtocolDescription();
    }

    public void setProtocolDescription(String value) {
        ((ScreenData)this.data).setProtocolDescription(value);
    }

    public String getProtocolIdentifier() {
        return ((ScreenData)this.data).getProtocolIdentifier();
    }

    public void setProtocolIdentifier(String value) {
        ((ScreenData)this.data).setProtocolIdentifier(value);
    }

    public String getReagentSetDescription() {
        return ((ScreenData)this.data).getReagentSetDescripion();
    }

    public void setReagentSetDescription(String value) {
        ((ScreenData)this.data).setReagentSetDescripion(value);
    }

    public String getReagentSetIdentifier() {
        return ((ScreenData)this.data).getReagentSetIdentifier();
    }

    public void setReagentSetIdentifier(String value) {
        ((ScreenData)this.data).setReagentSetIdentifier(value);
    }

    @Deprecated
    public void refresh(GatewayWrapper client) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(client.getBrowseFacility(), bf -> (ScreenData)bf.getScreens(client.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot refresh " + this);
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), bf -> (ScreenData)bf.getScreens(browser.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot reload " + this);
    }

    public boolean importImages(GatewayWrapper client, String ... paths) throws ServiceException, OMEROServerError, AccessException, IOException, ExecutionException {
        return this.importImages(client, 1, paths);
    }

    public boolean importImages(GatewayWrapper client, int threads, String ... paths) throws ServiceException, OMEROServerError, AccessException, IOException, ExecutionException {
        return ScreenWrapper.importImages(client, this.data, threads, paths);
    }

    public List<Long> importImage(GatewayWrapper client, String path) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        return ScreenWrapper.importImage(client, this.data, path);
    }
}

