/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.DatasetWrapper;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ProjectData;
import omero.model.IObject;
import omero.model.ProjectDatasetLinkI;

public class ProjectWrapper
extends GenericRepositoryObjectWrapper<ProjectData> {
    public static final String ANNOTATION_LINK = "ProjectAnnotationLink";

    public ProjectWrapper(ProjectData project) {
        super(project);
    }

    public ProjectWrapper(Client client, String name, String description) throws ServiceException, AccessException, ExecutionException {
        super(new ProjectData());
        ((ProjectData)this.data).setName(name);
        ((ProjectData)this.data).setDescription(description);
        super.saveAndUpdate(client);
    }

    @Override
    public String getName() {
        return ((ProjectData)this.data).getName();
    }

    public void setName(String name) {
        ((ProjectData)this.data).setName(name);
    }

    @Deprecated
    public ProjectData asProjectData() {
        return (ProjectData)this.data;
    }

    @Override
    public String getDescription() {
        return ((ProjectData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((ProjectData)this.data).setDescription(description);
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    public List<DatasetWrapper> getDatasets() {
        return ProjectWrapper.wrap(((ProjectData)this.data).getDatasets(), DatasetWrapper::new);
    }

    public List<DatasetWrapper> getDatasets(String name) {
        List<DatasetWrapper> datasets = this.getDatasets();
        datasets.removeIf(dataset -> !dataset.getName().equals(name));
        return datasets;
    }

    public DatasetWrapper addDataset(Client client, String name, String description) throws ServiceException, AccessException, ExecutionException {
        DatasetWrapper dataset = new DatasetWrapper(name, description);
        dataset.saveAndUpdate(client);
        return this.addDataset(client, dataset);
    }

    public DatasetWrapper addDataset(Client client, DatasetWrapper dataset) throws ServiceException, AccessException, ExecutionException {
        dataset.saveAndUpdate(client);
        ProjectDatasetLinkI link = new ProjectDatasetLinkI();
        link.setChild(((DatasetData)dataset.asDataObject()).asDataset());
        link.setParent(((ProjectData)this.data).asProject());
        client.save((IObject)link);
        return dataset;
    }

    public void removeDataset(Client client, DatasetWrapper dataset) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.removeLink(client, "ProjectDatasetLink", dataset.getId());
        this.reload(client);
    }

    public List<ImageWrapper> getImages(Client client) throws ServiceException, AccessException, ExecutionException {
        List<Long> projectIds = Collections.singletonList(this.getId());
        Collection images = ExceptionHandler.call(client.getBrowseFacility(), bf -> bf.getImagesForProjects(client.getCtx(), (Collection)projectIds), "Cannot get images from " + this);
        return ProjectWrapper.distinct(ProjectWrapper.wrap(images, ImageWrapper::new));
    }

    public List<ImageWrapper> getImages(Client client, String name) throws ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets();
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImages(client, name));
        }
        return ProjectWrapper.flatten(lists);
    }

    public List<ImageWrapper> getImages(Client client, String datasetName, String imageName) throws ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets(datasetName);
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImages(client, imageName));
        }
        List images = lists.stream().flatMap(Collection::stream).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
        return ProjectWrapper.distinct(images);
    }

    public List<ImageWrapper> getImagesLike(Client client, String motif) throws ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets();
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImagesLike(client, motif));
        }
        return ProjectWrapper.flatten(lists);
    }

    public List<ImageWrapper> getImagesTagged(Client client, TagAnnotationWrapper tag) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets();
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImagesTagged(client, tag));
        }
        return ProjectWrapper.flatten(lists);
    }

    public List<ImageWrapper> getImagesTagged(Client client, Long tagId) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets();
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImagesTagged(client, tagId));
        }
        return ProjectWrapper.flatten(lists);
    }

    @Deprecated
    public List<ImageWrapper> getImagesKey(Client client, String key) throws ServiceException, AccessException, ExecutionException {
        return this.getImagesWithKey(client, key);
    }

    public List<ImageWrapper> getImagesWithKey(Client client, String key) throws ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets();
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImagesWithKey(client, key));
        }
        return ProjectWrapper.flatten(lists);
    }

    @Deprecated
    public List<ImageWrapper> getImagesPairKeyValue(Client client, String key, String value) throws ServiceException, AccessException, ExecutionException {
        return this.getImagesWithKeyValuePair(client, key, value);
    }

    public List<ImageWrapper> getImagesWithKeyValuePair(Client client, String key, String value) throws ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets();
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            lists.add(dataset.getImagesWithKeyValuePair(client, key, value));
        }
        return ProjectWrapper.flatten(lists);
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), bf -> (ProjectData)bf.getProjects(browser.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot reload " + this);
    }
}

