/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateAcquisitionWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import ome.model.units.BigResult;
import omero.RLong;
import omero.gateway.model.DataObject;
import omero.gateway.model.PlateData;
import omero.model.IObject;
import omero.model.Length;
import omero.model.enums.UnitsLength;

public class PlateWrapper
extends GenericRepositoryObjectWrapper<PlateData> {
    public static final String ANNOTATION_LINK = "PlateAnnotationLink";

    public PlateWrapper(PlateData plate) {
        super(plate);
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    public String getName() {
        return ((PlateData)this.data).getName();
    }

    public void setName(String name) {
        ((PlateData)this.data).setName(name);
    }

    @Deprecated
    public PlateData asPlateData() {
        return (PlateData)this.data;
    }

    @Override
    public String getDescription() {
        return ((PlateData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((PlateData)this.data).setDescription(description);
    }

    public List<ScreenWrapper> getScreens(Client client) throws OMEROServerError, ServiceException, AccessException, ExecutionException {
        String query = "select link.parent from ScreenPlateLink as link where link.child=" + this.getId();
        List<IObject> os = client.findByQuery(query);
        return client.getScreens((Long[])os.stream().map(IObject::getId).map(RLong::getValue).distinct().toArray(Long[]::new));
    }

    public List<PlateAcquisitionWrapper> getPlateAcquisitions() {
        return PlateWrapper.wrap(((PlateData)this.data).getPlateAcquisitions(), PlateAcquisitionWrapper::new);
    }

    public List<WellWrapper> getWells(Client client) throws ServiceException, AccessException, ExecutionException {
        Collection wells = ExceptionHandler.call(client.getBrowseFacility(), bf -> bf.getWells(client.getCtx(), ((PlateData)this.data).getId()), "Cannot get wells from " + this);
        return wells.stream().map(WellWrapper::new).sorted(Comparator.comparing(WellWrapper::getRow).thenComparing(WellWrapper::getColumn)).collect(Collectors.toList());
    }

    public List<ImageWrapper> getImages(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getWells(client).stream().map(WellWrapper::getImages).flatMap(Collection::stream).collect(Collectors.toMap(GenericObjectWrapper::getId, i -> i, (i1, i2) -> i1)).values().stream().sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public int getColumnSequenceIndex() {
        return ((PlateData)this.data).getColumnSequenceIndex();
    }

    public int getRowSequenceIndex() {
        return ((PlateData)this.data).getRowSequenceIndex();
    }

    public int getDefaultSample() {
        return ((PlateData)this.data).getDefaultSample();
    }

    public void setDefaultSample(int value) {
        ((PlateData)this.data).setDefaultSample(value);
    }

    public String getStatus() {
        return ((PlateData)this.data).getStatus();
    }

    public void setStatus(String value) {
        ((PlateData)this.data).setStatus(value);
    }

    public String getExternalIdentifier() {
        return ((PlateData)this.data).getExternalIdentifier();
    }

    public void setExternalIdentifier(String value) {
        ((PlateData)this.data).setExternalIdentifier(value);
    }

    public String getPlateType() {
        return ((PlateData)this.data).getPlateType();
    }

    public Length getWellOriginX(UnitsLength unit) throws BigResult {
        return ((PlateData)this.data).getWellOriginX(unit);
    }

    public Length getWellOriginY(UnitsLength unit) throws BigResult {
        return ((PlateData)this.data).getWellOriginY(unit);
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), bf -> (PlateData)bf.getPlates(browser.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot reload " + this);
    }
}

