/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellSampleWrapper;
import fr.igred.omero.repository.WellWrapper;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.WellSampleData;
import omero.model.IObject;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionAnnotationLinkI;
import omero.model._PlateAcquisitionOperationsNC;

public class PlateAcquisitionWrapper
extends GenericRepositoryObjectWrapper<PlateAcquisitionData> {
    public static final String ANNOTATION_LINK = "PlateAcquisitionAnnotationLink";

    public PlateAcquisitionWrapper(PlateAcquisitionData plateAcquisition) {
        super(plateAcquisition);
        Plate plate = ((_PlateAcquisitionOperationsNC)((PlateAcquisitionData)this.data).asIObject()).getPlate();
        if (plate != null) {
            ((PlateAcquisitionData)this.data).setRefPlateId(plate.getId().getValue());
        }
    }

    private void initRefPlate() {
        Plate plate = ((_PlateAcquisitionOperationsNC)((PlateAcquisitionData)this.data).asIObject()).getPlate();
        if (plate != null) {
            ((PlateAcquisitionData)this.data).setRefPlateId(plate.getId().getValue());
        }
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    public String getName() {
        return ((PlateAcquisitionData)this.data).getName();
    }

    public void setName(String name) {
        ((PlateAcquisitionData)this.data).setName(name);
    }

    @Deprecated
    public PlateAcquisitionData asPlateAcquisitionData() {
        return (PlateAcquisitionData)this.data;
    }

    @Override
    public String getDescription() {
        return ((PlateAcquisitionData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((PlateAcquisitionData)this.data).setDescription(description);
    }

    @Override
    protected <A extends AnnotationData> void link(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        PlateAcquisitionAnnotationLinkI link = new PlateAcquisitionAnnotationLinkI();
        link.setChild(annotation.asAnnotation());
        link.setParent((PlateAcquisition)((PlateAcquisitionData)this.data).asIObject());
        client.save((IObject)link);
    }

    public List<ScreenWrapper> getScreens(Client client) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        PlateWrapper plate = client.getPlate(this.getRefPlateId());
        return plate.getScreens(client);
    }

    public List<PlateWrapper> getPlates(Client client) throws ServiceException, AccessException, ExecutionException {
        return client.getPlates(this.getRefPlateId());
    }

    public List<WellWrapper> getWells(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getPlates(client).iterator().next().getWells(client);
    }

    public List<WellSampleWrapper> getWellSamples() {
        _PlateAcquisitionOperationsNC pa = (_PlateAcquisitionOperationsNC)((PlateAcquisitionData)this.data).asIObject();
        return pa.copyWellSample().stream().map(WellSampleData::new).map(WellSampleWrapper::new).collect(Collectors.toList());
    }

    public List<WellSampleWrapper> getWellSamples(Browser browser) throws AccessException, ServiceException, ExecutionException {
        this.reload(browser);
        return this.getWellSamples();
    }

    public List<ImageWrapper> getImages() {
        return this.getWellSamples().stream().map(WellSampleWrapper::getImage).collect(Collectors.toList());
    }

    public List<ImageWrapper> getImages(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getWellSamples(client).stream().map(WellSampleWrapper::getImage).collect(Collectors.toList());
    }

    public String getLabel() {
        return ((PlateAcquisitionData)this.data).getLabel();
    }

    public long getRefPlateId() {
        return ((PlateAcquisitionData)this.data).getRefPlateId();
    }

    public void setRefPlateId(long refPlateId) {
        ((PlateAcquisitionData)this.data).setRefPlateId(refPlateId);
    }

    public Timestamp getStartTime() {
        return ((PlateAcquisitionData)this.data).getStartTime();
    }

    public Timestamp getEndTime() {
        return ((PlateAcquisitionData)this.data).getEndTime();
    }

    public int getMaximumFieldCount() {
        return ((PlateAcquisitionData)this.data).getMaximumFieldCount();
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        String query = "select pa from PlateAcquisition as pa  left outer join fetch pa.plate as p left outer join fetch pa.wellSample as ws left outer join fetch ws.plateAcquisition as pa2 left outer join fetch ws.well as w left outer join fetch ws.image as img left outer join fetch img.pixels as pix left outer join fetch pix.pixelsType as pt where pa.id=" + this.getId();
        IObject o = ExceptionHandler.call(browser.getGateway(), g -> (IObject)g.getQueryService(browser.getCtx()).findAllByQuery(query, null).iterator().next(), "Query failed: " + query);
        this.data = new PlateAcquisitionData((PlateAcquisition)o);
        this.initRefPlate();
    }
}

