/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.meta.PlaneInfoWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import ome.formats.model.UnitsFactory;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import omero.gateway.exception.DataSourceException;
import omero.gateway.facility.RawDataFacility;
import omero.gateway.model.PixelsData;
import omero.gateway.rnd.Plane2D;
import omero.model.LengthI;
import omero.model.Time;

public class PixelsWrapper
extends GenericObjectWrapper<PixelsData> {
    public static final int MAX_DIST = 5000;
    private List<PlaneInfoWrapper> planesInfo = new ArrayList<PlaneInfoWrapper>(0);
    private RawDataFacility rawDataFacility = null;

    public PixelsWrapper(PixelsData pixels) {
        super(pixels);
    }

    private static void copy(double[][] tab, Plane2D p, Coordinates start, int width, int height) {
        int startX = start.getX();
        int startY = start.getY();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                tab[startY + y][startX + x] = p.getPixelValue(x, y);
            }
        }
    }

    private static void copy(byte[] bytes, Plane2D p, Coordinates start, int width, int height, int imgWidth, int bpp) {
        int x0 = start.getX();
        int y0 = start.getY();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int i = 0; i < bpp; ++i) {
                    bytes[((y + y0) * imgWidth + x + x0) * bpp + i] = p.getRawValue((x + y * width) * bpp + i);
                }
            }
        }
    }

    private static int[] checkBounds(int[] bounds, int imageSize) {
        int[] b = new int[]{0, imageSize - 1};
        if (bounds != null && bounds.length > 1) {
            b[0] = bounds[0] >= b[0] && bounds[0] <= b[1] ? bounds[0] : b[0];
            b[1] = bounds[1] >= b[0] && bounds[1] <= b[1] ? bounds[1] : b[1];
        }
        return b;
    }

    public void loadPlanesInfo(Client client) throws ServiceException, AccessException, ExecutionException {
        List planes = ExceptionHandler.call(client.getMetadata(), m -> m.getPlaneInfos(client.getCtx(), (PixelsData)this.data), "Cannot retrieve planes info.");
        this.planesInfo = PixelsWrapper.wrap(planes, PlaneInfoWrapper::new);
    }

    public List<PlaneInfoWrapper> getPlanesInfo() {
        return Collections.unmodifiableList(this.planesInfo);
    }

    public String getPixelType() {
        return ((PixelsData)this.data).getPixelType();
    }

    public omero.model.Length getPixelSizeX() {
        return ((PixelsData)this.data).asPixels().getPhysicalSizeX();
    }

    public omero.model.Length getPixelSizeY() {
        return ((PixelsData)this.data).asPixels().getPhysicalSizeY();
    }

    public omero.model.Length getPixelSizeZ() {
        return ((PixelsData)this.data).asPixels().getPhysicalSizeZ();
    }

    public Time getTimeIncrement() {
        return ((PixelsData)this.data).asPixels().getTimeIncrement();
    }

    public Time getMeanTimeInterval() {
        return PlaneInfoWrapper.computeMeanTimeInterval(this.planesInfo, this.getSizeT());
    }

    public Time getMeanExposureTime(int channel) {
        return PlaneInfoWrapper.computeMeanExposureTime(this.planesInfo, channel);
    }

    public omero.model.Length getPositionX() {
        Unit unit;
        omero.model.Length x = PlaneInfoWrapper.getMinPosition(this.planesInfo, PlaneInfoWrapper::getPositionX);
        Length pixSizeX = UnitsFactory.convertLength((omero.model.Length)this.getPixelSizeX());
        Length posX = UnitsFactory.convertLength((omero.model.Length)x);
        if (pixSizeX != null && posX.value(unit = pixSizeX.unit()) != null) {
            x = new LengthI(posX.value(unit).doubleValue(), unit);
        }
        return x;
    }

    public omero.model.Length getPositionY() {
        Unit unit;
        omero.model.Length y = PlaneInfoWrapper.getMinPosition(this.planesInfo, PlaneInfoWrapper::getPositionY);
        Length pixSizeY = UnitsFactory.convertLength((omero.model.Length)this.getPixelSizeY());
        Length posY = UnitsFactory.convertLength((omero.model.Length)y);
        if (pixSizeY != null && posY.value(unit = pixSizeY.unit()) != null) {
            y = new LengthI(posY.value(unit).doubleValue(), unit);
        }
        return y;
    }

    public omero.model.Length getPositionZ() {
        Unit unit;
        omero.model.Length z = PlaneInfoWrapper.getMinPosition(this.planesInfo, PlaneInfoWrapper::getPositionZ);
        Length pixSizeZ = UnitsFactory.convertLength((omero.model.Length)this.getPixelSizeZ());
        Length posZ = UnitsFactory.convertLength((omero.model.Length)z);
        if (pixSizeZ != null && posZ.value(unit = pixSizeZ.unit()) != null) {
            z = new LengthI(posZ.value(unit).doubleValue(), unit);
        }
        return z;
    }

    public int getSizeX() {
        return ((PixelsData)this.data).getSizeX();
    }

    public int getSizeY() {
        return ((PixelsData)this.data).getSizeY();
    }

    public int getSizeZ() {
        return ((PixelsData)this.data).getSizeZ();
    }

    public int getSizeC() {
        return ((PixelsData)this.data).getSizeC();
    }

    public int getSizeT() {
        return ((PixelsData)this.data).getSizeT();
    }

    boolean createRawDataFacility(Client client) throws ExecutionException {
        boolean created = false;
        if (this.rawDataFacility == null) {
            this.rawDataFacility = (RawDataFacility)client.getGateway().getFacility(RawDataFacility.class);
            created = true;
        }
        return created;
    }

    void destroyRawDataFacility() {
        this.rawDataFacility.close();
        this.rawDataFacility = null;
    }

    public double[][][][][] getAllPixels(Client client) throws AccessException, ExecutionException {
        return this.getAllPixels(client, null, null, null, null, null);
    }

    public double[][][][][] getAllPixels(Client client, int[] xBounds, int[] yBounds, int[] cBounds, int[] zBounds, int[] tBounds) throws AccessException, ExecutionException {
        boolean rdf = this.createRawDataFacility(client);
        Bounds lim = this.getBounds(xBounds, yBounds, cBounds, zBounds, tBounds);
        Coordinates start = lim.getStart();
        Coordinates size = lim.getSize();
        int x0 = start.getX();
        int y0 = start.getY();
        int sx = size.getX();
        int sy = size.getY();
        int startC = start.getC();
        int startZ = start.getZ();
        int startT = start.getT();
        int sizeC = size.getC();
        int sizeZ = size.getZ();
        int sizeT = size.getT();
        double[][][][][] tab = new double[sizeT][sizeZ][sizeC][][];
        int t = 0;
        int posT = startT;
        while (t < sizeT) {
            int z = 0;
            int posZ = startZ;
            while (z < sizeZ) {
                int c = 0;
                int posC = startC;
                while (c < sizeC) {
                    Coordinates pos = new Coordinates(x0, y0, posC, posZ, posT);
                    tab[t][z][c] = this.getTile(client, pos, sx, sy);
                    ++c;
                    ++posC;
                }
                ++z;
                ++posZ;
            }
            ++t;
            ++posT;
        }
        if (rdf) {
            this.destroyRawDataFacility();
        }
        return tab;
    }

    double[][] getTile(Client client, Coordinates start, int width, int height) throws AccessException, ExecutionException {
        boolean rdf = this.createRawDataFacility(client);
        double[][] tile = ExceptionHandler.of(this, t -> t.getTileUnchecked(client, start, width, height)).rethrow(DataSourceException.class, AccessException::new, "Cannot read tile").get();
        if (rdf) {
            this.destroyRawDataFacility();
        }
        return tile;
    }

    private double[][] getTileUnchecked(Client client, Coordinates start, int width, int height) throws DataSourceException {
        double[][] tile = new double[height][width];
        int c = start.getC();
        int z = start.getZ();
        int t = start.getT();
        int relX = 0;
        int x = start.getX();
        while (relX < width) {
            int sizeX = Math.min(5000, width - relX);
            int relY = 0;
            int y = start.getY();
            while (relY < height) {
                int sizeY = Math.min(5000, height - relY);
                Plane2D p = this.rawDataFacility.getTile(client.getCtx(), (PixelsData)this.data, z, t, c, x, y, sizeX, sizeY);
                Coordinates pos = new Coordinates(relX, relY, c, z, t);
                PixelsWrapper.copy(tile, p, pos, sizeX, sizeY);
                relY += 5000;
                y += 5000;
            }
            relX += 5000;
            x += 5000;
        }
        return tile;
    }

    public byte[][][][] getRawPixels(Client client, int bpp) throws AccessException, ExecutionException {
        return this.getRawPixels(client, null, null, null, null, null, bpp);
    }

    public byte[][][][] getRawPixels(Client client, int[] xBounds, int[] yBounds, int[] cBounds, int[] zBounds, int[] tBounds, int bpp) throws ExecutionException, AccessException {
        boolean rdf = this.createRawDataFacility(client);
        Bounds lim = this.getBounds(xBounds, yBounds, cBounds, zBounds, tBounds);
        Coordinates start = lim.getStart();
        Coordinates size = lim.getSize();
        int x0 = start.getX();
        int y0 = start.getY();
        int startC = start.getC();
        int startZ = start.getZ();
        int startT = start.getT();
        int sx = size.getX();
        int sy = size.getY();
        int sizeC = size.getC();
        int sizeZ = size.getZ();
        int sizeT = size.getT();
        byte[][][][] bytes = new byte[sizeT][sizeZ][sizeC][];
        int t = 0;
        int posT = startT;
        while (t < sizeT) {
            int z = 0;
            int posZ = startZ;
            while (z < sizeZ) {
                int c = 0;
                int posC = startC;
                while (c < sizeC) {
                    Coordinates pos = new Coordinates(x0, y0, posC, posZ, posT);
                    bytes[t][z][c] = this.getRawTile(client, pos, sx, sy, bpp);
                    ++c;
                    ++posC;
                }
                ++z;
                ++posZ;
            }
            ++t;
            ++posT;
        }
        if (rdf) {
            this.destroyRawDataFacility();
        }
        return bytes;
    }

    byte[] getRawTile(Client client, Coordinates start, int width, int height, int bpp) throws AccessException, ExecutionException {
        boolean rdf = this.createRawDataFacility(client);
        byte[] tile = ExceptionHandler.of(this, t -> t.getRawTileUnchecked(client, start, width, height, bpp)).rethrow(DataSourceException.class, AccessException::new, "Cannot read raw tile").get();
        if (rdf) {
            this.destroyRawDataFacility();
        }
        return tile;
    }

    private byte[] getRawTileUnchecked(Client client, Coordinates start, int width, int height, int bpp) throws DataSourceException {
        byte[] tile = new byte[height * width * bpp];
        int c = start.getC();
        int z = start.getZ();
        int t = start.getT();
        int relX = 0;
        int x = start.getX();
        while (relX < width) {
            int sizeX = Math.min(5000, width - relX);
            int relY = 0;
            int y = start.getY();
            while (relY < height) {
                int sizeY = Math.min(5000, height - relY);
                Plane2D p = this.rawDataFacility.getTile(client.getCtx(), (PixelsData)this.data, z, t, c, x, y, sizeX, sizeY);
                Coordinates pos = new Coordinates(relX, relY, c, z, t);
                PixelsWrapper.copy(tile, p, pos, sizeX, sizeY, width, bpp);
                relY += 5000;
                y += 5000;
            }
            relX += 5000;
            x += 5000;
        }
        return tile;
    }

    Bounds getBounds(int[] xBounds, int[] yBounds, int[] cBounds, int[] zBounds, int[] tBounds) {
        int[][] limits = new int[5][2];
        limits[0] = PixelsWrapper.checkBounds(xBounds, ((PixelsData)this.data).getSizeX());
        limits[1] = PixelsWrapper.checkBounds(yBounds, ((PixelsData)this.data).getSizeY());
        limits[2] = PixelsWrapper.checkBounds(cBounds, ((PixelsData)this.data).getSizeC());
        limits[3] = PixelsWrapper.checkBounds(zBounds, ((PixelsData)this.data).getSizeZ());
        limits[4] = PixelsWrapper.checkBounds(tBounds, ((PixelsData)this.data).getSizeT());
        Coordinates start = new Coordinates(limits[0][0], limits[1][0], limits[2][0], limits[3][0], limits[4][0]);
        Coordinates end = new Coordinates(limits[0][1], limits[1][1], limits[2][1], limits[3][1], limits[4][1]);
        return new Bounds(start, end);
    }

    public static class Coordinates {
        private final int x;
        private final int y;
        private final int c;
        private final int z;
        private final int t;

        public Coordinates(int x, int y, int c, int z, int t) {
            this.x = x;
            this.y = y;
            this.c = c;
            this.z = z;
            this.t = t;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getC() {
            return this.c;
        }

        public int getZ() {
            return this.z;
        }

        public int getT() {
            return this.t;
        }
    }

    public static class Bounds {
        private final Coordinates start;
        private final Coordinates size;

        public Bounds(Coordinates start, Coordinates end) {
            this.start = start;
            this.size = new Coordinates(end.getX() - start.getX() + 1, end.getY() - start.getY() + 1, end.getC() - start.getC() + 1, end.getZ() - start.getZ() + 1, end.getT() - start.getT() + 1);
        }

        public Coordinates getStart() {
            return this.start;
        }

        public Coordinates getEnd() {
            return new Coordinates(this.start.getX() + this.size.getX() - 1, this.start.getY() + this.size.getY() - 1, this.start.getC() + this.size.getC() - 1, this.start.getZ() + this.size.getZ() - 1, this.start.getT() + this.size.getT() - 1);
        }

        public Coordinates getSize() {
            return this.size;
        }
    }
}

