/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.ChannelWrapper;
import fr.igred.omero.repository.DatasetWrapper;
import fr.igred.omero.repository.FolderWrapper;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.PixelsWrapper;
import fr.igred.omero.repository.PlateAcquisitionWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.ProjectWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellSampleWrapper;
import fr.igred.omero.repository.WellWrapper;
import fr.igred.omero.roi.ROIWrapper;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import loci.common.DataTools;
import loci.formats.FormatTools;
import omero.RLong;
import omero.ServerError;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.TransferFacility;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.WellSampleData;
import omero.model.Folder;
import omero.model.IObject;
import omero.model.Length;
import omero.model.Time;
import omero.rtypes;

public class ImageWrapper
extends GenericRepositoryObjectWrapper<ImageData> {
    public static final String ANNOTATION_LINK = "ImageAnnotationLink";
    public static final String IJ_ID_PROPERTY = "IMAGE_ID";

    public ImageWrapper(ImageData image) {
        super(image);
    }

    private static void setCalibration(PixelsWrapper pixels, Calibration calibration) {
        Length positionX = pixels.getPositionX();
        Length positionY = pixels.getPositionY();
        Length positionZ = pixels.getPositionZ();
        Length spacingX = pixels.getPixelSizeX();
        Length spacingY = pixels.getPixelSizeY();
        Length spacingZ = pixels.getPixelSizeZ();
        Time stepT = pixels.getTimeIncrement();
        if (stepT == null) {
            stepT = pixels.getMeanTimeInterval();
        }
        calibration.setXUnit(positionX.getSymbol());
        calibration.setYUnit(positionY.getSymbol());
        calibration.setZUnit(positionZ.getSymbol());
        calibration.xOrigin = -positionX.getValue();
        calibration.yOrigin = -positionY.getValue();
        calibration.zOrigin = -positionZ.getValue();
        if (spacingX != null) {
            calibration.setXUnit(spacingX.getSymbol());
            calibration.pixelWidth = spacingX.getValue();
            calibration.xOrigin /= calibration.pixelWidth;
        }
        if (spacingY != null) {
            calibration.setYUnit(spacingY.getSymbol());
            calibration.pixelHeight = spacingY.getValue();
            calibration.yOrigin /= calibration.pixelHeight;
        }
        if (spacingZ != null) {
            calibration.setZUnit(spacingZ.getSymbol());
            calibration.pixelDepth = spacingZ.getValue();
            calibration.zOrigin /= calibration.pixelDepth;
        }
        if (!Double.isNaN(stepT.getValue())) {
            calibration.setTimeUnit(stepT.getSymbol());
            calibration.frameInterval = stepT.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getThumbnailBytes(Client client, int size) throws DSOutOfServiceException, ServerError {
        byte[] array;
        PixelsWrapper pixels = this.getPixels();
        int sizeX = pixels.getSizeX();
        int sizeY = pixels.getSizeY();
        float ratioX = (float)sizeX / (float)size;
        float ratioY = (float)sizeY / (float)size;
        float ratio = Math.max(ratioX, ratioY);
        int width = (int)((float)sizeX / ratio);
        int height = (int)((float)sizeY / ratio);
        try (ThumbnailStorePrx store = null;){
            store = client.getGateway().getThumbnailService(client.getCtx());
            store.setPixelsId(pixels.getId());
            array = store.getThumbnail(rtypes.rint((int)width), rtypes.rint((int)height));
        }
        return array;
    }

    @Override
    public String getName() {
        return ((ImageData)this.data).getName();
    }

    public void setName(String name) {
        ((ImageData)this.data).setName(name);
    }

    @Deprecated
    public ImageData asImageData() {
        return (ImageData)this.data;
    }

    @Override
    public String getDescription() {
        return ((ImageData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((ImageData)this.data).setDescription(description);
    }

    public Timestamp getAcquisitionDate() {
        return ((ImageData)this.data).getAcquisitionDate();
    }

    public String getFormat() {
        return ((ImageData)this.data).getFormat();
    }

    public int getSeries() {
        return ((ImageData)this.data).getSeries();
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    public List<ProjectWrapper> getProjects(Client client) throws OMEROServerError, ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets(client);
        ArrayList<ProjectWrapper> projects = new ArrayList<ProjectWrapper>(datasets.size());
        for (DatasetWrapper dataset : datasets) {
            projects.addAll(dataset.getProjects(client));
        }
        return ImageWrapper.distinct(projects);
    }

    public List<DatasetWrapper> getDatasets(Client client) throws OMEROServerError, ServiceException, AccessException, ExecutionException {
        String query = "select link.parent from DatasetImageLink as link where link.child=" + this.getId();
        List<IObject> os = client.findByQuery(query);
        return client.getDatasets((Long[])os.stream().map(IObject::getId).map(RLong::getValue).distinct().toArray(Long[]::new));
    }

    public List<WellSampleWrapper> getWellSamples() {
        return ((ImageData)this.data).asImage().copyWellSamples().stream().map(WellSampleData::new).map(WellSampleWrapper::new).collect(Collectors.toList());
    }

    public List<WellSampleWrapper> getWellSamples(Client client) throws AccessException, ServiceException, ExecutionException {
        this.reload(client);
        List<WellSampleWrapper> samples = this.getWellSamples();
        for (WellSampleWrapper sample : samples) {
            sample.reload(client);
        }
        return samples;
    }

    public List<WellWrapper> getWells(Client client) throws AccessException, ServiceException, ExecutionException {
        List<WellSampleWrapper> wellSamples = this.getWellSamples(client);
        ArrayList<WellWrapper> wells = new ArrayList<WellWrapper>(wellSamples.size());
        for (WellSampleWrapper ws : wellSamples) {
            wells.add(ws.getWell(client));
        }
        return ImageWrapper.distinct(wells);
    }

    public List<PlateAcquisitionWrapper> getPlateAcquisitions(Client client) throws AccessException, ServiceException, ExecutionException {
        List<WellSampleWrapper> wellSamples = this.getWellSamples(client);
        ArrayList<PlateAcquisitionWrapper> acqs = new ArrayList<PlateAcquisitionWrapper>(wellSamples.size());
        for (WellSampleWrapper ws : wellSamples) {
            acqs.add(ws.getPlateAcquisition());
        }
        return ImageWrapper.distinct(acqs);
    }

    public List<PlateWrapper> getPlates(Client client) throws AccessException, ServiceException, ExecutionException {
        return ImageWrapper.distinct(this.getWells(client).stream().map(WellWrapper::getPlate).collect(Collectors.toList()));
    }

    public List<ScreenWrapper> getScreens(Client client) throws AccessException, ServiceException, ExecutionException, OMEROServerError {
        List<PlateWrapper> plates = this.getPlates(client);
        ArrayList<List<ScreenWrapper>> screens = new ArrayList<List<ScreenWrapper>>(plates.size());
        for (PlateWrapper plate : plates) {
            screens.add(plate.getScreens(client));
        }
        return ImageWrapper.flatten(screens);
    }

    public boolean isOrphaned(Client client) throws ServiceException, OMEROServerError {
        String dsQuery = "select link.parent from DatasetImageLink link where link.child=" + this.getId();
        String wsQuery = "select ws from WellSample ws where image=" + this.getId();
        boolean noDataset = client.findByQuery(dsQuery).isEmpty();
        boolean noWellSample = client.findByQuery(wsQuery).isEmpty();
        return noDataset && noWellSample;
    }

    public List<ImageWrapper> getFilesetImages(Client client) throws AccessException, ServiceException, ExecutionException, OMEROServerError {
        List<ImageWrapper> related = new ArrayList<ImageWrapper>(0);
        if (((ImageData)this.data).isFSImage()) {
            long fsId = ((ImageData)this.asDataObject()).getFilesetId();
            String query = "select i from Image i where fileset=" + fsId;
            List<IObject> objects = client.findByQuery(query);
            Long[] ids = (Long[])objects.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
            related = client.getImages(ids);
        }
        return related;
    }

    public List<ROIWrapper> saveROIs(Client client, Collection<? extends ROIWrapper> rois) throws ServiceException, AccessException, ExecutionException {
        rois.forEach(r -> r.setImage(this));
        List roisData = rois.stream().map(GenericObjectWrapper::asDataObject).collect(Collectors.toList());
        Collection results = ExceptionHandler.call(client.getRoiFacility(), rf -> rf.saveROIs(client.getCtx(), ((ImageData)this.data).getId(), (Collection)roisData), "Cannot link ROI to " + this);
        return ImageWrapper.wrap(results, ROIWrapper::new);
    }

    public List<ROIWrapper> saveROIs(Client client, ROIWrapper ... rois) throws ServiceException, AccessException, ExecutionException {
        return this.saveROIs(client, Arrays.asList(rois));
    }

    @Deprecated
    public void saveROI(Client client, ROIWrapper roi) throws ServiceException, AccessException, ExecutionException {
        roi.setData((ROIData)this.saveROIs(client, roi).iterator().next().asDataObject());
    }

    public List<ROIWrapper> getROIs(Client client) throws ServiceException, AccessException, ExecutionException {
        List roiResults = ExceptionHandler.call(client.getRoiFacility(), rf -> rf.loadROIs(client.getCtx(), ((ImageData)this.data).getId()), "Cannot get ROIs from " + this);
        List roiWrappers = roiResults.stream().map(ROIResult::getROIs).flatMap(Collection::stream).map(ROIWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
        return ImageWrapper.distinct(roiWrappers);
    }

    public List<FolderWrapper> getROIFolders(Client client) throws ServiceException, AccessException, ExecutionException {
        Collection folders = ExceptionHandler.call(client.getRoiFacility(), rf -> rf.getROIFolders(client.getCtx(), ((ImageData)this.data).getId()), "Cannot get folders for " + this);
        return ImageWrapper.wrap(folders, FolderWrapper::new);
    }

    public List<FolderWrapper> getFolders(Client client) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        String template = "select link.parent from FolderImageLink as link where link.child.id=%d";
        String query = String.format(template, this.getId());
        Long[] ids = (Long[])client.findByQuery(query).stream().map(o -> o.getId().getValue()).toArray(Long[]::new);
        return client.loadFolders(ids);
    }

    @Deprecated
    public FolderWrapper getFolder(Client client, Long folderId) throws ServiceException, OMEROServerError {
        List<IObject> os = client.findByQuery("select f from Folder as f where f.id = " + folderId);
        FolderWrapper folderWrapper = new FolderWrapper((Folder)os.iterator().next());
        folderWrapper.setImage(((ImageData)this.data).getId());
        return folderWrapper;
    }

    public PixelsWrapper getPixels() {
        return new PixelsWrapper(((ImageData)this.data).getDefaultPixels());
    }

    public ImagePlus toImagePlus(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.toImagePlus(client, null, null, null, null, null);
    }

    public ImagePlus toImagePlus(Client client, int[] xBounds, int[] yBounds, int[] cBounds, int[] zBounds, int[] tBounds) throws ServiceException, AccessException, ExecutionException {
        PixelsWrapper pixels = this.getPixels();
        pixels.loadPlanesInfo(client);
        boolean createdRDF = pixels.createRawDataFacility(client);
        PixelsWrapper.Bounds bounds = pixels.getBounds(xBounds, yBounds, cBounds, zBounds, tBounds);
        int startX = bounds.getStart().getX();
        int startY = bounds.getStart().getY();
        int startC = bounds.getStart().getC();
        int startZ = bounds.getStart().getZ();
        int startT = bounds.getStart().getT();
        int sizeX = bounds.getSize().getX();
        int sizeY = bounds.getSize().getY();
        int sizeC = bounds.getSize().getC();
        int sizeZ = bounds.getSize().getZ();
        int sizeT = bounds.getSize().getT();
        int pixelType = FormatTools.pixelTypeFromString((String)pixels.getPixelType());
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        ImagePlus imp = IJ.createHyperStack((String)((ImageData)this.data).getName(), (int)sizeX, (int)sizeY, (int)sizeC, (int)sizeZ, (int)sizeT, (int)(bpp * 8));
        Calibration calibration = imp.getCalibration();
        ImageWrapper.setCalibration(pixels, calibration);
        calibration.xOrigin -= (double)startX;
        calibration.yOrigin -= (double)startY;
        calibration.zOrigin -= (double)startZ;
        imp.setCalibration(calibration);
        boolean isFloat = FormatTools.isFloatingPoint((int)pixelType);
        ImageStack stack = imp.getImageStack();
        double min = imp.getProcessor().getMin();
        double max = 0.0;
        int progressTotal = imp.getStackSize();
        IJ.showProgress((int)0, (int)progressTotal);
        for (int t = 0; t < sizeT; ++t) {
            int posT = t + startT;
            for (int z = 0; z < sizeZ; ++z) {
                int posZ = z + startZ;
                for (int c = 0; c < sizeC; ++c) {
                    int posC = c + startC;
                    PixelsWrapper.Coordinates pos = new PixelsWrapper.Coordinates(startX, startY, posC, posZ, posT);
                    byte[] tiles = pixels.getRawTile(client, pos, sizeX, sizeY, bpp);
                    int n = imp.getStackIndex(c + 1, z + 1, t + 1);
                    stack.setPixels(DataTools.makeDataArray((byte[])tiles, (int)bpp, (boolean)isFloat, (boolean)false), n);
                    ImageProcessor ip = stack.getProcessor(n);
                    ip.resetMinAndMax();
                    max = Math.max(ip.getMax(), max);
                    min = Math.min(ip.getMin(), min);
                    stack.setProcessor(ip, n);
                    IJ.showProgress((int)n, (int)progressTotal);
                }
            }
        }
        imp.setStack(stack);
        imp.setOpenAsHyperStack(true);
        imp.setDisplayMode(1);
        imp.getProcessor().setMinAndMax(min, max);
        LUT[] luts = imp.getLuts();
        for (int c = 0; c < sizeC; ++c) {
            luts[c] = LUT.createLutFromColor((Color)this.getChannelColor(client, startC + c));
            imp.setC(c + 1);
            imp.setLut(luts[c]);
        }
        if (imp.isComposite()) {
            ((CompositeImage)imp).setLuts(luts);
        }
        if (createdRDF) {
            pixels.destroyRawDataFacility();
        }
        imp.setPosition(1);
        if (IJ.getVersion().compareTo("1.53a") >= 0) {
            imp.setProp(IJ_ID_PROPERTY, (double)this.getId());
            imp.setProp("IMAGE_POS_X", (double)startX);
            imp.setProp("IMAGE_POS_Y", (double)startY);
            imp.setProp("IMAGE_POS_C", (double)startC);
            imp.setProp("IMAGE_POS_Z", (double)startZ);
            imp.setProp("IMAGE_POS_T", (double)startT);
        }
        return imp;
    }

    public ImagePlus toImagePlus(Client client, ROIWrapper roi) throws ServiceException, AccessException, ExecutionException {
        return this.toImagePlus(client, roi.getBounds());
    }

    public ImagePlus toImagePlus(Client client, PixelsWrapper.Bounds bounds) throws ServiceException, AccessException, ExecutionException {
        int[] x = new int[]{bounds.getStart().getX(), bounds.getEnd().getX()};
        int[] y = new int[]{bounds.getStart().getY(), bounds.getEnd().getY()};
        int[] c = new int[]{bounds.getStart().getC(), bounds.getEnd().getC()};
        int[] z = new int[]{bounds.getStart().getZ(), bounds.getEnd().getZ()};
        int[] t = new int[]{bounds.getStart().getT(), bounds.getEnd().getT()};
        return this.toImagePlus(client, x, y, c, z, t);
    }

    public List<ChannelWrapper> getChannels(Client client) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get the channel name for " + this;
        List channels = ExceptionHandler.call(client.getMetadata(), m -> m.getChannelData(client.getCtx(), this.getId()), error);
        return channels.stream().sorted(Comparator.comparing(ChannelData::getIndex)).map(ChannelWrapper::new).collect(Collectors.toList());
    }

    public String getChannelName(Client client, int index) throws ServiceException, AccessException, ExecutionException {
        return this.getChannels(client).get(index).getChannelLabeling();
    }

    public Color getChannelImportedColor(Client client, int index) throws ServiceException, AccessException, ExecutionException {
        return this.getChannels(client).get(index).getColor();
    }

    public Color getChannelColor(Client client, int index) throws ServiceException, AccessException, ExecutionException {
        long pixelsId = ((ImageData)this.data).getDefaultPixels().getId();
        Color color = this.getChannelImportedColor(client, index);
        try {
            RenderingEnginePrx re = client.getGateway().getRenderingService(client.getCtx(), pixelsId);
            re.lookupPixels(pixelsId);
            if (!re.lookupRenderingDef(pixelsId)) {
                re.resetDefaultSettings(true);
                re.lookupRenderingDef(pixelsId);
            }
            re.load();
            int[] rgba = re.getRGBA(index);
            color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
            re.close();
        }
        catch (ServerError | DSOutOfServiceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Error while retrieving current color", e);
        }
        return color;
    }

    public BufferedImage getThumbnail(Client client, int size) throws ServiceException, OMEROServerError, IOException {
        BufferedImage thumbnail = null;
        byte[] arr = ExceptionHandler.of(client, c -> this.getThumbnailBytes((Client)c, size)).handleServiceOrServer("Error retrieving thumbnail.").get();
        if (arr != null) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(arr);){
                thumbnail = ImageIO.read(stream);
            }
        }
        return thumbnail;
    }

    public List<String> getOriginalPaths(Client client) throws ExecutionException, AccessException, ServiceException {
        String error = "Cannot get original paths for " + this;
        return ExceptionHandler.call(client.getMetadata(), m -> m.getOriginalPaths(client.getCtx(), (ImageData)this.data), error);
    }

    public List<String> getManagedRepositoriesPaths(Client client) throws ExecutionException, AccessException, ServiceException {
        String error = "Cannot get managed repositories paths for " + this;
        return ExceptionHandler.call(client.getMetadata(), m -> m.getManagedRepositoriesPaths(client.getCtx(), (ImageData)this.data), error);
    }

    public List<File> download(Client client, String path) throws OMEROServerError, ServiceException, AccessException {
        List<File> files = new ArrayList<File>(0);
        try {
            files = ExceptionHandler.call((TransferFacility)client.getGateway().getFacility(TransferFacility.class), t -> t.downloadImage(client.getCtx(), path, this.getId()), "Could not download image " + this.getId());
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return files;
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), b -> b.getImage(browser.getCtx(), this.getId()), "Can not reload " + this);
    }
}

