/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.AnnotatableWrapper;
import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GatewayWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.cli.ErrorHandler;
import ome.formats.importer.cli.LoggingImportMonitor;
import omero.ServerError;
import omero.gateway.model.DataObject;
import omero.gateway.util.PojoMapper;

public abstract class GenericRepositoryObjectWrapper<T extends DataObject>
extends AnnotatableWrapper<T> {
    protected GenericRepositoryObjectWrapper(T o) {
        super(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean importImages(GatewayWrapper client, DataObject target, int threads, String ... paths) throws ServiceException, OMEROServerError, IOException {
        boolean success;
        ImportConfig config = new ImportConfig();
        String type = PojoMapper.getGraphType(target.getClass());
        config.target.set((Object)(type + ":" + target.getId()));
        config.username.set((Object)client.getUser().getUserName());
        config.email.set((Object)client.getUser().getEmail());
        config.parallelFileset.set((Object)threads);
        config.parallelUpload.set((Object)threads);
        OMEROMetadataStoreClient store = client.getImportStore();
        try (OMEROWrapper reader = new OMEROWrapper(config);){
            ExceptionHandler.ofConsumer(store, s -> s.logVersionInfo(config.getIniVersionNumber())).rethrow(ServerError.class, OMEROServerError::new, "Cannot log version information during import.").rethrow();
            reader.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(MetadataLevel.ALL));
            ImportLibrary library = new ImportLibrary(store, reader);
            library.addObserver((IObserver)new LoggingImportMonitor());
            ErrorHandler handler = new ErrorHandler(config);
            ImportCandidates candidates = new ImportCandidates(reader, paths, (IObserver)handler);
            success = library.importCandidates(config, candidates);
        }
        finally {
            client.closeImport();
        }
        return success;
    }

    protected static List<Long> importImage(GatewayWrapper client, DataObject target, String path) throws ServiceException, OMEROServerError {
        ImportConfig config = new ImportConfig();
        String type = PojoMapper.getGraphType(target.getClass());
        config.target.set((Object)(type + ":" + target.getId()));
        config.username.set((Object)client.getUser().getUserName());
        config.email.set((Object)client.getUser().getEmail());
        ArrayList pixels = new ArrayList(1);
        OMEROMetadataStoreClient store = client.getImportStore();
        try (OMEROWrapper reader = new OMEROWrapper(config);){
            store.logVersionInfo(config.getIniVersionNumber());
            reader.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(MetadataLevel.ALL));
            ImportLibrary library = new ImportLibrary(store, reader);
            library.addObserver((IObserver)new LoggingImportMonitor());
            ErrorHandler handler = new ErrorHandler(config);
            ImportCandidates candidates = new ImportCandidates(reader, new String[]{path}, (IObserver)handler);
            ExecutorService uploadThreadPool = Executors.newFixedThreadPool((Integer)config.parallelUpload.get());
            List containers = candidates.getContainers();
            if (containers != null) {
                for (int i = 0; i < containers.size(); ++i) {
                    ImportContainer container = (ImportContainer)containers.get(i);
                    container.setTarget(target.asIObject());
                    List imported = library.importImage(container, uploadThreadPool, i);
                    pixels.addAll(imported);
                }
            }
            uploadThreadPool.shutdown();
        }
        catch (Throwable e) {
            throw new OMEROServerError(e);
        }
        finally {
            client.closeImport();
        }
        ArrayList ids = new ArrayList(pixels.size());
        pixels.forEach(pix -> ids.add(pix.getImage().getId().getValue()));
        return ids.stream().distinct().collect(Collectors.toList());
    }

    public abstract String getName();

    public abstract String getDescription();

    @Override
    public void copyAnnotationLinks(Client client, GenericRepositoryObjectWrapper<?> object) throws AccessException, ServiceException, ExecutionException {
        super.copyAnnotationLinks(client, object);
    }

    @Deprecated
    public void refresh(Client client) throws ServiceException, AccessException, ExecutionException {
        this.reload(client);
    }

    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
    }

    public static enum ReplacePolicy {
        UNLINK,
        DELETE,
        DELETE_ORPHANED;

    }
}

