/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.roi.ROIWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.gateway.facility.ROIFacility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.FolderData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ROIResult;
import omero.model.Folder;
import omero.model.FolderAnnotationLinkI;
import omero.model.FolderImageLinkI;
import omero.model.IObject;

public class FolderWrapper
extends GenericRepositoryObjectWrapper<FolderData> {
    public static final String ANNOTATION_LINK = "FolderAnnotationLink";
    private static final ROIWrapper[] EMPTY_ROI_ARRAY = new ROIWrapper[0];
    private long imageID = -1L;

    public FolderWrapper(FolderData folder) {
        super(folder);
    }

    public FolderWrapper(Folder folder) {
        super(new FolderData(folder));
    }

    public FolderWrapper(Client client, String name) throws ServiceException, OMEROServerError {
        super(new FolderData());
        ((FolderData)this.data).setName(name);
        Folder f = (Folder)ExceptionHandler.of(client.getGateway(), g -> g.getUpdateService(client.getCtx()).saveAndReturnObject(((FolderData)this.data).asIObject())).handleServiceOrServer("Could not create Folder with name: " + name).get();
        ((FolderData)this.data).setFolder(f);
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    @Override
    protected <A extends AnnotationData> void link(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        FolderAnnotationLinkI link = new FolderAnnotationLinkI();
        link.setChild(annotation.asAnnotation());
        link.setParent(((FolderData)this.data).asFolder());
        client.save((IObject)link);
    }

    @Override
    public String getName() {
        return ((FolderData)this.data).getName();
    }

    public void setName(String name) {
        ((FolderData)this.data).setName(name);
    }

    @Deprecated
    public FolderData asFolderData() {
        return (FolderData)this.data;
    }

    @Override
    public String getDescription() {
        return ((FolderData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((FolderData)this.data).setDescription(description);
    }

    @Deprecated
    public void reload(Client client) throws AccessException, ServiceException, ExecutionException {
        this.reload((Browser)client);
    }

    public FolderWrapper getParent() {
        return new FolderWrapper(((FolderData)this.data).getParentFolder());
    }

    public void setParent(FolderWrapper folder) {
        ((FolderData)this.data).setParentFolder(((FolderData)folder.asDataObject()).asFolder());
    }

    public void addChild(FolderWrapper folder) {
        ((FolderData)this.data).asFolder().addChildFolders(((FolderData)folder.asDataObject()).asFolder());
    }

    public void addChildren(Collection<? extends FolderWrapper> folders) {
        ((FolderData)this.data).asFolder().addAllChildFoldersSet(folders.stream().map(GenericObjectWrapper::asDataObject).map(DataObject::asFolder).collect(Collectors.toList()));
    }

    public List<FolderWrapper> getChildren() {
        return FolderWrapper.wrap(((FolderData)this.data).copyChildFolders(), FolderWrapper::new);
    }

    public void addImages(Client client, ImageWrapper ... images) throws ServiceException, AccessException, ExecutionException {
        ArrayList<FolderImageLinkI> links = new ArrayList<FolderImageLinkI>(images.length);
        List linkedIds = this.getImages().stream().map(GenericObjectWrapper::getId).collect(Collectors.toList());
        for (ImageWrapper image : images) {
            if (linkedIds.contains(image.getId())) continue;
            FolderImageLinkI link = new FolderImageLinkI();
            link.setChild(((ImageData)image.asDataObject()).asImage());
            link.setParent(((FolderData)this.data).asFolder());
            links.add(link);
        }
        ExceptionHandler.of(client.getDm(), d -> d.saveAndReturnObject(client.getCtx(), links, null, null)).handleOMEROException("Cannot save links.").rethrow();
    }

    public List<ImageWrapper> getImages() {
        return FolderWrapper.wrap(((FolderData)this.data).copyImageLinks(), ImageWrapper::new);
    }

    public List<ImageWrapper> getImages(Client client) throws AccessException, ServiceException, ExecutionException {
        this.reload(client);
        return this.getImages();
    }

    @Deprecated
    public void setImage(long id) {
        this.imageID = id;
    }

    @Deprecated
    public void setImage(ImageWrapper image) {
        this.imageID = image.getId();
    }

    @Deprecated
    public void addROI(Client client, ROIWrapper roi) throws ServiceException, AccessException, ExecutionException {
        this.addROIs(client, this.imageID, roi);
    }

    public void addROIs(Client client, long imageId, ROIWrapper ... rois) throws ServiceException, AccessException, ExecutionException {
        List roiData = Arrays.stream(rois).map(GenericObjectWrapper::asDataObject).collect(Collectors.toList());
        ROIFacility roiFac = client.getRoiFacility();
        ExceptionHandler.of(roiFac, rf -> rf.addRoisToFolders(client.getCtx(), imageId, (Collection)roiData, Collections.singletonList((FolderData)this.data))).handleOMEROException("Cannot add ROIs to " + this).rethrow();
    }

    public void addROIs(Client client, ImageWrapper image, ROIWrapper ... rois) throws ServiceException, AccessException, ExecutionException {
        this.addROIs(client, image.getId(), rois);
    }

    @Deprecated
    public List<ROIWrapper> getROIs(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getROIs(client, this.imageID);
    }

    public List<ROIWrapper> getROIs(Client client, long imageId) throws ServiceException, AccessException, ExecutionException {
        Collection roiResults = ExceptionHandler.call(client.getRoiFacility(), rf -> rf.loadROIsForFolder(client.getCtx(), imageId, ((FolderData)this.data).getId()), "Cannot get ROIs from " + this);
        List roiWrappers = roiResults.stream().map(ROIResult::getROIs).flatMap(Collection::stream).map(ROIWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
        return FolderWrapper.distinct(roiWrappers);
    }

    public List<ROIWrapper> getROIs(Client client, ImageWrapper image) throws ServiceException, AccessException, ExecutionException {
        return this.getROIs(client, image.getId());
    }

    @Deprecated
    public void unlinkAllROI(Client client) throws ServiceException, AccessException, ExecutionException {
        this.unlinkAllROIs(client);
    }

    public void unlinkAllROIs(Client client, long imageId) throws ServiceException, AccessException, ExecutionException {
        this.unlinkROIs(client, this.getROIs(client, imageId));
    }

    public void unlinkAllROIs(Client client, ImageWrapper image) throws ServiceException, AccessException, ExecutionException {
        this.unlinkAllROIs(client, image.getId());
    }

    public void unlinkAllROIs(Client client) throws ServiceException, AccessException, ExecutionException {
        List<ROIWrapper> rois = FolderWrapper.wrap(((FolderData)this.data).copyROILinks(), ROIWrapper::new);
        this.unlinkROIs(client, rois.toArray(EMPTY_ROI_ARRAY));
    }

    @Deprecated
    public void unlinkROI(Client client, ROIWrapper roi) throws ServiceException, AccessException, ExecutionException {
        this.unlinkROIs(client, roi);
    }

    public void unlinkROIs(Client client, ROIWrapper ... rois) throws ServiceException, AccessException, ExecutionException {
        this.unlinkROIs(client, Arrays.asList(rois));
    }

    public void unlinkROIs(Client client, Collection<? extends ROIWrapper> rois) throws ServiceException, AccessException, ExecutionException {
        List roiData = rois.stream().map(GenericObjectWrapper::asDataObject).collect(Collectors.toList());
        ExceptionHandler.ofConsumer(client.getRoiFacility(), rf -> rf.removeRoisFromFolders(client.getCtx(), -1L, (Collection)roiData, Collections.singletonList((FolderData)this.data))).handleOMEROException("Cannot unlink ROI from " + this).rethrow();
    }

    @Override
    public void reload(Browser browser) throws AccessException, ServiceException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), bf -> (FolderData)bf.loadFolders(browser.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot reload " + this);
    }
}

