/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.repository;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.FolderWrapper;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.ProjectWrapper;
import fr.igred.omero.roi.ROIWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.RLong;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.DatasetImageLinkI;
import omero.model.IObject;

public class DatasetWrapper
extends GenericRepositoryObjectWrapper<DatasetData> {
    public static final String ANNOTATION_LINK = "DatasetAnnotationLink";
    private static final Long[] LONGS = new Long[0];

    public DatasetWrapper(String name, String description) {
        super(new DatasetData());
        ((DatasetData)this.data).setName(name);
        ((DatasetData)this.data).setDescription(description);
    }

    public DatasetWrapper(DatasetData dataset) {
        super(dataset);
    }

    @Override
    public String getName() {
        return ((DatasetData)this.data).getName();
    }

    public void setName(String name) {
        ((DatasetData)this.data).setName(name);
    }

    @Deprecated
    public DatasetData asDatasetData() {
        return (DatasetData)this.data;
    }

    @Override
    public String getDescription() {
        return ((DatasetData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((DatasetData)this.data).setDescription(description);
    }

    @Override
    protected String annotationLinkType() {
        return ANNOTATION_LINK;
    }

    public List<ProjectWrapper> getProjects(Client client) throws OMEROServerError, ServiceException, AccessException, ExecutionException {
        String query = "select link.parent from ProjectDatasetLink as link where link.child=" + this.getId();
        List<IObject> os = client.findByQuery(query);
        return client.getProjects((Long[])os.stream().map(IObject::getId).map(RLong::getValue).distinct().toArray(Long[]::new));
    }

    public List<ImageWrapper> getImages() {
        return DatasetWrapper.wrap(((DatasetData)this.data).getImages(), ImageWrapper::new);
    }

    public List<ImageWrapper> getImages(Client client) throws ServiceException, AccessException, ExecutionException {
        Collection images = ExceptionHandler.call(client.getBrowseFacility(), bf -> bf.getImagesForDatasets(client.getCtx(), Collections.singletonList(((DatasetData)this.data).getId())), "Cannot get images from " + this);
        return DatasetWrapper.wrap(images, ImageWrapper::new);
    }

    public List<ImageWrapper> getImages(Client client, String name) throws ServiceException, AccessException, ExecutionException {
        List<ImageWrapper> images = this.getImages(client);
        images.removeIf(image -> !image.getName().equals(name));
        return images;
    }

    public List<ImageWrapper> getImagesLike(Client client, String motif) throws ServiceException, AccessException, ExecutionException {
        List<ImageWrapper> images = this.getImages(client);
        String regexp = ".*" + motif + ".*";
        images.removeIf(image -> !image.getName().matches(regexp));
        return images;
    }

    public List<ImageWrapper> getImagesTagged(Client client, TagAnnotationWrapper tag) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        return this.getImagesTagged(client, tag.getId());
    }

    public List<ImageWrapper> getImagesTagged(Client client, Long tagId) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        Long[] ids = (Long[])client.findByQuery("select link.parent from ImageAnnotationLink link where link.child = " + tagId + " and link.parent in (select link2.child from DatasetImageLink link2 where link2.parent = " + ((DatasetData)this.data).getId() + ")").stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return client.getImages(ids);
    }

    @Deprecated
    public List<ImageWrapper> getImagesKey(Client client, String key) throws ServiceException, AccessException, ExecutionException {
        return this.getImagesWithKey(client, key);
    }

    public List<ImageWrapper> getImagesWithKey(Client client, String key) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get images with key \"" + key + "\" from " + this;
        Collection images = ExceptionHandler.call(client.getBrowseFacility(), bf -> bf.getImagesForDatasets(client.getCtx(), Collections.singletonList(((DatasetData)this.data).getId())), error);
        ArrayList<ImageWrapper> selected = new ArrayList<ImageWrapper>(images.size());
        for (ImageData image : images) {
            ImageWrapper imageWrapper = new ImageWrapper(image);
            Map<String, String> pairsKeyValue = imageWrapper.getKeyValuePairs(client);
            if (pairsKeyValue.get(key) == null) continue;
            selected.add(imageWrapper);
        }
        selected.sort(Comparator.comparing(GenericObjectWrapper::getId));
        return selected;
    }

    @Deprecated
    public List<ImageWrapper> getImagesPairKeyValue(Client client, String key, String value) throws ServiceException, AccessException, ExecutionException {
        return this.getImagesWithKeyValuePair(client, key, value);
    }

    public List<ImageWrapper> getImagesWithKeyValuePair(Client client, String key, String value) throws ServiceException, AccessException, ExecutionException {
        Collection images = ExceptionHandler.call(client.getBrowseFacility(), bf -> bf.getImagesForDatasets(client.getCtx(), Collections.singletonList(((DatasetData)this.data).getId())), "Cannot get images with key-value pair from " + this);
        ArrayList<ImageWrapper> selected = new ArrayList<ImageWrapper>(images.size());
        for (ImageData image : images) {
            ImageWrapper imageWrapper = new ImageWrapper(image);
            Map<String, String> pairs = imageWrapper.getKeyValuePairs(client);
            if (pairs.get(key) == null || !pairs.get(key).equals(value)) continue;
            selected.add(imageWrapper);
        }
        selected.sort(Comparator.comparing(GenericObjectWrapper::getId));
        return selected;
    }

    public void addImages(Client client, List<? extends ImageWrapper> images) throws ServiceException, AccessException, ExecutionException {
        for (ImageWrapper imageWrapper : images) {
            this.addImage(client, imageWrapper);
        }
    }

    public void addImage(Client client, ImageWrapper image) throws ServiceException, AccessException, ExecutionException {
        DatasetImageLinkI link = new DatasetImageLinkI();
        link.setChild(((ImageData)image.asDataObject()).asImage());
        link.setParent((Dataset)new DatasetI(((DatasetData)this.data).getId(), false));
        client.save((IObject)link);
    }

    public void removeImage(Client client, ImageWrapper image) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.removeLink(client, "DatasetImageLink", image.getId());
    }

    public boolean importImages(Client client, String ... paths) throws ServiceException, OMEROServerError, AccessException, IOException, ExecutionException {
        return this.importImages(client, 1, paths);
    }

    public boolean importImages(Client client, int threads, String ... paths) throws ServiceException, OMEROServerError, AccessException, IOException, ExecutionException {
        return DatasetWrapper.importImages(client, this.data, threads, paths);
    }

    public List<Long> importImage(Client client, String path) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        return DatasetWrapper.importImage(client, this.data, path);
    }

    public List<ImageWrapper> replaceImages(Client client, Collection<? extends ImageWrapper> oldImages, ImageWrapper newImage) throws AccessException, ServiceException, ExecutionException, OMEROServerError, InterruptedException {
        ArrayList<String> descriptions = new ArrayList<String>(oldImages.size() + 1);
        ArrayList<ImageWrapper> orphaned = new ArrayList<ImageWrapper>(oldImages.size());
        descriptions.add(newImage.getDescription());
        for (ImageWrapper imageWrapper : oldImages) {
            descriptions.add(imageWrapper.getDescription());
            newImage.copyAnnotationLinks(client, imageWrapper);
            List<ROIWrapper> rois = imageWrapper.getROIs(client);
            newImage.saveROIs(client, rois);
            List<FolderWrapper> folders = imageWrapper.getFolders(client);
            for (FolderWrapper folder : folders) {
                folder.addImages(client, newImage);
            }
            this.removeImage(client, imageWrapper);
            if (!imageWrapper.isOrphaned(client)) continue;
            orphaned.add(imageWrapper);
        }
        descriptions.removeIf(s -> s == null || s.trim().isEmpty());
        newImage.setDescription(String.join((CharSequence)"\n", descriptions));
        newImage.saveAndUpdate(client);
        return orphaned;
    }

    public List<Long> importAndReplaceImages(Client client, String path, GenericRepositoryObjectWrapper.ReplacePolicy policy) throws ServiceException, AccessException, OMEROServerError, ExecutionException, InterruptedException {
        List<Long> ids = this.importImage(client, path);
        Long[] newIds = ids.toArray(LONGS);
        List<ImageWrapper> newImages = client.getImages(newIds);
        ArrayList<ImageWrapper> toDelete = new ArrayList<ImageWrapper>(newImages.size());
        for (ImageWrapper image : newImages) {
            List<ImageWrapper> oldImages = this.getImages(client, image.getName());
            oldImages.removeIf(img -> ids.contains(img.getId()));
            List<ImageWrapper> orphaned = this.replaceImages(client, oldImages, image);
            if (policy == GenericRepositoryObjectWrapper.ReplacePolicy.DELETE) {
                toDelete.addAll(oldImages);
                continue;
            }
            if (policy != GenericRepositoryObjectWrapper.ReplacePolicy.DELETE_ORPHANED) continue;
            toDelete.addAll(orphaned);
        }
        if (policy == GenericRepositoryObjectWrapper.ReplacePolicy.DELETE_ORPHANED) {
            List idsToDelete = toDelete.stream().map(GenericObjectWrapper::getId).collect(Collectors.toList());
            ArrayList orphans = new ArrayList(toDelete);
            for (ImageWrapper orphan : orphans) {
                for (ImageWrapper other : orphan.getFilesetImages(client)) {
                    if (!other.isOrphaned(client) || idsToDelete.contains(other.getId())) continue;
                    toDelete.add(other);
                }
            }
        }
        client.delete((Collection<? extends GenericObjectWrapper<?>>)toDelete);
        return ids;
    }

    public List<Long> importAndReplaceImages(Client client, String path) throws ServiceException, AccessException, OMEROServerError, ExecutionException, InterruptedException {
        return this.importAndReplaceImages(client, path, GenericRepositoryObjectWrapper.ReplacePolicy.UNLINK);
    }

    @Override
    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException {
        this.data = (DataObject)ExceptionHandler.call(browser.getBrowseFacility(), bf -> (DatasetData)bf.getDatasets(browser.getCtx(), Collections.singletonList(this.getId())).iterator().next(), "Cannot reload " + this);
    }
}

