/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.meta;

import fr.igred.omero.GenericObjectWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import ome.formats.model.UnitsFactory;
import ome.units.UNITS;
import ome.units.unit.Unit;
import omero.gateway.model.PlaneInfoData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Time;
import omero.model.TimeI;

public class PlaneInfoWrapper
extends GenericObjectWrapper<PlaneInfoData> {
    public PlaneInfoWrapper(PlaneInfoData object) {
        super(object);
    }

    public static Time computeMeanTimeInterval(Collection<? extends PlaneInfoWrapper> planesInfo, int sizeT) {
        int size = Math.min(sizeT, planesInfo.size());
        ome.units.quantity.Time[] deltas = new ome.units.quantity.Time[size];
        planesInfo.stream().filter(p -> p.getTheC() == 0 && p.getTheZ() == 0 && p.getTheT() < deltas.length).forEach(p -> {
            deltas[p.getTheT()] = UnitsFactory.convertTime((Time)p.getDeltaT());
        });
        Unit unit = Arrays.stream(deltas).filter(Objects::nonNull).findFirst().map(ome.units.quantity.Time::unit).orElse(UNITS.SECOND);
        double mean = 0.0;
        int count = 0;
        for (int i = 1; i < deltas.length; ++i) {
            double delta2;
            double delta1 = deltas[i - 1] != null ? deltas[i - 1].value(unit).doubleValue() : Double.NaN;
            double d = delta2 = deltas[i] != null ? deltas[i].value(unit).doubleValue() : Double.NaN;
            if (Double.isNaN(delta1) || Double.isNaN(delta2)) continue;
            mean += delta2 - delta1;
            ++count;
        }
        return new TimeI(mean /= count == 0 ? Double.NaN : (double)count, unit);
    }

    public static Time computeMeanExposureTime(Iterable<? extends PlaneInfoWrapper> planesInfo, int channel) {
        ome.units.quantity.Time t0 = null;
        Iterator<? extends PlaneInfoWrapper> iterator = planesInfo.iterator();
        while (t0 == null && iterator.hasNext()) {
            t0 = UnitsFactory.convertTime((Time)planesInfo.iterator().next().getExposureTime());
        }
        Unit unit = t0 == null ? UNITS.SECOND : t0.unit();
        double mean = 0.0;
        int count = 0;
        for (PlaneInfoWrapper planeInfoWrapper : planesInfo) {
            ome.units.quantity.Time t;
            if (channel != planeInfoWrapper.getTheC() || (t = UnitsFactory.convertTime((Time)planeInfoWrapper.getExposureTime())) == null) continue;
            Number value = t.value(unit);
            if (value != null) {
                mean += value.doubleValue();
            }
            ++count;
        }
        return new TimeI(mean /= count == 0 ? Double.NaN : (double)count, unit);
    }

    public static Length getMinPosition(Collection<? extends PlaneInfoWrapper> planesInfo, Function<? super PlaneInfoWrapper, ? extends Length> getter, Unit<ome.units.quantity.Length> unit) {
        double pos = planesInfo.stream().map(getter).map(UnitsFactory::convertLength).filter(Objects::nonNull).map(p -> p.value(unit)).filter(Objects::nonNull).mapToDouble(Number::doubleValue).min().orElse(0.0);
        return new LengthI(pos, unit);
    }

    public static Length getMinPosition(Collection<? extends PlaneInfoWrapper> planesInfo, Function<? super PlaneInfoWrapper, ? extends Length> getter) {
        Unit unit = planesInfo.stream().map(getter).map(UnitsFactory::convertLength).filter(Objects::nonNull).map(ome.units.quantity.Length::unit).findFirst().orElse(UNITS.MICROMETER);
        return PlaneInfoWrapper.getMinPosition(planesInfo, getter, (Unit<ome.units.quantity.Length>)unit);
    }

    @Deprecated
    public PlaneInfoData asPlaneInfoData() {
        return (PlaneInfoData)this.data;
    }

    public Time getDeltaT() {
        return ((PlaneInfoData)this.data).getDeltaT();
    }

    public Time getExposureTime() {
        return ((PlaneInfoData)this.data).getExposureTime();
    }

    public Length getPositionX() {
        return ((PlaneInfoData)this.data).getPositionX();
    }

    public Length getPositionY() {
        return ((PlaneInfoData)this.data).getPositionY();
    }

    public Length getPositionZ() {
        return ((PlaneInfoData)this.data).getPositionZ();
    }

    public int getTheC() {
        return ((PlaneInfoData)this.data).getTheC();
    }

    public int getTheT() {
        return ((PlaneInfoData)this.data).getTheT();
    }

    public int getTheZ() {
        return ((PlaneInfoData)this.data).getTheZ();
    }
}

