/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.meta;

import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.meta.GroupWrapper;
import java.util.List;
import java.util.concurrent.ExecutionException;
import omero.gateway.model.ExperimenterData;

public class ExperimenterWrapper
extends GenericObjectWrapper<ExperimenterData> {
    public ExperimenterWrapper(ExperimenterData experimenter) {
        super(experimenter);
    }

    @Deprecated
    public ExperimenterData asExperimenterData() {
        return (ExperimenterData)this.data;
    }

    public String getFirstName() {
        return ((ExperimenterData)this.data).getFirstName();
    }

    public void setFirstName(String firstName) {
        ((ExperimenterData)this.data).setFirstName(firstName);
    }

    public String getLastName() {
        return ((ExperimenterData)this.data).getLastName();
    }

    public void setLastName(String lastName) {
        ((ExperimenterData)this.data).setLastName(lastName);
    }

    public String getUserName() {
        return ((ExperimenterData)this.data).getUserName();
    }

    public String getEmail() {
        return ((ExperimenterData)this.data).getEmail();
    }

    public void setEmail(String email) {
        ((ExperimenterData)this.data).setEmail(email);
    }

    public String getInstitution() {
        return ((ExperimenterData)this.data).getInstitution();
    }

    public void setInstitution(String institution) {
        ((ExperimenterData)this.data).setInstitution(institution);
    }

    public List<GroupWrapper> getGroups() {
        return ExperimenterWrapper.wrap(((ExperimenterData)this.data).getGroups(), GroupWrapper::new, GroupWrapper::getName);
    }

    public GroupWrapper getDefaultGroup() {
        return new GroupWrapper(((ExperimenterData)this.data).getDefaultGroup());
    }

    public String getMiddleName() {
        return ((ExperimenterData)this.data).getMiddleName();
    }

    public void setMiddleName(String middleName) {
        ((ExperimenterData)this.data).setMiddleName(middleName);
    }

    public boolean isActive() {
        return ((ExperimenterData)this.data).isActive();
    }

    public boolean isMemberOfGroup(long groupId) {
        return ((ExperimenterData)this.data).isMemberOfGroup(groupId);
    }

    public boolean isLDAP() {
        return ((ExperimenterData)this.data).isLDAP();
    }

    public boolean isLeader(GroupWrapper group) {
        return group.getLeaders().stream().anyMatch(l -> l.getId() == ((ExperimenterData)this.data).getId());
    }

    public boolean isAdmin(Client client) throws ServiceException, AccessException, ExecutionException {
        return !ExceptionHandler.call(client.getAdminFacility(), a -> a.getAdminPrivileges(client.getCtx(), (ExperimenterData)this.data), "Cannot retrieve admin privileges.").isEmpty();
    }
}

