/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.exception;

import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import java.util.Objects;
import omero.AuthenticationException;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.ServerError;
import omero.SessionException;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;

public class ExceptionHandler<T> {
    private final Exception exception;
    private final T value;

    protected ExceptionHandler(T value, Exception exception) {
        this.value = value;
        this.exception = exception;
    }

    private static boolean isAuthenticationException(Throwable t) {
        return t != null && AuthenticationException.class.isAssignableFrom(t.getClass());
    }

    private static boolean isSecurityViolation(Throwable t) {
        return t instanceof SecurityViolation || t != null && t.getCause() instanceof SecurityViolation;
    }

    private static boolean shouldBeHandled(Throwable t) {
        boolean toHandle = false;
        if (t instanceof ServerError) {
            toHandle = true;
        } else if (t instanceof DSOutOfServiceException) {
            Throwable cause = t.getCause();
            toHandle = ExceptionHandler.isSecurityViolation(cause) || cause instanceof SessionException || ExceptionHandler.isAuthenticationException(cause) || cause instanceof ResourceError;
        }
        return toHandle;
    }

    @Deprecated
    private static void handleServiceException(Throwable t, String message) throws ServiceException {
        if (t instanceof Exception) {
            new ExceptionHandler<Object>(null, (Exception)t).rethrow(DSOutOfServiceException.class, ServiceException::new, message);
        }
    }

    @Deprecated
    private static void handleServerError(Throwable t, String message) throws OMEROServerError {
        if (t instanceof ServerError) {
            new ExceptionHandler<Object>(null, (Exception)t).rethrow(ServerError.class, OMEROServerError::new, message);
        }
    }

    @Deprecated
    private static void handleAccessException(Throwable t, String message) throws AccessException {
        if (t instanceof DSAccessException) {
            new ExceptionHandler<Object>(null, (Exception)t).rethrow(DSAccessException.class, AccessException::new, message);
        }
    }

    @Deprecated
    public static void handleServiceOrServer(Throwable t, String message) throws ServiceException, OMEROServerError {
        ExceptionHandler.handleServiceException(t, message);
        ExceptionHandler.handleServerError(t, message);
    }

    @Deprecated
    public static void handleServiceOrAccess(Throwable t, String message) throws ServiceException, AccessException {
        ExceptionHandler.handleServiceException(t, message);
        ExceptionHandler.handleAccessException(t, message);
    }

    @Deprecated
    public static void handleException(Throwable t, String message) throws ServiceException, AccessException, OMEROServerError {
        ExceptionHandler.handleAccessException(t, message);
        ExceptionHandler.handleServerError(t, message);
        ExceptionHandler.handleServiceException(t, message);
    }

    public static <I, R> ExceptionHandler<R> of(I input, ThrowingFunction<? super I, ? extends R, ? extends Exception> mapper) {
        Objects.requireNonNull(mapper);
        Exception e = null;
        Object result = null;
        try {
            result = mapper.apply(input);
        }
        catch (Exception ex) {
            e = ex;
        }
        return new ExceptionHandler<Object>(result, e);
    }

    public static <I> ExceptionHandler<I> ofConsumer(I input, ThrowingConsumer<? super I, ? extends Exception> consumer) {
        Objects.requireNonNull(consumer);
        Exception e = null;
        try {
            consumer.apply(input);
        }
        catch (Exception ex) {
            e = ex;
        }
        return new ExceptionHandler<I>(input, e);
    }

    private static <E extends Throwable> void doThrow(Exception t) throws E {
        throw t;
    }

    public static <I, R> R call(I input, OMEROFunction<? super I, ? extends R> mapper, String message) throws AccessException, ServiceException {
        return ExceptionHandler.of(input, mapper).handleOMEROException(message).get();
    }

    public static void handleOMEROException(Throwable throwable, String message) throws ServiceException, AccessException {
        Throwable cause = throwable.getCause();
        if (ExceptionHandler.isSecurityViolation(cause)) {
            String s = String.format("For security reasons, cannot access data. %n", new Object[0]);
            throw new AccessException(s + message, cause);
        }
        if (cause instanceof SessionException) {
            String s = String.format("Session is not valid. %n", new Object[0]);
            throw new ServiceException(s + message, cause);
        }
        if (ExceptionHandler.isAuthenticationException(cause)) {
            String s = String.format("Cannot initialize the session. %n", new Object[0]);
            throw new ServiceException(s + message, cause);
        }
        if (cause instanceof ResourceError) {
            String s = String.format("Fatal error. Please contact the administrator. %n", new Object[0]);
            throw new ServiceException(s + message, throwable);
        }
        String s = String.format("Cannot access data. %n", new Object[0]);
        throw new AccessException(s + message, throwable);
    }

    public <E extends Throwable> ExceptionHandler<T> rethrow(Class<E> type) throws E {
        if (type.isInstance(this.exception)) {
            throw (Throwable)type.cast(this.exception);
        }
        return this;
    }

    public <E extends Throwable, F extends Throwable> ExceptionHandler<T> rethrow(Class<E> type, ExceptionWrapper<? super E, ? extends F> mapper, String message) throws F {
        if (type.isInstance(this.exception)) {
            throw mapper.apply(message, type.cast(this.exception));
        }
        return this;
    }

    public ExceptionHandler<T> handleServerAndService(String msg) throws ServiceException, AccessException {
        if (ExceptionHandler.shouldBeHandled(this.exception)) {
            ExceptionHandler.handleOMEROException(this.exception, msg);
        } else if (this.exception instanceof DSOutOfServiceException) {
            this.rethrow(DSOutOfServiceException.class, ServiceException::new, msg);
        }
        return this;
    }

    @Deprecated
    public ExceptionHandler<T> handleServiceOrServer(String message) throws ServiceException, OMEROServerError {
        return this.rethrow(DSOutOfServiceException.class, ServiceException::new, message).rethrow(ServerError.class, OMEROServerError::new, message);
    }

    @Deprecated
    public ExceptionHandler<T> handleServiceOrAccess(String message) throws ServiceException, AccessException {
        return this.handleOMEROException(message);
    }

    @Deprecated
    public ExceptionHandler<T> handleException(String message) throws ServiceException, AccessException, OMEROServerError {
        return this.handleOMEROException(message);
    }

    public ExceptionHandler<T> handleOMEROException(String msg) throws ServiceException, AccessException {
        return this.rethrow(DSAccessException.class, AccessException::new, msg).handleServerAndService(msg);
    }

    public void rethrow() {
        if (this.exception != null) {
            ExceptionHandler.doThrow(this.exception);
        }
    }

    public T get() {
        this.rethrow();
        return this.value;
    }

    public String toString() {
        return "ExceptionHandler{exception=" + this.exception + ", value=" + this.value + "}";
    }

    @FunctionalInterface
    public static interface ExceptionWrapper<T, E extends Throwable> {
        public E apply(String var1, T var2);
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface OMEROFunction<T, R>
    extends ThrowingFunction<T, R, Exception> {
        @Override
        public R apply(T var1) throws DSOutOfServiceException, DSAccessException, ServerError;
    }
}

