/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.annotations;

import fr.igred.omero.Browser;
import fr.igred.omero.Client;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import omero.gateway.model.TagAnnotationData;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLinkI;
import omero.model.IObject;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;

public class TagSetWrapper
extends TagAnnotationWrapper {
    public TagSetWrapper(TagAnnotationData tag) {
        super(tag);
        super.setNameSpace("openmicroscopy.org/omero/insight/tagset");
    }

    public TagSetWrapper(Client dm, String name, String description) throws ServiceException, AccessException, ExecutionException {
        this(new TagAnnotationData(name, description));
        super.saveAndUpdate(dm);
    }

    public List<TagAnnotationWrapper> getTags() {
        return TagSetWrapper.wrap(((TagAnnotationData)this.data).getTags(), TagAnnotationWrapper::new);
    }

    public List<TagAnnotationWrapper> getTags(Browser browser) throws ExecutionException, AccessException, ServiceException, OMEROServerError {
        this.reload(browser);
        return this.getTags();
    }

    public void link(Client dm, TagAnnotationWrapper tag) throws AccessException, ServiceException, ExecutionException {
        AnnotationAnnotationLinkI link = new AnnotationAnnotationLinkI();
        link.setParent((Annotation)new TagAnnotationI(this.getId(), false));
        link.setChild(((TagAnnotationData)tag.asDataObject()).asAnnotation());
        dm.save((IObject)link);
    }

    public void link(Client dm, TagAnnotationWrapper ... tags) throws AccessException, ServiceException, ExecutionException {
        for (TagAnnotationWrapper tag : tags) {
            this.link(dm, tag);
        }
    }

    public void reload(Browser browser) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        String query = "select t from TagAnnotation as t left outer join fetch t.annotationLinks as l left outer join fetch l.child as a where t.id=" + this.getId();
        IObject o = browser.findByQuery(query).iterator().next();
        this.data = new TagAnnotationData((TagAnnotation)o);
    }
}

