/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.annotations;

import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.roi.ROIWrapper;
import ij.gui.Roi;
import ij.macro.Variable;
import ij.measure.ResultsTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.ROIData;
import omero.gateway.model.TableData;
import omero.gateway.model.TableDataColumn;

public class TableWrapper {
    private static final ROIData[] EMPTY_ROI = new ROIData[0];
    private static final String LABEL = "Label";
    private static final String IMAGE = "Image";
    private TableDataColumn[] columns;
    private Object[][] data;
    private int columnCount;
    private int rowCount;
    private int row;
    private String name;
    private Long fileId = -1L;
    private Long id = -1L;

    public TableWrapper(int columnCount, String name) {
        this.columnCount = columnCount;
        this.name = name;
        this.columns = new TableDataColumn[columnCount];
        this.data = new Object[columnCount][0];
        this.rowCount = 0;
        this.row = 0;
    }

    public TableWrapper(TableData table) {
        this.columns = table.getColumns();
        this.columnCount = this.columns.length;
        this.data = table.getData();
        this.row = this.rowCount = (int)table.getNumberOfRows();
        this.name = null;
    }

    public TableWrapper(Client client, ResultsTable results, Long imageId, List<? extends Roi> ijRois) throws ServiceException, AccessException, ExecutionException {
        this(client, results, imageId, ijRois, "ROI");
    }

    public TableWrapper(Client client, ResultsTable results, Long imageId, List<? extends Roi> ijRois, String roiProperty) throws ServiceException, AccessException, ExecutionException {
        ROIData[] roiColumn;
        roiProperty = ROIWrapper.checkProperty(roiProperty);
        ResultsTable rt = (ResultsTable)results.clone();
        this.fileId = null;
        this.name = rt.getTitle();
        this.rowCount = rt.size();
        int offset = 0;
        ImageWrapper image = new ImageWrapper(null);
        List<Object> rois = new ArrayList(0);
        if (imageId != null) {
            image = client.getImage(imageId);
            rois = image.getROIs(client);
            ++offset;
            TableWrapper.renameImageColumn(rt);
        }
        if ((roiColumn = TableWrapper.createROIColumn(rt, rois, ijRois, roiProperty)).length > 0) {
            ++offset;
        }
        String[] headings = rt.getHeadings();
        String[] shortHeadings = rt.getHeadingsAsVariableNames();
        int nColumns = headings.length;
        this.columnCount = nColumns + offset;
        this.columns = new TableDataColumn[this.columnCount];
        this.data = new Object[this.columnCount][];
        if (offset > 0) {
            this.createColumn(0, IMAGE, ImageData.class);
            this.data[0] = new ImageData[this.rowCount];
            Arrays.fill(this.data[0], image.asDataObject());
        }
        if (offset > 1) {
            this.createColumn(1, roiProperty, ROIData.class);
            this.data[1] = roiColumn;
        }
        for (int i = 0; i < nColumns; ++i) {
            Variable[] col = rt.getColumnAsVariables(headings[i]);
            if (TableWrapper.isColumnNumeric(col) && !headings[i].equals(LABEL)) {
                this.createColumn(offset + i, shortHeadings[i], Double.class);
                this.data[offset + i] = Arrays.stream(col).map(Variable::getValue).toArray(Double[]::new);
                continue;
            }
            this.createColumn(offset + i, shortHeadings[i], String.class);
            this.data[offset + i] = rt.getColumnAsStrings(headings[i]);
        }
        this.row = this.rowCount;
    }

    private static Long safeParseLong(String s) {
        Long l = null;
        if (s != null) {
            try {
                l = Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    private static boolean isColumnNumeric(Variable[] resultsColumn) {
        return Arrays.stream(resultsColumn).map(v -> !Double.isNaN(v.getValue()) || v.toString().equals(String.valueOf(Double.NaN))).reduce(Boolean::logicalOr).orElse(false);
    }

    private static void renameImageColumn(ResultsTable results) {
        if (results.columnExists(IMAGE)) {
            List<String> headings = Arrays.asList(results.getHeadings());
            if (!headings.contains(LABEL)) {
                results.renameColumn(IMAGE, LABEL);
            } else if (!results.columnExists("Image_Name")) {
                results.renameColumn(IMAGE, "Image_Name");
            } else {
                results.renameColumn(IMAGE, "Image_column_" + results.getColumnIndex(IMAGE));
            }
        }
    }

    private static ROIData[] propertyColumnToROIColumn(Variable[] roiCol, Map<Long, ROIData> id2roi, Map<String, ROIData> label2roi, Map<String, ROIData> name2roi, Map<String, ROIData> shapeName2roi) {
        ROIData[] roiColumn;
        if (TableWrapper.isColumnNumeric(roiCol)) {
            roiColumn = TableWrapper.numericColumnToROIColumn(roiCol, label2roi);
            if (roiColumn.length == 0) {
                roiColumn = TableWrapper.idColumnToROIColumn(roiCol, id2roi);
            }
            if (roiColumn.length == 0) {
                roiColumn = TableWrapper.numericColumnToROIColumn(roiCol, name2roi);
            }
        } else {
            roiColumn = TableWrapper.labelColumnToROIColumn(roiCol, name2roi, (m, s) -> s);
            if (roiColumn.length == 0) {
                roiColumn = TableWrapper.labelColumnToROIColumn(roiCol, label2roi, (m, s) -> s);
            }
            if (roiColumn.length == 0) {
                roiColumn = TableWrapper.labelColumnToROIColumn(roiCol, shapeName2roi, (m, s) -> s);
            }
        }
        return roiColumn;
    }

    private static ROIData[] idColumnToROIColumn(Variable[] roiCol, Map<Long, ROIData> id2roi) {
        ROIData[] roiColumn = (ROIData[])Arrays.stream(roiCol).map(Variable::getValue).map(Double::longValue).map(id2roi::get).toArray(ROIData[]::new);
        if (Arrays.asList(roiColumn).contains(null)) {
            roiColumn = EMPTY_ROI;
        }
        return roiColumn;
    }

    private static ROIData[] numericColumnToROIColumn(Variable[] roiCol, Map<String, ROIData> id2roi) {
        ROIData[] roiColumn = (ROIData[])Arrays.stream(roiCol).map(Variable::toString).map(id2roi::get).toArray(ROIData[]::new);
        if (Arrays.asList(roiColumn).contains(null)) {
            roiColumn = EMPTY_ROI;
        }
        return roiColumn;
    }

    private static ROIData[] labelColumnToROIColumn(Variable[] roiCol, Map<String, ROIData> label2roi, BiFunction<? super Map<String, ROIData>, ? super String, String> filter) {
        ROIData[] roiColumn = (ROIData[])Arrays.stream(roiCol).map(Variable::getString).map(s -> (String)filter.apply((Map<String, ROIData>)label2roi, (String)s)).map(label2roi::get).toArray(ROIData[]::new);
        if (Arrays.asList(roiColumn).contains(null)) {
            roiColumn = EMPTY_ROI;
        }
        return roiColumn;
    }

    private static ROIData[] createROIColumn(ResultsTable results, Collection<? extends ROIWrapper> rois, Collection<? extends Roi> ijRois, String roiProperty) {
        Variable[] roiCol;
        Variable[] roiCol2;
        String roiIdProperty = ROIWrapper.ijIDProperty(roiProperty);
        ROIData[] roiColumn = EMPTY_ROI;
        Map<Long, ROIData> id2roi = rois.stream().collect(Collectors.toMap(GenericObjectWrapper::getId, GenericObjectWrapper::asDataObject));
        Map<String, ROIData> name2roi = rois.stream().filter(r -> !r.getName().isEmpty()).collect(Collectors.toMap(ROIWrapper::getName, GenericObjectWrapper::asDataObject, (x1, x2) -> x1));
        Map label2roi = ijRois.stream().map(r -> new AbstractMap.SimpleEntry<String, Long>(r.getProperty(roiProperty), TableWrapper.safeParseLong(r.getProperty(roiIdProperty)))).filter(p -> p.getKey() != null).filter(p -> p.getValue() != null).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), (ROIData)id2roi.get(v.getValue())), HashMap::putAll);
        Map shape2roi = ijRois.stream().map(r -> new AbstractMap.SimpleEntry<String, Long>(r.getName(), TableWrapper.safeParseLong(r.getProperty(roiIdProperty)))).filter(p -> p.getKey() != null).filter(p -> p.getValue() != null).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), (ROIData)id2roi.get(v.getValue())), HashMap::putAll);
        String colToDelete = "";
        if (results.columnExists(roiIdProperty)) {
            roiCol2 = results.getColumnAsVariables(roiIdProperty);
            roiColumn = TableWrapper.idColumnToROIColumn(roiCol2, id2roi);
            colToDelete = roiIdProperty;
        }
        if (roiColumn.length == 0 && results.columnExists(roiProperty)) {
            roiCol2 = results.getColumnAsVariables(roiProperty);
            roiColumn = TableWrapper.propertyColumnToROIColumn(roiCol2, id2roi, label2roi, name2roi, shape2roi);
            colToDelete = roiProperty;
        }
        if (roiColumn.length != 0 && !colToDelete.isEmpty()) {
            results.deleteColumn(colToDelete);
        }
        String[] headings = results.getHeadings();
        if (roiColumn.length == 0 && Arrays.asList(headings).contains(LABEL) && (roiColumn = TableWrapper.labelColumnToROIColumn(roiCol = results.getColumnAsVariables(LABEL), shape2roi, (m, s) -> m.keySet().stream().filter(s::contains).findFirst().orElse(null))).length == 0) {
            roiColumn = TableWrapper.labelColumnToROIColumn(roiCol, name2roi, (m, s) -> m.keySet().stream().filter(s::contains).findFirst().orElse(null));
        }
        return roiColumn;
    }

    private boolean checkColumns(int nColumns, int offset) {
        boolean match;
        boolean bl = match = offset + nColumns == this.columnCount;
        if (offset > 0 && !this.columns[0].getType().equals(ImageData.class)) {
            match = false;
        }
        if (offset > 1 && !this.columns[1].getType().equals(ROIData.class)) {
            match = false;
        }
        return match;
    }

    private void createColumn(int column, String columnName, Class<?> type) {
        if (column >= this.columnCount) {
            String error = String.format("Column %d doesn't exist", column);
            throw new IndexOutOfBoundsException(error);
        }
        this.columns[column] = new TableDataColumn(columnName, column, type);
    }

    private Collection<Integer> getEmptyStringColumns() {
        ArrayList<Integer> emptyColumns = new ArrayList<Integer>(0);
        for (int j = this.columns.length - 1; j >= 0; --j) {
            TableDataColumn column = this.columns[j];
            if (!column.getType().equals(String.class)) continue;
            boolean empty = true;
            for (int i = 0; i < this.rowCount && empty; ++i) {
                if (this.data[j][i] == null || ((String)this.data[j][i]).isEmpty()) continue;
                empty = false;
            }
            if (!empty) continue;
            emptyColumns.add(j);
        }
        return emptyColumns;
    }

    private void removeColumn(int index) {
        if (index < this.columnCount) {
            --this.columnCount;
            int length = this.columnCount - index;
            TableDataColumn[] newColumns = new TableDataColumn[this.columnCount];
            Object[][] newData = new Object[this.columnCount][];
            System.arraycopy(this.columns, 0, newColumns, 0, index);
            System.arraycopy(this.columns, index + 1, newColumns, index, length);
            System.arraycopy(this.data, 0, newData, 0, index);
            System.arraycopy(this.data, index + 1, newData, index, length);
            this.columns = newColumns;
            this.data = newData;
        }
    }

    public String toString() {
        return String.format("%s (id=%d)", this.getClass().getSimpleName(), this.id);
    }

    public void addRows(Client client, ResultsTable results, Long imageId, List<? extends Roi> ijRois) throws ServiceException, AccessException, ExecutionException {
        this.addRows(client, results, imageId, ijRois, "ROI");
    }

    public void addRows(Client client, ResultsTable results, Long imageId, List<? extends Roi> ijRois, String roiProperty) throws ServiceException, AccessException, ExecutionException {
        String[] headings;
        int nColumns;
        ROIData[] roiColumn;
        roiProperty = ROIWrapper.checkProperty(roiProperty);
        ResultsTable rt = (ResultsTable)results.clone();
        ImageWrapper image = new ImageWrapper(null);
        List<Object> rois = new ArrayList(0);
        int offset = 0;
        if (imageId != null) {
            image = client.getImage(imageId);
            rois = image.getROIs(client);
            ++offset;
            TableWrapper.renameImageColumn(rt);
        }
        if ((roiColumn = TableWrapper.createROIColumn(rt, rois, ijRois, roiProperty)).length > 0) {
            ++offset;
        }
        if (!this.checkColumns(nColumns = (headings = rt.getHeadings()).length, offset)) {
            String error = "Number or type of columns mismatch";
            throw new IllegalArgumentException(error);
        }
        int n = rt.size();
        this.setRowCount(this.rowCount + n);
        if (offset > 0) {
            Arrays.fill(this.data[0], this.row, this.row + n, image.asDataObject());
        }
        if (offset > 1) {
            System.arraycopy(roiColumn, 0, this.data[1], this.row, n);
        }
        for (int i = 0; i < nColumns; ++i) {
            Object[] col;
            if (this.columns[offset + i].getType().equals(String.class)) {
                col = rt.getColumnAsStrings(headings[i]);
                System.arraycopy(col, 0, this.data[offset + i], this.row, n);
                continue;
            }
            col = (Double[])Arrays.stream(rt.getColumn(headings[i])).boxed().toArray(Double[]::new);
            System.arraycopy(col, 0, this.data[offset + i], this.row, n);
        }
        this.row += n;
    }

    public TableDataColumn[] getColumns() {
        return (TableDataColumn[])this.columns.clone();
    }

    public Object[][] getData() {
        return (Object[][])this.data.clone();
    }

    public Object getData(int x, int y) {
        return this.data[y][x];
    }

    public Long getFileId() {
        return this.fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int column) {
        return this.columns[column].getName();
    }

    public Class<?> getColumnType(int column) {
        return this.columns[column].getType();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        if (rowCount != this.rowCount) {
            Object[][] temp = new Object[this.columnCount][rowCount];
            if (this.data != null) {
                this.row = Math.min(rowCount, this.row);
                for (int j = 0; j < this.columnCount; ++j) {
                    System.arraycopy(this.data[j], 0, temp[j], 0, this.row);
                }
            }
            this.rowCount = rowCount;
            this.data = temp;
        }
    }

    public boolean isComplete() {
        return this.row == this.rowCount;
    }

    public void setColumn(int column, String columnName, Class<?> type) {
        this.createColumn(column, columnName, type);
    }

    public void addRow(Object ... os) {
        if (this.row < this.rowCount && os.length == this.columnCount) {
            for (int i = 0; i < os.length; ++i) {
                Object o;
                this.data[i][this.row] = o = os[i];
            }
            ++this.row;
        } else {
            if (this.row >= this.rowCount) {
                if (this.rowCount == 0) {
                    throw new IndexOutOfBoundsException("Row size is 0");
                }
                String error = "The table is already complete";
                throw new IndexOutOfBoundsException(error);
            }
            String error = "Argument count is different than the column size";
            throw new IllegalArgumentException(error);
        }
    }

    public void truncateRow() {
        this.setRowCount(this.row);
    }

    public TableData createTable() {
        if (!this.isComplete()) {
            this.truncateRow();
        }
        ArrayList<Integer> emptyColumns = new ArrayList<Integer>(this.getEmptyStringColumns());
        emptyColumns.sort(Collections.reverseOrder());
        emptyColumns.forEach(this::removeColumn);
        return new TableData(this.columns, this.data);
    }

    public void saveAs(String path, char delimiter) throws FileNotFoundException, UnsupportedEncodingException {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(4);
        formatter.setGroupingUsed(false);
        StringBuilder sb = new StringBuilder(10 * this.columnCount * this.rowCount);
        File file = new File(path);
        String sol = "\"";
        String sep = String.format("\"%c\"", Character.valueOf(delimiter));
        String eol = String.format("\"%n", new Object[0]);
        try (PrintWriter stream = new PrintWriter(file, StandardCharsets.UTF_8.name());){
            sb.append(sol);
            for (int j = 0; j < this.columnCount; ++j) {
                sb.append(this.columns[j].getName());
                if (j == this.columnCount - 1) continue;
                sb.append(sep);
            }
            sb.append(eol);
            for (int i = 0; i < this.rowCount; ++i) {
                sb.append(sol);
                for (int j = 0; j < this.columnCount; ++j) {
                    Object value = this.data[j][i];
                    if (DataObject.class.isAssignableFrom(this.columns[j].getType())) {
                        value = ((DataObject)value).getId();
                    }
                    if (value instanceof Number) {
                        value = formatter.format(value);
                    }
                    sb.append(value);
                    if (j == this.columnCount - 1) continue;
                    sb.append(sep);
                }
                sb.append(eol);
            }
            stream.write(sb.toString());
        }
    }
}

