/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.annotations;

import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.DatasetWrapper;
import fr.igred.omero.repository.FolderWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateAcquisitionWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.ProjectWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellWrapper;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.RLong;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.PlateAcquisitionData;
import omero.model.IObject;
import omero.model.PlateAcquisition;

public abstract class GenericAnnotationWrapper<T extends AnnotationData>
extends GenericObjectWrapper<T> {
    protected GenericAnnotationWrapper(T a) {
        super(a);
    }

    public String getNameSpace() {
        return ((AnnotationData)this.data).getNameSpace();
    }

    public void setNameSpace(String name) {
        ((AnnotationData)this.data).setNameSpace(name);
    }

    public Timestamp getLastModified() {
        return ((AnnotationData)this.data).getLastModified();
    }

    public String getDescription() {
        return ((AnnotationData)this.data).getDescription();
    }

    public void setDescription(String description) {
        ((AnnotationData)this.data).setDescription(description);
    }

    public int countAnnotationLinks(Client client) throws ServiceException, OMEROServerError {
        String q = "select link.parent from ome.model.IAnnotationLink link where link.child.id=" + this.getId();
        return client.findByQuery(q).size();
    }

    public List<ProjectWrapper> getProjects(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "ProjectAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.getProjects(ids);
    }

    public List<DatasetWrapper> getDatasets(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "DatasetAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.getDatasets(ids);
    }

    public List<ImageWrapper> getImages(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "ImageAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.getImages(ids);
    }

    public List<ScreenWrapper> getScreens(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "ScreenAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.getScreens(ids);
    }

    public List<PlateWrapper> getPlates(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "PlateAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.getPlates(ids);
    }

    public List<PlateAcquisitionWrapper> getPlateAcquisitions(Client client) throws ServiceException, OMEROServerError {
        List<IObject> os = this.getLinks(client, "PlateAcquisitionAnnotationLink");
        return os.stream().map(PlateAcquisition.class::cast).map(PlateAcquisitionData::new).map(PlateAcquisitionWrapper::new).collect(Collectors.toList());
    }

    public List<WellWrapper> getWells(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "WellAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.getWells(ids);
    }

    public List<FolderWrapper> getFolders(Client client) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        List<IObject> os = this.getLinks(client, "FolderAnnotationLink");
        Long[] ids = (Long[])os.stream().map(IObject::getId).map(RLong::getValue).sorted().toArray(Long[]::new);
        return client.loadFolders(ids);
    }

    private List<IObject> getLinks(Client client, String linkType) throws ServiceException, OMEROServerError {
        return client.findByQuery("select link.parent from " + linkType + " link where link.child = " + this.getId());
    }
}

