/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero.annotations;

import fr.igred.omero.Client;
import fr.igred.omero.annotations.GenericAnnotationWrapper;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import omero.ServerError;
import omero.api.RawFileStorePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.FileAnnotationData;

public class FileAnnotationWrapper
extends GenericAnnotationWrapper<FileAnnotationData> {
    public FileAnnotationWrapper(FileAnnotationData annotation) {
        super(annotation);
    }

    private RawFileStorePrx writeFile(Client client, FileOutputStream stream) throws ServerError, DSOutOfServiceException, IOException {
        int inc = 262144;
        RawFileStorePrx store = client.getGateway().getRawFileService(client.getCtx());
        store.setFileId(this.getFileID());
        long size = this.getFileSize();
        long offset = 0L;
        while (offset + 262144L < size) {
            stream.write(store.read(offset, 262144));
            offset += 262144L;
        }
        stream.write(store.read(offset, (int)(size - offset)));
        return store;
    }

    public String getOriginalMimetype() {
        return ((FileAnnotationData)this.data).getOriginalMimetype();
    }

    public String getServerFileMimetype() {
        return ((FileAnnotationData)this.data).getServerFileMimetype();
    }

    public String getFileFormat() {
        return ((FileAnnotationData)this.data).getFileFormat();
    }

    public String getFileKind() {
        return ((FileAnnotationData)this.data).getFileKind();
    }

    public File getAttachedFile() {
        return ((FileAnnotationData)this.data).getAttachedFile();
    }

    public String getFileName() {
        return ((FileAnnotationData)this.data).getFileName();
    }

    public String getFilePath() {
        return ((FileAnnotationData)this.data).getFilePath();
    }

    public long getFileSize() {
        return ((FileAnnotationData)this.data).getFileSize();
    }

    public long getFileID() {
        return ((FileAnnotationData)this.data).getFileID();
    }

    public File getFile(Client client, String path) throws IOException, ServiceException, OMEROServerError {
        RawFileStorePrx store;
        File file = new File(path);
        try (FileOutputStream stream = new FileOutputStream(file);){
            String error = "Could not create RawFileService";
            store = ExceptionHandler.of(client, c -> this.writeFile((Client)c, stream)).handleServiceOrServer(error).rethrow(IOException.class).get();
        }
        if (store != null) {
            ExceptionHandler.ofConsumer(store, StatefulServiceInterfacePrx::close).rethrow(ServerError.class, OMEROServerError::new, "Could not close RawFileService").rethrow();
        }
        return file;
    }

    public String getContentAsString() {
        return ((FileAnnotationData)this.data).getContentAsString();
    }

    public boolean isMovieFile() {
        return ((FileAnnotationData)this.data).isMovieFile();
    }

    @Deprecated
    public FileAnnotationData asFileAnnotationData() {
        return (FileAnnotationData)this.data;
    }
}

