/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero;

import fr.igred.omero.Client;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.meta.ExperimenterWrapper;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import omero.gateway.model.DataObject;
import omero.model.IObject;

public abstract class GenericObjectWrapper<T extends DataObject> {
    protected T data;

    protected GenericObjectWrapper(T o) {
        this.data = o;
    }

    protected static <U extends DataObject, V extends GenericObjectWrapper<U>, W extends Comparable<W>> List<V> wrap(Collection<U> objects, Function<? super U, ? extends V> mapper, Function<? super V, ? extends W> sorter) {
        return objects.stream().map(mapper).sorted(Comparator.comparing(sorter)).collect(Collectors.toList());
    }

    protected static <U extends DataObject, V extends GenericObjectWrapper<U>> List<V> wrap(Collection<U> objects, Function<? super U, ? extends V> mapper) {
        return GenericObjectWrapper.wrap(objects, mapper, GenericObjectWrapper::getId);
    }

    public static <T extends GenericObjectWrapper<?>> List<T> distinct(Collection<? extends T> objects) {
        return objects.stream().collect(Collectors.toMap(GenericObjectWrapper::getId, o -> o, (o1, o2) -> o1)).values().stream().sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public static <U extends GenericObjectWrapper<?>> List<U> flatten(Collection<? extends Collection<? extends U>> lists) {
        return lists.stream().flatMap(Collection::stream).collect(Collectors.toMap(GenericObjectWrapper::getId, o -> o, (o1, o2) -> o1)).values().stream().sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public T asDataObject() {
        return this.data;
    }

    IObject asIObject() {
        return this.data.asIObject();
    }

    public long getId() {
        return this.data.getId();
    }

    public Timestamp getCreated() {
        return this.data.getCreated();
    }

    public Timestamp getUpdated() {
        return this.data.getUpdated();
    }

    public ExperimenterWrapper getOwner() {
        return new ExperimenterWrapper(this.data.getOwner());
    }

    public Long getGroupId() {
        return this.data.getGroupId();
    }

    public String toString() {
        return String.format("%s (id=%d)", this.getClass().getSimpleName(), this.data.getId());
    }

    public void saveAndUpdate(Client client) throws ExecutionException, ServiceException, AccessException {
        this.data = ExceptionHandler.call(client.getDm(), d -> d.saveAndReturnObject(client.getCtx(), this.data), "Cannot save and update object.");
    }

    public boolean canAnnotate() {
        return this.data.canAnnotate();
    }

    public boolean canEdit() {
        return this.data.canEdit();
    }

    public boolean canLink() {
        return this.data.canLink();
    }

    public boolean canDelete() {
        return this.data.canDelete();
    }

    public boolean canChgrp() {
        this.data.getPermissions().getPermissionsLevel();
        return this.data.canChgrp();
    }

    public boolean canChown() {
        return this.data.canChown();
    }
}

