/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero;

import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.meta.ExperimenterWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import ome.formats.OMEROMetadataStoreClient;
import omero.api.IQueryPrx;
import omero.gateway.Gateway;
import omero.gateway.LoginCredentials;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.AdminFacility;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.DataManagerFacility;
import omero.gateway.facility.MetadataFacility;
import omero.gateway.facility.ROIFacility;
import omero.gateway.facility.TablesFacility;
import omero.gateway.model.ExperimenterData;
import omero.log.Logger;
import omero.log.SimpleLogger;
import omero.model.FileAnnotationI;
import omero.model.IObject;

public abstract class GatewayWrapper {
    private final AtomicInteger storeUses = new AtomicInteger(0);
    private final Lock storeLock = new ReentrantLock(true);
    private Gateway gateway;
    private SecurityContext ctx;
    private ExperimenterWrapper user;

    protected GatewayWrapper(Gateway gateway, SecurityContext ctx, ExperimenterWrapper user) {
        this.gateway = gateway != null ? gateway : new Gateway((Logger)new SimpleLogger());
        this.user = user != null ? user : new ExperimenterWrapper(new ExperimenterData());
        this.ctx = ctx != null ? ctx : new SecurityContext(-1L);
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    private OMEROMetadataStoreClient getImportStoreLocked() throws DSOutOfServiceException {
        this.storeLock.lock();
        try {
            OMEROMetadataStoreClient oMEROMetadataStoreClient = this.gateway.getImportStore(this.ctx);
            return oMEROMetadataStoreClient;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private void closeImportStoreLocked() {
        if (this.storeLock.tryLock()) {
            try {
                this.gateway.closeImport(this.ctx, null);
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    public ExperimenterWrapper getUser() {
        return this.user;
    }

    public SecurityContext getCtx() {
        return this.ctx;
    }

    public long getId() {
        return this.user.getId();
    }

    public long getCurrentGroupId() {
        return this.ctx.getGroupID();
    }

    public String getSessionId() throws ServiceException {
        return ExceptionHandler.of(this.gateway, g -> g.getSessionId((ExperimenterData)this.user.asDataObject())).rethrow(DSOutOfServiceException.class, ServiceException::new, "Could not retrieve session ID").get();
    }

    public boolean isConnected() {
        return this.gateway.isConnected();
    }

    public void connect(String hostname, int port, String sessionId) throws ServiceException {
        this.connect(new LoginCredentials(sessionId, sessionId, hostname, port));
    }

    public void connect(String hostname, int port, String username, char[] password, Long groupID) throws ServiceException {
        LoginCredentials cred = new LoginCredentials(username, String.valueOf(password), hostname, port);
        cred.setGroupID(groupID.longValue());
        this.connect(cred);
    }

    public void connect(String hostname, int port, String username, char[] password) throws ServiceException {
        this.connect(new LoginCredentials(username, String.valueOf(password), hostname, port));
    }

    public void connect(LoginCredentials cred) throws ServiceException {
        this.disconnect();
        try {
            this.user = new ExperimenterWrapper(this.gateway.connect(cred));
        }
        catch (DSOutOfServiceException oos) {
            throw new ServiceException(oos, oos.getConnectionStatus());
        }
        this.ctx = new SecurityContext(this.user.getGroupId().longValue());
        this.ctx.setExperimenter((ExperimenterData)this.user.asDataObject());
        this.ctx.setServerInformation(cred.getServer());
    }

    public void disconnect() {
        if (this.isConnected()) {
            boolean sudo = this.ctx.isSudo();
            this.storeUses.set(0);
            this.closeImport();
            this.user = new ExperimenterWrapper(new ExperimenterData());
            this.ctx = new SecurityContext(-1L);
            this.ctx.setExperimenter((ExperimenterData)this.user.asDataObject());
            if (sudo) {
                this.gateway = new Gateway(this.gateway.getLogger());
            } else {
                this.gateway.disconnect();
            }
        }
    }

    public void switchGroup(long groupId) {
        boolean sudo = this.ctx.isSudo();
        this.ctx = new SecurityContext(groupId);
        this.ctx.setExperimenter((ExperimenterData)this.user.asDataObject());
        if (sudo) {
            this.ctx.sudo();
        }
    }

    public BrowseFacility getBrowseFacility() throws ExecutionException {
        return (BrowseFacility)this.gateway.getFacility(BrowseFacility.class);
    }

    public IQueryPrx getQueryService() throws ServiceException {
        return ExceptionHandler.of(this.gateway, g -> g.getQueryService(this.ctx)).rethrow(DSOutOfServiceException.class, ServiceException::new, "Could not retrieve Query Service").get();
    }

    public MetadataFacility getMetadata() throws ExecutionException {
        return (MetadataFacility)this.gateway.getFacility(MetadataFacility.class);
    }

    public DataManagerFacility getDm() throws ExecutionException {
        return (DataManagerFacility)this.gateway.getFacility(DataManagerFacility.class);
    }

    public ROIFacility getRoiFacility() throws ExecutionException {
        return (ROIFacility)this.gateway.getFacility(ROIFacility.class);
    }

    public TablesFacility getTablesFacility() throws ExecutionException {
        return (TablesFacility)this.gateway.getFacility(TablesFacility.class);
    }

    public AdminFacility getAdminFacility() throws ExecutionException {
        return (AdminFacility)this.gateway.getFacility(AdminFacility.class);
    }

    public OMEROMetadataStoreClient getImportStore() throws ServiceException {
        this.storeUses.incrementAndGet();
        return ExceptionHandler.of(this, GatewayWrapper::getImportStoreLocked).rethrow(DSOutOfServiceException.class, ServiceException::new, "Could not retrieve import store").get();
    }

    public void closeImport() {
        int remainingStores = this.storeUses.decrementAndGet();
        if (remainingStores <= 0) {
            this.closeImportStoreLocked();
        }
    }

    public List<IObject> findByQuery(String query) throws ServiceException, OMEROServerError {
        return ExceptionHandler.of(this.gateway, g -> g.getQueryService(this.ctx).findAllByQuery(query, null)).handleServiceOrServer("Query failed: " + query).get();
    }

    public IObject save(IObject object) throws ServiceException, AccessException, ExecutionException {
        return ExceptionHandler.call(this.getDm(), d -> d.saveAndReturnObject(this.ctx, object), "Cannot save object");
    }

    void delete(IObject object) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        long wait = 500L;
        ExceptionHandler.ofConsumer(this.getDm(), d -> d.delete(this.ctx, object).loop(10, 500L)).rethrow(InterruptedException.class).handleException("Cannot delete object").rethrow();
    }

    void delete(List<IObject> objects) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        long wait = 500L;
        ExceptionHandler.ofConsumer(this.getDm(), d -> d.delete(this.ctx, objects).loop(10, 500L)).rethrow(InterruptedException.class).handleException("Cannot delete objects").rethrow();
    }

    public void deleteFile(Long id) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.deleteFiles(id);
    }

    public void deleteFiles(Long ... ids) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        List<IObject> files = Arrays.stream(ids).map(id -> new FileAnnotationI(id.longValue(), false)).collect(Collectors.toList());
        this.delete(files);
    }

    public String toString() {
        String host = this.ctx.getServerInformation() != null ? this.ctx.getServerInformation().getHost() : "null";
        return String.format("%s{host=%s, groupID=%d, userID=%d, connected=%b}", this.getClass().getSimpleName(), host, this.ctx.getGroupID(), this.user.getId(), this.gateway.isConnected());
    }
}

