/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero;

import fr.igred.omero.Browser;
import fr.igred.omero.GatewayWrapper;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.annotations.GenericAnnotationWrapper;
import fr.igred.omero.annotations.TableWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.meta.ExperimenterWrapper;
import fr.igred.omero.meta.GroupWrapper;
import fr.igred.omero.repository.FolderWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.ProjectWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.ApiUsageException;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;

public class Client
extends Browser {
    public Client() {
        this(null, null, null);
    }

    public Client(Gateway gateway, SecurityContext ctx, ExperimenterWrapper user) {
        super(gateway, ctx, user);
    }

    @Override
    public List<ImageWrapper> getImages(String projectName, String datasetName, String imageName) throws ServiceException, AccessException, ExecutionException {
        List<ProjectWrapper> projects = this.getProjects(projectName);
        ArrayList<List<ImageWrapper>> lists = new ArrayList<List<ImageWrapper>>(projects.size());
        for (ProjectWrapper project : projects) {
            lists.add(project.getImages(this, datasetName, imageName));
        }
        return GenericObjectWrapper.flatten(lists);
    }

    @Override
    public List<ImageWrapper> getImages(GenericAnnotationWrapper<?> annotation) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        return annotation.getImages(this);
    }

    @Override
    @Deprecated
    public List<ImageWrapper> getImagesKey(String key) throws ServiceException, AccessException, ExecutionException {
        List<ImageWrapper> images = this.getImages();
        ArrayList<ImageWrapper> selected = new ArrayList<ImageWrapper>(images.size());
        for (ImageWrapper image : images) {
            Map<String, String> pairsKeyValue = image.getKeyValuePairs(this);
            if (pairsKeyValue.get(key) == null) continue;
            selected.add(image);
        }
        return selected;
    }

    @Override
    @Deprecated
    public List<ImageWrapper> getImagesPairKeyValue(String key, String value) throws ServiceException, AccessException, ExecutionException {
        List<ImageWrapper> images = this.getImages();
        ArrayList<ImageWrapper> selected = new ArrayList<ImageWrapper>(images.size());
        for (ImageWrapper image : images) {
            Map<String, String> pairsKeyValue = image.getKeyValuePairs(this);
            if (pairsKeyValue.get(key) == null || !pairsKeyValue.get(key).equals(value)) continue;
            selected.add(image);
        }
        return selected;
    }

    public void delete(Collection<? extends GenericObjectWrapper<?>> objects) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        for (GenericObjectWrapper<?> object : objects) {
            if (!(object instanceof FolderWrapper)) continue;
            ((FolderWrapper)object).unlinkAllROIs(this);
        }
        if (!objects.isEmpty()) {
            ((GatewayWrapper)this).delete(objects.stream().map(GenericObjectWrapper::asIObject).collect(Collectors.toList()));
        }
    }

    public void delete(GenericObjectWrapper<?> object) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        if (object instanceof FolderWrapper) {
            ((FolderWrapper)object).unlinkAllROIs(this);
        }
        this.delete(object.asIObject());
    }

    @Deprecated
    public void delete(TableWrapper table) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.deleteTable(table);
    }

    public void deleteTable(TableWrapper table) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.deleteFile(table.getId());
    }

    public void deleteTables(Collection<? extends TableWrapper> tables) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.deleteFiles((Long[])tables.stream().map(TableWrapper::getId).toArray(Long[]::new));
    }

    public ExperimenterWrapper getUser(String username) throws ExecutionException, ServiceException, AccessException {
        ExperimenterData user = ExceptionHandler.call(this.getAdminFacility(), a -> a.lookupExperimenter(this.getCtx(), username), "Cannot retrieve user: " + username);
        if (user != null) {
            return new ExperimenterWrapper(user);
        }
        String msg = String.format("User not found: %s", username);
        throw new NoSuchElementException(msg);
    }

    public ExperimenterWrapper getUser(long userId) throws ServiceException, OMEROServerError {
        Experimenter user = ExceptionHandler.of(this.getGateway(), g -> g.getAdminService(this.getCtx()).getExperimenter(userId)).rethrow(ApiUsageException.class, (m, e) -> new NoSuchElementException(m), "User not found: " + userId).handleServiceOrServer("Cannot retrieve user: " + userId).get();
        return new ExperimenterWrapper(new ExperimenterData(user));
    }

    public GroupWrapper getGroup(String groupName) throws ExecutionException, ServiceException, AccessException {
        GroupData group = ExceptionHandler.call(this.getAdminFacility(), a -> a.lookupGroup(this.getCtx(), groupName), "Cannot retrieve group: " + groupName);
        if (group != null) {
            return new GroupWrapper(group);
        }
        String msg = String.format("Group not found: %s", groupName);
        throw new NoSuchElementException(msg);
    }

    public GroupWrapper getGroup(long groupId) throws ServiceException, OMEROServerError {
        ExperimenterGroup group = ExceptionHandler.of(this.getGateway(), g -> g.getAdminService(this.getCtx()).getGroup(groupId)).rethrow(ApiUsageException.class, (m, e) -> new NoSuchElementException(m), "Group not found: " + groupId).handleServiceOrServer("Cannot retrieve group: " + groupId).get();
        return new GroupWrapper(new GroupData(group));
    }

    public List<GroupWrapper> getGroups() throws ServiceException, AccessException {
        String error = "Cannot retrieve the groups on OMERO";
        List groups = ExceptionHandler.call(this.getGateway(), g -> g.getAdminService(this.getCtx()).lookupGroups(), error);
        return groups.stream().filter(Objects::nonNull).map(GroupData::new).map(GroupWrapper::new).collect(Collectors.toList());
    }

    public Client sudoGetUser(String username) throws ServiceException, AccessException, ExecutionException {
        ExperimenterWrapper sudoUser = this.getUser(username);
        long groupId = sudoUser.getDefaultGroup().getId();
        SecurityContext context = new SecurityContext(groupId);
        context.setExperimenter((ExperimenterData)sudoUser.asDataObject());
        context.sudo();
        return new Client(this.getGateway(), context, sudoUser);
    }
}

