/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero;

import fr.igred.omero.GatewayWrapper;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.annotations.GenericAnnotationWrapper;
import fr.igred.omero.annotations.MapAnnotationWrapper;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.meta.ExperimenterWrapper;
import fr.igred.omero.repository.DatasetWrapper;
import fr.igred.omero.repository.FolderWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.PlateWrapper;
import fr.igred.omero.repository.ProjectWrapper;
import fr.igred.omero.repository.ScreenWrapper;
import fr.igred.omero.repository.WellWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.RLong;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.TagAnnotationData;
import omero.model.IObject;
import omero.model.MapAnnotation;
import omero.model.TagAnnotation;

public abstract class Browser
extends GatewayWrapper {
    protected Browser(Gateway gateway, SecurityContext ctx, ExperimenterWrapper user) {
        super(gateway, ctx, user);
    }

    public ProjectWrapper getProject(Long id) throws ServiceException, AccessException, ExecutionException {
        List<ProjectWrapper> projects = this.getProjects(id);
        if (projects.isEmpty()) {
            String msg = String.format("Project %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return projects.iterator().next();
    }

    public List<ProjectWrapper> getProjects(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        Collection projects = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getProjects(this.getCtx(), Arrays.asList(ids)), "Cannot get projects with IDs: " + Arrays.toString((Object[])ids));
        return GenericObjectWrapper.wrap(projects, ProjectWrapper::new);
    }

    public List<ProjectWrapper> getProjects() throws ServiceException, AccessException, ExecutionException {
        Collection projects = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getProjects(this.getCtx()), "Cannot get projects");
        return GenericObjectWrapper.wrap(projects, ProjectWrapper::new);
    }

    public List<ProjectWrapper> getProjects(ExperimenterWrapper experimenter) throws ServiceException, AccessException, ExecutionException {
        long exId = experimenter.getId();
        Collection projects = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getProjects(this.getCtx(), exId), "Cannot get projects for user " + experimenter);
        return GenericObjectWrapper.wrap(projects, ProjectWrapper::new);
    }

    public List<ProjectWrapper> getProjects(String name) throws ServiceException, AccessException, ExecutionException {
        Collection projects = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getProjects(this.getCtx(), name), "Cannot get projects with name: " + name);
        return GenericObjectWrapper.wrap(projects, ProjectWrapper::new);
    }

    public DatasetWrapper getDataset(Long id) throws ServiceException, AccessException, ExecutionException {
        List<DatasetWrapper> datasets = this.getDatasets(id);
        if (datasets.isEmpty()) {
            String msg = String.format("Dataset %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return datasets.iterator().next();
    }

    public List<DatasetWrapper> getDatasets(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        Collection datasets = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getDatasets(this.getCtx(), Arrays.asList(ids)), "Cannot get datasets with IDs: " + Arrays.toString((Object[])ids));
        return GenericObjectWrapper.wrap(datasets, DatasetWrapper::new);
    }

    public List<DatasetWrapper> getDatasets() throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        Long[] ids = (Long[])this.findByQuery("select d from Dataset d").stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return this.getDatasets(ids);
    }

    public List<DatasetWrapper> getDatasets(ExperimenterWrapper experimenter) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        String template = "select d from Dataset d where d.details.owner.id=%d";
        String query = String.format(template, experimenter.getId());
        Long[] ids = (Long[])this.findByQuery(query).stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return this.getDatasets(ids);
    }

    public List<DatasetWrapper> getDatasets(String name) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get datasets with name: " + name;
        Collection datasets = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getDatasets(this.getCtx(), name), error);
        return GenericObjectWrapper.wrap(datasets, DatasetWrapper::new);
    }

    public List<DatasetWrapper> getOrphanedDatasets(ExperimenterWrapper experimenter) throws ServiceException, ExecutionException, OMEROServerError, AccessException {
        String template = "select dataset from Dataset as dataset join fetch dataset.details.owner as o where o.id = %d and not exists (select obl from ProjectDatasetLink as obl where obl.child = dataset.id)";
        String query = String.format(template, experimenter.getId());
        Long[] ids = (Long[])this.findByQuery(query).stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return this.getDatasets(ids);
    }

    public List<DatasetWrapper> getOrphanedDatasets() throws ServiceException, ExecutionException, OMEROServerError, AccessException {
        return this.getOrphanedDatasets(this.getUser());
    }

    public ImageWrapper getImage(Long id) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get image with ID: " + id;
        ImageData image = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getImage(this.getCtx(), id.longValue()), error);
        if (image == null) {
            String msg = String.format("Image %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return new ImageWrapper(image);
    }

    public List<ImageWrapper> getImages(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get images with IDs: " + Arrays.toString((Object[])ids);
        Collection images = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getImages(this.getCtx(), Arrays.asList(ids)), error);
        return GenericObjectWrapper.wrap(images, ImageWrapper::new);
    }

    public List<ImageWrapper> getImages() throws ServiceException, AccessException, ExecutionException {
        Collection images = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getUserImages(this.getCtx()), "Cannot get images");
        return GenericObjectWrapper.wrap(images, ImageWrapper::new);
    }

    public List<ImageWrapper> getImages(String name) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get images with name: " + name;
        Collection images = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getImages(this.getCtx(), name), error);
        images.removeIf(image -> !image.getName().equals(name));
        return GenericObjectWrapper.wrap(images, ImageWrapper::new);
    }

    public List<ImageWrapper> getOrphanedImages(ExperimenterWrapper experimenter) throws ServiceException, AccessException, ExecutionException {
        long exId = experimenter.getId();
        Collection images = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getOrphanedImages(this.getCtx(), exId), "Cannot get orphaned images");
        return GenericObjectWrapper.wrap(images, ImageWrapper::new);
    }

    public List<ImageWrapper> getOrphanedImages() throws ServiceException, AccessException, ExecutionException {
        return this.getOrphanedImages(this.getUser());
    }

    public abstract List<ImageWrapper> getImages(String var1, String var2, String var3) throws ServiceException, AccessException, ExecutionException;

    public abstract List<ImageWrapper> getImages(GenericAnnotationWrapper<?> var1) throws ServiceException, AccessException, OMEROServerError, ExecutionException;

    public List<ImageWrapper> getImagesLike(String motif) throws ServiceException, AccessException, ExecutionException {
        List<ImageWrapper> images = this.getImages();
        String regexp = ".*" + motif + ".*";
        images.removeIf(image -> !image.getName().matches(regexp));
        return images;
    }

    @Deprecated
    public List<ImageWrapper> getImagesTagged(TagAnnotationWrapper tag) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        return this.getImages(tag);
    }

    @Deprecated
    public List<ImageWrapper> getImagesTagged(Long tagId) throws ServiceException, AccessException, OMEROServerError, ExecutionException {
        return this.getImagesTagged(this.getTag(tagId));
    }

    @Deprecated
    public abstract List<ImageWrapper> getImagesKey(String var1) throws ServiceException, AccessException, ExecutionException;

    public List<ImageWrapper> getImagesWithKey(String key) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        List<MapAnnotationWrapper> maps = this.getMapAnnotations(key);
        ArrayList<List<ImageWrapper>> selected = new ArrayList<List<ImageWrapper>>(maps.size());
        for (MapAnnotationWrapper map : maps) {
            selected.add(this.getImages(map));
        }
        return GenericObjectWrapper.flatten(selected);
    }

    @Deprecated
    public abstract List<ImageWrapper> getImagesPairKeyValue(String var1, String var2) throws ServiceException, AccessException, ExecutionException;

    public List<ImageWrapper> getImagesWithKeyValuePair(String key, String value) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        List<MapAnnotationWrapper> maps = this.getMapAnnotations(key, value);
        ArrayList<List<ImageWrapper>> selected = new ArrayList<List<ImageWrapper>>(maps.size());
        for (MapAnnotationWrapper map : maps) {
            selected.add(this.getImages(map));
        }
        return GenericObjectWrapper.flatten(selected);
    }

    public ScreenWrapper getScreen(Long id) throws ServiceException, AccessException, ExecutionException {
        List<ScreenWrapper> screens = this.getScreens(id);
        if (screens.isEmpty()) {
            String msg = String.format("Screen %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return screens.iterator().next();
    }

    public List<ScreenWrapper> getScreens(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        Collection screens = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getScreens(this.getCtx(), Arrays.asList(ids)), "Cannot get screens with IDs: " + Arrays.toString((Object[])ids));
        return GenericObjectWrapper.wrap(screens, ScreenWrapper::new);
    }

    public List<ScreenWrapper> getScreens() throws ServiceException, AccessException, ExecutionException {
        Collection screens = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getScreens(this.getCtx()), "Cannot get screens");
        return GenericObjectWrapper.wrap(screens, ScreenWrapper::new);
    }

    public List<ScreenWrapper> getScreens(ExperimenterWrapper experimenter) throws ServiceException, AccessException, ExecutionException {
        String error = String.format("Cannot get screens for user %s", experimenter);
        long exId = experimenter.getId();
        Collection screens = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getScreens(this.getCtx(), exId), error);
        return GenericObjectWrapper.wrap(screens, ScreenWrapper::new);
    }

    public PlateWrapper getPlate(Long id) throws ServiceException, AccessException, ExecutionException {
        List<PlateWrapper> plates = this.getPlates(id);
        if (plates.isEmpty()) {
            String msg = String.format("Plate %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return plates.iterator().next();
    }

    public List<PlateWrapper> getPlates(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        Collection plates = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getPlates(this.getCtx(), Arrays.asList(ids)), "Cannot get plates with IDs: " + Arrays.toString((Object[])ids));
        return GenericObjectWrapper.wrap(plates, PlateWrapper::new);
    }

    public List<PlateWrapper> getPlates() throws ServiceException, AccessException, ExecutionException {
        Collection plates = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getPlates(this.getCtx()), "Cannot get plates");
        return GenericObjectWrapper.wrap(plates, PlateWrapper::new);
    }

    public List<PlateWrapper> getPlates(ExperimenterWrapper experimenter) throws ServiceException, AccessException, ExecutionException {
        long exId = experimenter.getId();
        Collection plates = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getPlates(this.getCtx(), exId), "Cannot get plates for user " + experimenter);
        return GenericObjectWrapper.wrap(plates, PlateWrapper::new);
    }

    public List<PlateWrapper> getOrphanedPlates(ExperimenterWrapper experimenter) throws ServiceException, ExecutionException, OMEROServerError, AccessException {
        String template = "select plate from Plate as plate join fetch plate.details.owner as o where o.id = %d and not exists (select obl from ScreenPlateLink as obl where obl.child = plate.id)";
        String query = String.format(template, experimenter.getId());
        Long[] ids = (Long[])this.findByQuery(query).stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return this.getPlates(ids);
    }

    public List<PlateWrapper> getOrphanedPlates() throws ServiceException, ExecutionException, OMEROServerError, AccessException {
        return this.getOrphanedPlates(this.getUser());
    }

    public WellWrapper getWell(Long id) throws ServiceException, AccessException, ExecutionException {
        List<WellWrapper> wells = this.getWells(id);
        if (wells.isEmpty()) {
            String msg = String.format("Plate %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return wells.iterator().next();
    }

    public List<WellWrapper> getWells(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        Collection wells = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.getWells(this.getCtx(), Arrays.asList(ids)), "Cannot get wells with IDs: " + Arrays.toString((Object[])ids));
        return GenericObjectWrapper.wrap(wells, WellWrapper::new);
    }

    public List<WellWrapper> getWells() throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        Long[] ids = (Long[])this.findByQuery("select w from Well w").stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return this.getWells(ids);
    }

    public List<WellWrapper> getWells(ExperimenterWrapper experimenter) throws ServiceException, AccessException, ExecutionException, OMEROServerError {
        String template = "select w from Well w where w.details.owner.id=%d";
        String query = String.format(template, experimenter.getId());
        Long[] ids = (Long[])this.findByQuery(query).stream().map(IObject::getId).map(RLong::getValue).toArray(Long[]::new);
        return this.getWells(ids);
    }

    public FolderWrapper getFolder(long id) throws ServiceException, AccessException, ExecutionException {
        List<FolderWrapper> folders = this.loadFolders(id);
        if (folders.isEmpty()) {
            String msg = String.format("Folder %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        return folders.iterator().next();
    }

    public List<FolderWrapper> getFolders() throws ExecutionException, AccessException, ServiceException {
        Collection folders = ExceptionHandler.call(this.getBrowseFacility(), b -> b.getFolders(this.getCtx()), "Cannot get folders");
        return GenericObjectWrapper.wrap(folders, FolderWrapper::new);
    }

    public List<FolderWrapper> getFolders(ExperimenterWrapper experimenter) throws ExecutionException, AccessException, ServiceException {
        String error = String.format("Cannot get folders for user %s", experimenter);
        long exId = experimenter.getId();
        Collection folders = ExceptionHandler.call(this.getBrowseFacility(), b -> b.getFolders(this.getCtx(), exId), error);
        return GenericObjectWrapper.wrap(folders, FolderWrapper::new);
    }

    public List<FolderWrapper> loadFolders(Long ... ids) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot get folders with IDs: " + Arrays.toString((Object[])ids);
        Collection folders = ExceptionHandler.call(this.getBrowseFacility(), bf -> bf.loadFolders(this.getCtx(), Arrays.asList(ids)), error);
        return GenericObjectWrapper.wrap(folders, FolderWrapper::new);
    }

    public List<TagAnnotationWrapper> getTags() throws OMEROServerError, ServiceException {
        String klass = TagAnnotation.class.getSimpleName();
        List os = ExceptionHandler.of(this.getGateway(), g -> g.getQueryService(this.getCtx()).findAll(klass, null)).handleServiceOrServer("Cannot get tags").get();
        return os.stream().map(TagAnnotation.class::cast).map(TagAnnotationData::new).map(TagAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public List<TagAnnotationWrapper> getTags(String name) throws OMEROServerError, ServiceException {
        List<TagAnnotationWrapper> tags = this.getTags();
        tags.removeIf(tag -> !tag.getName().equals(name));
        tags.sort(Comparator.comparing(GenericObjectWrapper::getId));
        return tags;
    }

    public TagAnnotationWrapper getTag(Long id) throws OMEROServerError, ServiceException {
        String klass = TagAnnotation.class.getSimpleName();
        IObject o = ExceptionHandler.of(this.getGateway(), g -> g.getQueryService(this.getCtx()).find(klass, id.longValue())).handleServiceOrServer("Cannot get tag ID: " + id).get();
        if (o == null) {
            String msg = String.format("Tag %d doesn't exist in this context", id);
            throw new NoSuchElementException(msg);
        }
        TagAnnotationData tag = new TagAnnotationData((TagAnnotation)Objects.requireNonNull(o));
        return new TagAnnotationWrapper(tag);
    }

    public List<MapAnnotationWrapper> getMapAnnotations() throws OMEROServerError, ServiceException {
        String klass = MapAnnotation.class.getSimpleName();
        return ExceptionHandler.of(this.getGateway(), g -> g.getQueryService(this.getCtx()).findAll(klass, null)).handleServiceOrServer("Cannot get map annotations").get().stream().map(MapAnnotation.class::cast).map(MapAnnotationData::new).map(MapAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public List<MapAnnotationWrapper> getMapAnnotations(String key) throws OMEROServerError, ServiceException {
        String template = "select m from MapAnnotation as m join m.mapValue as mv where mv.name = '%s'";
        String q = String.format(template, key);
        return this.findByQuery(q).stream().map(MapAnnotation.class::cast).map(MapAnnotationData::new).map(MapAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public List<MapAnnotationWrapper> getMapAnnotations(String key, String value) throws OMEROServerError, ServiceException {
        String template = "select m from MapAnnotation as m join m.mapValue as mv where mv.name = '%s' and mv.value = '%s'";
        String q = String.format(template, key, value);
        return this.findByQuery(q).stream().map(MapAnnotation.class::cast).map(MapAnnotationData::new).map(MapAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public MapAnnotationWrapper getMapAnnotation(Long id) throws ServiceException, ExecutionException, AccessException {
        MapAnnotationData kv = ExceptionHandler.of(this.getBrowseFacility(), b -> (MapAnnotationData)b.findObject(this.getCtx(), MapAnnotationData.class, id.longValue())).handleServiceOrAccess("Cannot get map annotation with ID: " + id).get();
        return new MapAnnotationWrapper(kv);
    }
}

