/*
 * Decompiled with CFR 0.152.
 */
package fr.igred.omero;

import fr.igred.omero.Client;
import fr.igred.omero.GatewayWrapper;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.annotations.AnnotationList;
import fr.igred.omero.annotations.FileAnnotationWrapper;
import fr.igred.omero.annotations.GenericAnnotationWrapper;
import fr.igred.omero.annotations.MapAnnotationWrapper;
import fr.igred.omero.annotations.RatingAnnotationWrapper;
import fr.igred.omero.annotations.TableWrapper;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ExceptionHandler;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import omero.gateway.facility.TablesFacility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.TableData;
import omero.gateway.model.TagAnnotationData;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.sys.Parameters;
import omero.sys.ParametersI;

public abstract class AnnotatableWrapper<T extends DataObject>
extends GenericObjectWrapper<T> {
    protected AnnotatableWrapper(T o) {
        super(o);
    }

    protected abstract String annotationLinkType();

    public <A extends GenericAnnotationWrapper<?>> boolean isLinked(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        return this.getAnnotations(client).stream().anyMatch(a -> a.getId() == annotation.getId());
    }

    protected <A extends AnnotationData> void link(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        String error = String.format("Cannot add %s to %s", annotation, this);
        ExceptionHandler.call(client.getDm(), d -> d.attachAnnotation(client.getCtx(), annotation, this.data), error);
    }

    public <A extends GenericAnnotationWrapper<?>> void link(Client client, A annotation) throws ServiceException, AccessException, ExecutionException {
        if (annotation instanceof TagAnnotationWrapper && ((TagAnnotationWrapper)annotation).isTagSet()) {
            String msg = "Tag sets should only be linked to tags";
            throw new IllegalArgumentException(msg);
        }
        this.link(client, (AnnotationData)annotation.asDataObject());
    }

    public void link(Client client, GenericAnnotationWrapper<?> ... annotations) throws ServiceException, AccessException, ExecutionException {
        for (GenericAnnotationWrapper<?> annotation : annotations) {
            this.link(client, (A)annotation);
        }
    }

    public void linkIfNotLinked(Client client, GenericAnnotationWrapper<?> ... annotations) throws ServiceException, AccessException, ExecutionException {
        List annotationIds = this.getAnnotationData(client).stream().map(DataObject::getId).collect(Collectors.toList());
        this.link(client, (GenericAnnotationWrapper[])Arrays.stream(annotations).filter(a -> !annotationIds.contains(a.getId())).toArray(GenericAnnotationWrapper[]::new));
    }

    public void addTag(Client client, String name, String description) throws ServiceException, AccessException, ExecutionException {
        TagAnnotationWrapper tag = new TagAnnotationWrapper(new TagAnnotationData(name));
        tag.setDescription(description);
        this.link(client, (A)tag);
    }

    @Deprecated
    public void addTag(Client client, TagAnnotationWrapper tag) throws ServiceException, AccessException, ExecutionException {
        this.link(client, (A)tag);
    }

    public void addTag(Client client, Long id) throws ServiceException, AccessException, ExecutionException {
        TagAnnotationI tag = new TagAnnotationI(id.longValue(), false);
        TagAnnotationData tagData = new TagAnnotationData((TagAnnotation)tag);
        this.link(client, tagData);
    }

    @Deprecated
    public void addTags(Client client, TagAnnotationWrapper ... tags) throws ServiceException, AccessException, ExecutionException {
        this.link(client, tags);
    }

    public void addTags(Client client, Long ... ids) throws ServiceException, AccessException, ExecutionException {
        for (Long id : ids) {
            this.addTag(client, id);
        }
    }

    public List<TagAnnotationWrapper> getTags(Client client) throws ServiceException, AccessException, ExecutionException {
        List<Class<TagAnnotationData>> types = Collections.singletonList(TagAnnotationData.class);
        List annotations = ExceptionHandler.call(client.getMetadata(), m -> m.getAnnotations(client.getCtx(), this.data, types, null), "Cannot get tags for " + this);
        return annotations.stream().filter(TagAnnotationData.class::isInstance).map(TagAnnotationData.class::cast).map(TagAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public List<MapAnnotationWrapper> getMapAnnotations(Client client) throws ServiceException, AccessException, ExecutionException {
        List<Class<MapAnnotationData>> types = Collections.singletonList(MapAnnotationData.class);
        List annotations = ExceptionHandler.call(client.getMetadata(), m -> m.getAnnotations(client.getCtx(), this.data, types, null), "Cannot get map annotations for " + this);
        return annotations.stream().filter(MapAnnotationData.class::isInstance).map(MapAnnotationData.class::cast).map(MapAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    @Deprecated
    public void addPairKeyValue(Client client, String key, String value) throws ServiceException, AccessException, ExecutionException {
        this.addKeyValuePair(client, key, value);
    }

    public void addKeyValuePair(Client client, String key, String value) throws ServiceException, AccessException, ExecutionException {
        MapAnnotationWrapper pkv = new MapAnnotationWrapper(key, value);
        this.link(client, (A)pkv);
    }

    public Map<String, String> getKeyValuePairs(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getMapAnnotations(client).stream().map(MapAnnotationWrapper::getContent).flatMap(Collection::stream).collect(Collectors.toMap(nv -> nv.name, nv -> nv.value));
    }

    @Deprecated
    public List<Map.Entry<String, String>> getKeyValuePairsAsList(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getMapAnnotations(client).stream().map(MapAnnotationWrapper::getContentAsEntryList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getValue(Client client, String key) throws ServiceException, AccessException, ExecutionException {
        Map<String, String> keyValuePairs = this.getKeyValuePairs(client);
        String value = keyValuePairs.get(key);
        if (value != null) {
            return value;
        }
        throw new NoSuchElementException("Key \"" + key + "\" not found");
    }

    private List<RatingAnnotationWrapper> getRatings(Client client, List<Long> userIds) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot retrieve rating annotations from " + this;
        List<Class<RatingAnnotationData>> types = Collections.singletonList(RatingAnnotationData.class);
        List annotations = ExceptionHandler.call(client.getMetadata(), m -> m.getAnnotations(client.getCtx(), this.data, types, userIds), error);
        annotations = annotations == null ? Collections.emptyList() : annotations;
        return annotations.stream().filter(RatingAnnotationData.class::isInstance).map(RatingAnnotationData.class::cast).map(RatingAnnotationWrapper::new).sorted(Comparator.comparing(GenericObjectWrapper::getId)).collect(Collectors.toList());
    }

    public List<RatingAnnotationWrapper> getRatings(Client client) throws ServiceException, AccessException, ExecutionException {
        return this.getRatings(client, null);
    }

    public void rate(Client client, int rating) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        List<Long> userIds = Collections.singletonList(client.getCtx().getExperimenter());
        List<RatingAnnotationWrapper> ratings = this.getRatings(client, userIds);
        if (ratings.isEmpty()) {
            RatingAnnotationWrapper rate = new RatingAnnotationWrapper(rating);
            this.link(client, (A)rate);
        } else {
            int n = ratings.size();
            if (n > 1) {
                client.delete((Collection<? extends GenericObjectWrapper<?>>)ratings.subList(1, n));
            }
            RatingAnnotationWrapper rate = ratings.get(0);
            rate.setRating(rating);
            rate.saveAndUpdate(client);
        }
    }

    public int getMyRating(Client client) throws ServiceException, AccessException, ExecutionException {
        List<Long> userIds = Collections.singletonList(client.getCtx().getExperimenter());
        List<RatingAnnotationWrapper> ratings = this.getRatings(client, userIds);
        int score = 0;
        for (RatingAnnotationWrapper rate : ratings) {
            score += rate.getRating();
        }
        return score / Math.max(1, ratings.size());
    }

    @Deprecated
    public void addMapAnnotation(Client client, MapAnnotationWrapper mapAnnotation) throws ServiceException, AccessException, ExecutionException {
        this.link(client, (A)mapAnnotation);
    }

    public void addTable(Client client, TableWrapper table) throws ServiceException, AccessException, ExecutionException {
        String error = "Cannot add table to " + this;
        TablesFacility tablesFacility = client.getTablesFacility();
        TableData tableData = ExceptionHandler.call(tablesFacility, tf -> tf.addTable(client.getCtx(), this.data, table.getName(), table.createTable()), error);
        Collection tables = ExceptionHandler.call(tablesFacility, tf -> tf.getAvailableTables(client.getCtx(), this.data), error);
        long fileId = tableData.getOriginalFileId();
        long id = tables.stream().filter(v -> v.getFileID() == fileId).mapToLong(DataObject::getId).max().orElse(-1L);
        table.setId(id);
        table.setFileId(tableData.getOriginalFileId());
    }

    public void addAndReplaceTable(Client client, TableWrapper table, GenericRepositoryObjectWrapper.ReplacePolicy policy) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        String error = "Cannot add table to " + this;
        List<FileAnnotationWrapper> tables = AnnotatableWrapper.wrap(ExceptionHandler.call(client.getTablesFacility(), t -> t.getAvailableTables(client.getCtx(), this.data), error), FileAnnotationWrapper::new);
        this.addTable(client, table);
        tables.removeIf(t -> !t.getDescription().equals(table.getName()));
        this.unlink(client, tables);
        for (FileAnnotationWrapper fileAnnotation : tables) {
            if (policy != GenericRepositoryObjectWrapper.ReplacePolicy.DELETE && (policy != GenericRepositoryObjectWrapper.ReplacePolicy.DELETE_ORPHANED || fileAnnotation.countAnnotationLinks(client) != 0)) continue;
            client.deleteFile(fileAnnotation.getId());
        }
    }

    public void addAndReplaceTable(Client client, TableWrapper table) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.addAndReplaceTable(client, table, GenericRepositoryObjectWrapper.ReplacePolicy.DELETE_ORPHANED);
    }

    public TableWrapper getTable(Client client, Long fileId) throws ServiceException, AccessException, ExecutionException {
        TableData info = ExceptionHandler.call(client.getTablesFacility(), tf -> tf.getTableInfo(client.getCtx(), fileId.longValue()), "Cannot get table from " + this);
        long nRows = info.getNumberOfRows();
        TableData table = ExceptionHandler.call(client.getTablesFacility(), tf -> tf.getTable(client.getCtx(), fileId.longValue(), 0L, nRows - 1L, new int[0]), "Cannot get table from " + this);
        String name = ExceptionHandler.call(client.getTablesFacility(), tf -> tf.getAvailableTables(client.getCtx(), this.data).stream().filter(t -> t.getFileID() == fileId.longValue()).map(FileAnnotationData::getDescription).findFirst().orElse(null), "Cannot get table name from " + this);
        TableWrapper result = new TableWrapper(Objects.requireNonNull(table));
        result.setName(name);
        return result;
    }

    public List<TableWrapper> getTables(Client client) throws ServiceException, AccessException, ExecutionException {
        Collection tables = ExceptionHandler.call(client.getTablesFacility(), tf -> tf.getAvailableTables(client.getCtx(), this.data), "Cannot get tables from " + this);
        ArrayList<TableWrapper> tablesWrapper = new ArrayList<TableWrapper>(tables.size());
        for (FileAnnotationData table : tables) {
            TableWrapper tableWrapper = this.getTable(client, table.getFileID());
            tableWrapper.setId(table.getId());
            tablesWrapper.add(tableWrapper);
        }
        return tablesWrapper;
    }

    public long addFile(Client client, File file) throws ExecutionException, InterruptedException {
        return ((FileAnnotationData)client.getDm().attachFile(client.getCtx(), file, null, "", file.getName(), this.data).get()).getId();
    }

    public long addAndReplaceFile(Client client, File file, GenericRepositoryObjectWrapper.ReplacePolicy policy) throws ExecutionException, InterruptedException, AccessException, ServiceException, OMEROServerError {
        List<FileAnnotationWrapper> files = this.getFileAnnotations(client);
        FileAnnotationData uploaded = (FileAnnotationData)client.getDm().attachFile(client.getCtx(), file, null, "", file.getName(), this.data).get();
        FileAnnotationWrapper annotation = new FileAnnotationWrapper(uploaded);
        files.removeIf(fileAnnotation -> !fileAnnotation.getFileName().equals(annotation.getFileName()));
        for (FileAnnotationWrapper fileAnnotation2 : files) {
            this.unlink(client, fileAnnotation2);
            if (policy != GenericRepositoryObjectWrapper.ReplacePolicy.DELETE && (policy != GenericRepositoryObjectWrapper.ReplacePolicy.DELETE_ORPHANED || fileAnnotation2.countAnnotationLinks(client) != 0)) continue;
            client.deleteFile(fileAnnotation2.getId());
        }
        return annotation.getFileID();
    }

    public long addAndReplaceFile(Client client, File file) throws ExecutionException, InterruptedException, AccessException, ServiceException, OMEROServerError {
        return this.addAndReplaceFile(client, file, GenericRepositoryObjectWrapper.ReplacePolicy.DELETE_ORPHANED);
    }

    @Deprecated
    public void addFileAnnotation(Client client, FileAnnotationWrapper annotation) throws AccessException, ServiceException, ExecutionException {
        this.link(client, (A)annotation);
    }

    public List<FileAnnotationWrapper> getFileAnnotations(Client client) throws ExecutionException, ServiceException, AccessException {
        String error = "Cannot retrieve file annotations from " + this;
        List<Class<FileAnnotationData>> types = Collections.singletonList(FileAnnotationData.class);
        List annotations = ExceptionHandler.call(client.getMetadata(), m -> m.getAnnotations(client.getCtx(), this.data, types, null), error);
        return annotations.stream().filter(FileAnnotationData.class::isInstance).map(FileAnnotationData.class::cast).map(FileAnnotationWrapper::new).collect(Collectors.toList());
    }

    public <A extends GenericAnnotationWrapper<?>> void unlink(Client client, A annotation) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.removeLink(client, this.annotationLinkType(), annotation.getId());
    }

    public <A extends GenericAnnotationWrapper<?>> void unlink(Client client, Collection<A> annotations) throws ServiceException, AccessException, ExecutionException, OMEROServerError, InterruptedException {
        this.removeLinks(client, this.annotationLinkType(), annotations.stream().map(GenericObjectWrapper::getId).collect(Collectors.toList()));
    }

    protected void removeLinks(Client client, String linkType, Collection<Long> childIds) throws ServiceException, OMEROServerError, AccessException, ExecutionException, InterruptedException {
        String template = "select link from %s link where link.parent = %d and link.child.id in (:ids)";
        String query = String.format(template, linkType, this.getId());
        ParametersI param = new ParametersI();
        param.addIds(childIds);
        List os = ExceptionHandler.call(client.getGateway(), g -> g.getQueryService(client.getCtx()).findAllByQuery(query, (Parameters)param), "Cannot get links from " + this);
        ((GatewayWrapper)client).delete(os);
    }

    protected void removeLink(Client client, String linkType, long childId) throws ServiceException, OMEROServerError, AccessException, ExecutionException, InterruptedException {
        this.removeLinks(client, linkType, Collections.singletonList(childId));
    }

    private List<AnnotationData> getAnnotationData(Client client) throws AccessException, ServiceException, ExecutionException {
        return ExceptionHandler.call(client.getMetadata(), m -> m.getAnnotations(client.getCtx(), this.data), "Cannot get annotations from " + this);
    }

    public AnnotationList getAnnotations(Client client) throws AccessException, ServiceException, ExecutionException {
        List<AnnotationData> annotationData = this.getAnnotationData(client);
        AnnotationList annotations = new AnnotationList(annotationData.size());
        annotationData.forEach(annotations::add);
        return annotations;
    }

    public void copyAnnotationLinks(Client client, AnnotatableWrapper<?> object) throws AccessException, ServiceException, ExecutionException {
        List<AnnotationData> newAnnotations = super.getAnnotationData(client);
        List<AnnotationData> oldAnnotations = this.getAnnotationData(client);
        for (AnnotationData annotation : oldAnnotations) {
            newAnnotations.removeIf(a -> a.getId() == annotation.getId());
        }
        for (AnnotationData annotation : newAnnotations) {
            this.link(client, annotation);
        }
    }
}

