/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.preview;

import ch.epfl.biop.DevilParam;
import com.google.gson.Gson;
import ij.ImagePlus;
import ij.plugin.FolderOpener;
import ij.plugin.HyperStackConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Image Processing>Open DEVILS Folder")
public class DevilsOpener
implements Command {
    @Parameter(label="Select Devils json file")
    File jsonFile;

    public void run() {
        try {
            DevilParam dp = (DevilParam)new Gson().fromJson((Reader)new FileReader(this.jsonFile.getAbsolutePath()), DevilParam.class);
            for (int it = 0; it < dp.getnSeries(); ++it) {
                String file_name_filter = dp.imageName;
                if (dp.getnSeries() > 1) {
                    file_name_filter = file_name_filter + "_s" + it + "-";
                }
                System.out.println("nSeries = " + dp.getnSeries());
                System.out.println(file_name_filter);
                ImagePlus impV = FolderOpener.open((String)dp.getOutputDir(), (String)("virtual file=[" + file_name_filter + "]"));
                System.out.println(impV.getNSlices());
                System.out.println(dp.nChannel);
                System.out.println(dp.nSlice);
                System.out.println(dp.nFrame);
                ImagePlus reordered_impV = HyperStackConverter.toHyperStack((ImagePlus)impV, (int)dp.nChannel, (int)dp.nSlice, (int)dp.nFrame, (String)"Composite");
                reordered_impV.getCalibration().pixelWidth = dp.voxelSize[0];
                reordered_impV.getCalibration().pixelHeight = dp.voxelSize[1];
                reordered_impV.getCalibration().pixelDepth = dp.voxelSize[2];
                reordered_impV.setTitle(file_name_filter);
                reordered_impV.show();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

