/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.preview;

import ch.epfl.biop.DEVILS;
import ch.epfl.biop.DevilMeasure;
import ch.epfl.biop.DevilParam;
import ch.epfl.biop.lazyprocessing.LazyImagePlusHelper;
import ch.epfl.biop.lazyprocessing.LazyVirtualStack;
import ch.epfl.biop.lazyprocessing.LocalizedImageProcessor;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.process.ImageProcessor;
import java.util.function.Function;
import org.scijava.command.Command;
import org.scijava.command.InteractiveCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Image Processing>DEVILS Preview ( Advanced )")
public class DevilsInteractiveAdvancedCommand
extends InteractiveCommand {
    @Parameter
    ImagePlus origin;
    int objectSize = 0;
    boolean advancedParam = true;
    @Parameter(required=false, label="Largest_object_size (in pixel), specify values for each channel, separated by ','")
    String objectSize_string = "";
    @Parameter(required=false, label="Minimum (for final conversion step), specify values for each channel, separated by ','")
    String min_final_string = "";
    @Parameter(required=false, label="Maximum (for final conversion step), specify values for each channel, separated by ','")
    String max_final_string = "";
    @Parameter(required=false, label="Output_bit_depth", choices={"8-bit", "16-bit", "32-bit"})
    String outputBitDepth_string = "16-bit";
    @Parameter(label="Create or Update Preview", callback="updatePreview", persist=false)
    Button buttonUpdatePreview;
    @Parameter(label="Start DEVILS with the current parameter", callback="doProcess", persist=false)
    Button button;
    DevilParam dp;
    DevilMeasure dm;
    ImagePlus liveComputedImage = null;

    public DevilsInteractiveAdvancedCommand() {
        super(new String[0]);
    }

    public void run() {
    }

    public void updatePreview() {
        IJ.log((String)("Updating preview of image " + this.origin.getTitle() + " ..."));
        this.dp = new DevilParam(this.origin, this.objectSize, this.advancedParam, this.min_final_string, this.max_final_string, this.objectSize_string, this.outputBitDepth_string);
        this.dm = new DevilMeasure(this.dp);
        Function<LocalizedImageProcessor, ImageProcessor> devilsProcessor = ipr -> DEVILS.DEVIL_ipr(this.dp, this.dm, new int[]{ipr.localizationIndex[1] - 1, ipr.localizationIndex[0] - 1, ipr.localizationIndex[2] - 1, 0}, ipr.ip);
        if (this.liveComputedImage != null && !this.liveComputedImage.isVisible()) {
            this.liveComputedImage = null;
        }
        if (this.liveComputedImage == null || this.bitDepthMismatch(this.liveComputedImage.getBitDepth(), this.outputBitDepth_string)) {
            int c = 1;
            int z = 1;
            int t = 1;
            if (this.liveComputedImage != null) {
                this.liveComputedImage.close();
                c = this.liveComputedImage.getC();
                t = this.liveComputedImage.getT();
                z = this.liveComputedImage.getZ();
            }
            this.liveComputedImage = LazyImagePlusHelper.create(this.origin, "_DEVILED", devilsProcessor);
            this.liveComputedImage.show();
            this.liveComputedImage.setPosition(c, z, t);
            this.liveComputedImage.setDisplayMode(3);
        } else if (this.liveComputedImage.getStack() instanceof LazyVirtualStack) {
            ((LazyVirtualStack)this.liveComputedImage.getStack()).updateFunction(devilsProcessor);
            LazyImagePlusHelper.redraw(this.liveComputedImage, this.origin);
            this.liveComputedImage.setDisplayMode(3);
        } else {
            this.liveComputedImage.hide();
            this.liveComputedImage.close();
            ImageProcessor ip = devilsProcessor.apply(new LocalizedImageProcessor(this.origin.getProcessor(), new int[]{1, 1, 1}));
            this.liveComputedImage = new ImagePlus();
            this.liveComputedImage.setProcessor(ip);
            this.liveComputedImage.setTitle(this.origin.getTitle() + "_DEVILED");
            this.liveComputedImage.show();
            this.liveComputedImage.setDisplayMode(3);
        }
        IJ.log((String)("Preview updated: " + this.origin.getTitle()));
    }

    private boolean bitDepthMismatch(int bitDepth, String outputBitDepth_string) {
        if (outputBitDepth_string.equals("8-bit") && bitDepth != 8) {
            return true;
        }
        if (outputBitDepth_string.equals("16-bit") && bitDepth != 16) {
            return true;
        }
        return outputBitDepth_string.equals("32-bit") && bitDepth != 32;
    }

    public void doProcess() {
        GenericDialogPlus gd = new GenericDialogPlus("DEVILS parameters");
        String defaultPath = Prefs.get((String)"ch.epfl.biop.devil.defaultPath", (String)Prefs.getImageJDir());
        boolean exportAsXmlHdf5 = Prefs.getBoolean((String)"ch.epfl.biop.devil.exportXmlHdf5", (boolean)false);
        gd.addFileField("Select_File", defaultPath);
        gd.addCheckbox("Export_XmlHdf5", exportAsXmlHdf5);
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.error((String)"canceled by user");
            return;
        }
        String params = " select_file=" + gd.getNextString();
        if (gd.getNextBoolean()) {
            params = params + " export_xmlhdf5";
        }
        params = params + " largest_object_size=" + this.objectSize;
        if (this.advancedParam) {
            params = params + " advanced_parameters";
        }
        String finalParams = params = params + " object=[" + this.objectSize_string + "] minimum=[" + this.min_final_string + "] maximum=[" + this.max_final_string + "] output_bit_depth=" + this.outputBitDepth_string + " output_directory=''";
        new Thread(() -> IJ.run((String)"DEVILS", (String)finalParams)).start();
    }
}

