/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.lazyprocessing;

import ch.epfl.biop.lazyprocessing.LocalizedImageProcessor;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LazyVirtualStack
extends VirtualStack {
    ImagePlus origin;
    Function<LocalizedImageProcessor, ImageProcessor> imageProcessorFunction;
    int resultingBitDepth;
    Map<Integer, ImageProcessor> cachedImageProcessor = new ConcurrentHashMap<Integer, ImageProcessor>();
    ImagePlus imagePlusLocalizer = null;

    public LazyVirtualStack(ImagePlus origin, Function<LocalizedImageProcessor, ImageProcessor> imageProcessorFunction) {
        this.origin = origin;
        this.imageProcessorFunction = imageProcessorFunction;
        ImageProcessor ipr = imageProcessorFunction.apply(LocalizedImageProcessor.wrap(origin.getStack().getProcessor(1)));
        if (ipr instanceof ByteProcessor) {
            this.resultingBitDepth = 8;
        } else if (ipr instanceof ShortProcessor) {
            this.resultingBitDepth = 16;
        } else if (ipr instanceof FloatProcessor) {
            this.resultingBitDepth = 32;
        } else if (ipr instanceof ColorProcessor) {
            this.resultingBitDepth = 24;
        } else {
            throw new UnsupportedOperationException("Unknown resulting ImageProcessor");
        }
    }

    public synchronized void updateFunction(Function<LocalizedImageProcessor, ImageProcessor> imageProcessorFunction) {
        this.imageProcessorFunction = imageProcessorFunction;
        this.cachedImageProcessor.clear();
    }

    public void setImagePlusCZTSLocalizer(ImagePlus imp) {
        this.imagePlusLocalizer = imp;
    }

    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    public synchronized ImageProcessor getProcessor(int n) {
        if (this.imagePlusLocalizer == null) {
            this.cachedImageProcessor.put(n, this.imageProcessorFunction.apply(LocalizedImageProcessor.wrap(this.origin.getStack().getProcessor(n))));
        } else {
            this.cachedImageProcessor.put(n, this.imageProcessorFunction.apply(new LocalizedImageProcessor(this.origin.getStack().getProcessor(n), this.imagePlusLocalizer.convertIndexToPosition(n))));
        }
        this.cachedImageProcessor.get(n).setColorModel(this.origin.getStack().getProcessor(n).getColorModel());
        return this.cachedImageProcessor.get(n);
    }

    public int getBitDepth() {
        return this.resultingBitDepth;
    }

    public int getSize() {
        return this.origin.getStack().getSize();
    }

    public int getHeight() {
        return this.origin.getHeight();
    }

    public int getWidth() {
        return this.origin.getWidth();
    }
}

