/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.lazyprocessing;

import ch.epfl.biop.lazyprocessing.LazyVirtualStack;
import ch.epfl.biop.lazyprocessing.LocalizedImageProcessor;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.HyperStackConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.util.function.Function;

public class LazyImagePlusHelper
extends ImagePlus {
    public static ImagePlus create(ImagePlus origin, String suffix, Function<LocalizedImageProcessor, ImageProcessor> imageProcessorFunction) {
        LazyVirtualStack vds = new LazyVirtualStack(origin, imageProcessorFunction);
        vds.setImagePlusCZTSLocalizer(origin);
        ImagePlus imp = new ImagePlus();
        imp.setStack("", (ImageStack)vds);
        ImagePlus out = null;
        out = origin.getNChannels() * origin.getNSlices() * origin.getNFrames() == 1 ? imp : HyperStackConverter.toHyperStack((ImagePlus)imp, (int)origin.getNChannels(), (int)origin.getNSlices(), (int)origin.getNFrames());
        out.setDisplayMode(3);
        out.setTitle(origin.getTitle() + suffix);
        if (origin.isComposite() && out.isComposite()) {
            ((CompositeImage)out).setLuts((LUT[])origin.getLuts().clone());
        }
        out.setPosition(origin.getC(), origin.getZ(), origin.getT());
        return out;
    }

    public static void redraw(ImagePlus imp, ImagePlus impOrig) {
        imp.updateImage();
        imp.updateAndDraw();
        imp.updateAndRepaintWindow();
        imp.updateChannelAndDraw();
        imp.updateVirtualSlice();
        if (imp instanceof CompositeImage) {
            CompositeImage cimp = (CompositeImage)imp;
            double[] min = new double[cimp.getNChannels()];
            double[] max = new double[cimp.getNChannels()];
            for (int i = 0; i < cimp.getNChannels(); ++i) {
                min[i] = cimp.getChannelLut((int)(i + 1)).min;
                max[i] = cimp.getChannelLut((int)(i + 1)).max;
            }
            cimp.setChannelsUpdated();
            LUT[] copied = (LUT[])impOrig.getLuts().clone();
            for (int i = 0; i < cimp.getNChannels(); ++i) {
                copied[i].min = min[i];
                copied[i].max = max[i];
            }
            ((CompositeImage)imp).setLuts(copied);
        }
    }
}

